(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5358,        177]*)
(*NotebookOutlinePosition[      6032,        201]*)
(*  CellTagsIndexPosition[      5988,        197]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(<< FeynArts`\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(<< FormCalc\\\\FormCalc.m\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(<< FormCalc\\\\tools\\\\ScanGraphics.m\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[BoxData[
    \(time1\  = \ SessionTime[]\)], "Input"],

Cell[BoxData[
    \(CKM\  = \ IndexDelta\)], "Input"],

Cell[BoxData[
    \(FortranDir\  := \ "\<fortran_brems\>"\)], "Input"]
}, Open  ]],

Cell[BoxData[{
    \(Small[ME]\  = \ \(Small[ME2]\  = \ 0\)\n\n\), 
    \(AAtt\  = 
      \ {V[1], \ V[1]}\  -> \ {\(-F[3, \ {3}]\), \ F[3, \ {3}], \ V[1]}\n\), 
    \(SetOptions[InsertFields, \n\ \ Model\  -> \ "\<SMc\>", \ 
      Restrictions\  -> \ NoLightFHCoupling]\n\), 
    \(SetOptions[CalcFeynAmp, \ Dimension\  -> \ 4]\n\), 
    \(inss\  := \ \(ins\  = \ InsertFields[tops, \ AAtt]\)\n\n\), 
    \(SetOptions[Paint, \ PaintLevel\  -> \ {Classes}, \ 
      ColumnsXRows\  -> \ {4, \ 5}]\n\n
     (*\ take\ the\ comments\ out\ if\ you\ want\ the\ diagrams\ painted\ \n
      DoPaint[diags_, \ file_]\  := \ 
        \((\n\ \ If[\ FileType["\<diagrams\>"]\  =!= \ Directory, \n\ \ \ \ 
            CreateDirectory["\<diagrams\>"]\ ]; \n\ \ Paint[diags]\n)\)\n*) \n
    \n\), 
    \(tops\  = \ CreateTopologies[0, \ 2\  -> \ 3]; \n
    DoPaint[inss, \ "\<born\>"]; \n
    born\  = \ CalcFeynAmp[CreateFeynAmp[ins]]\n\), 
    \(num\  = \ Simplify\n\), 
    \(Hel[_]\  = \ 0; \nhel\  = \ HelicityME[All, \ born]; \n
    col\  = \ ColourME[All, \ born]\n\), 
    \(abbr\  = \ Abbr[]\n\n (*\nabbr\  = \ OptimizeAbbr[Abbr[]]\n*) \), 
    \(WriteSquaredME[born, \ {}, \ hel, \ col, \ abbr, "\<fortran_brems\>", \n
      \ \ Drivers\  -> FortranDir]\n\), 
    \(WriteRenConst[0, FortranDir]\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Run["\<CompileRun.bat \>"<>\ FortranDir\ <>\ "\< - - - - - 100 150\>"]
      \)], "Input"],

Cell["\<\
ReadList[OpenRead[\"CompileRun.out\", DOSTextFormat -> True], String]\
\>", "Input"],

Cell["\<\
ReadList[OpenRead[FortranDir<>\"\\\\Run.out\", DOSTextFormat -> True], \
String]\
\>", "Input"],

Cell[BoxData[
    \(Install["\<FormCalc\\ReadData.exe\>"]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(n = ReadData[FortranDir\ <>\ "\<\\runplt\>"]\)], "Input"],

Cell[CellGroupData[{

Cell["Table[Para[x],{x,n}]", "Input"],

Cell["Table[Data[x],{x,n}]", "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"ScanPlot3D[Para[n]\[LeftDoubleBracket]1\[RightDoubleBracket]\
\[LeftDoubleBracket]1\[RightDoubleBracket], Para[n]\[LeftDoubleBracket]1\
\[RightDoubleBracket]\[LeftDoubleBracket]1\[RightDoubleBracket], n, \
MagnifyingFactor -> 1000]"], "Input"],

Cell["$MissingPoints", "Input"],

Cell[CellGroupData[{

Cell[TextData[
"ScanDensityPlot[Para[n]\[LeftDoubleBracket]1\[RightDoubleBracket]\
\[LeftDoubleBracket]1\[RightDoubleBracket], Para[n]\[LeftDoubleBracket]1\
\[RightDoubleBracket]\[LeftDoubleBracket]1\[RightDoubleBracket], n, \
RenderMissing -> RGBColor[0, 0, 1]]"], "Input"],

Cell["$MissingPoints", "Input"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Clear[DataRow]
DataRow[x_, tree_, loop_] := {x, (loop - tree)/tree}\
\>", "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Install["\<LoopTool\\LoopTools.exe\>"]\)], "Input"],

Cell["B0[1000, 50, 80]", "Input"],

Cell["InputForm[Cget[80, 80, 10000, 300, 100, 200]]", "Input"]
}, Open  ]],

Cell[BoxData[
    \(Run[\ "\<pnuglot.bat \>"<>\ FortranDir]\)], "Input"]
}, Open  ]],

Cell[BoxData[
    \(Print["\<time used: \>", \ SessionTime[]\  - \ time1]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 740}},
CellGrouping->Manual,
WindowSize->{564, 520},
WindowMargins->{{182, Automatic}, {Automatic, 34}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 80, 2, 46, "Input"],
Cell[1814, 55, 93, 2, 46, "Input"],
Cell[1910, 59, 106, 2, 46, "Input"],

Cell[CellGroupData[{
Cell[2041, 65, 58, 1, 30, "Input"],
Cell[2102, 68, 53, 1, 30, "Input"],
Cell[2158, 71, 70, 1, 30, "Input"]
}, Open  ]],
Cell[2243, 75, 1303, 24, 870, "Input"],

Cell[CellGroupData[{
Cell[3571, 103, 110, 2, 30, "Input"],
Cell[3684, 107, 94, 2, 30, "Input"],
Cell[3781, 111, 105, 3, 48, "Input"],
Cell[3889, 116, 70, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3984, 121, 77, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[4086, 126, 37, 0, 30, "Input"],
Cell[4126, 128, 37, 0, 30, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4212, 134, 259, 4, 48, "Input"],
Cell[4474, 140, 31, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[4530, 144, 274, 4, 48, "Input"],
Cell[4807, 150, 31, 0, 30, "Input"]
}, Open  ]]
}, Open  ]],
Cell[4865, 154, 92, 3, 48, "Input"],

Cell[CellGroupData[{
Cell[4982, 161, 71, 1, 30, "Input"],
Cell[5056, 164, 33, 0, 30, "Input"],
Cell[5092, 166, 62, 0, 30, "Input"]
}, Open  ]],
Cell[5169, 169, 72, 1, 30, "Input"]
}, Open  ]],
Cell[5256, 173, 86, 1, 30, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

