/*
 * This file automatically produced by c:\Program Files\Wolfram Research\Mathematica\3.0\AddOns\MathLink\DevelopersKits\Windows\CompilerAdditions\mldev32\bin\mprep.exe from:
 *	ReadForm.tm
 * mprep Revision 9 Copyright (c) Wolfram Research, Inc. 1990-2000
 */

#define MPREP_REVISION 9


#include "mathlink.h"

int MLAbort = 0;
int MLDone  = 0;
long MLSpecialCharacter = '\0';
HANDLE MLInstance = (HANDLE)0;
HWND MLIconWindow = (HWND)0;

MLINK stdlink = 0;
MLEnvironment stdenv = 0;
MLYieldFunctionObject stdyielder = 0;
MLMessageHandlerObject stdhandler = 0;

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#if WIN32_MATHLINK && !defined(_fstrncpy)
#       define _fstrncpy strncpy
#endif

#ifndef CALLBACK
#define CALLBACK FAR PASCAL
typedef LONG LRESULT;
typedef unsigned int UINT;
typedef WORD WPARAM;
typedef DWORD LPARAM;
#endif


LRESULT CALLBACK MLEXPORT
IconProcedure( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

LRESULT CALLBACK MLEXPORT
IconProcedure( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch( msg){
	case WM_CLOSE:
		MLDone = 1;
		MLAbort = 1;
		break;
	case WM_QUERYOPEN:
		return 0;
	}
	return DefWindowProc( hWnd, msg, wParam, lParam);
}

#define _APISTR(i) #i
#define APISTR(i) _APISTR(i)

HWND MLInitializeIcon( HINSTANCE hInstance, int nCmdShow)
{
	char path_name[260], *icon_name;
	WNDCLASS  wc;
	HMODULE hdll;

	MLInstance = hInstance;
	if( ! nCmdShow) return (HWND)0;
#if WIN16_MATHLINK
	hdll = GetModuleHandle( "ml16i" APISTR(MLINTERFACE));
#else
	hdll = GetModuleHandle( "ml32i" APISTR(MLINTERFACE));
#endif

	(void)GetModuleFileName( hInstance, path_name, sizeof(path_name));
	icon_name = strrchr( path_name, '\\') + 1;
	*strchr( icon_name, '.') = '\0';

	wc.style = 0;
	wc.lpfnWndProc = IconProcedure;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	if( hdll)
		wc.hIcon = LoadIcon( hdll, "MLIcon");
	else
		wc.hIcon = LoadIcon( NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor( NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject( WHITE_BRUSH);
	wc.lpszMenuName =  (LPSTR) 0;
	wc.lpszClassName = "mprepIcon";
	(void)RegisterClass( &wc);

	MLIconWindow = CreateWindow( "mprepIcon", icon_name,
			WS_OVERLAPPEDWINDOW | WS_MINIMIZE, CW_USEDEFAULT,
			CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
			(HWND)0, (HMENU)0, hInstance, (void FAR*)0);

	if( MLIconWindow){
		ShowWindow( MLIconWindow, SW_MINIMIZE);
		UpdateWindow( MLIconWindow);
	}
	return MLIconWindow;
}


#if __BORLANDC__
#pragma argsused
#endif

MLYDEFN( devyield_result, MLDefaultYielder, ( MLINK mlp, MLYieldParameters yp))
{
	MSG msg;

#if !__BORLANDC__
	mlp = mlp; /* suppress unused warning */
	yp = yp; /* suppress unused warning */
#endif

	if( PeekMessage( &msg, (HWND)0, 0, 0, PM_REMOVE)){
		TranslateMessage( &msg);
		DispatchMessage( &msg);
	}
	return MLDone;
}


/********************************* end header *********************************/


# line 25 "ReadForm.tm"
/*
	ReadForm.tm
		reads FORM output back into Mathematica
		this file is part of FormCalc
		last modified 2 Jan 02 th
*/

#define _fstrncpy
#include "mathlink.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char copyleft[] =
  "@(#) ReadForm utility for FormCalc, 2 Jan 02 Thomas Hahn";

#define MAXEXPR 1000
#define TERMBUF 1000000
#define STRINGSIZE 32767

#ifndef MLCONST
#define MLCONST
#endif


/*

A term in the FORM output is organized into the TERM structure
in the following way:

 ____4_____     __3___     __2___     ___0___     _____1_____
/          \   /      \   /      \   /       \   /           \
SumOver(...) * Mat(...) * Den(...) * pave(...) * ..... * (...)

Hierarchy of collecting:
4. SumOver
3. Mat
2. Den
1. [coefficient]
0. pave

*/

#define LEVEL_PAVE 0
#define LEVEL_COEFF 1
#define LEVEL_DEN 2
#define LEVEL_MAT 3
#define LEVEL_SUMOVER 4
#define LEVELS 5

typedef struct {
  char *name;
  int level;
} FUN;

FUN funtab[] = {
  {"SumOver", LEVEL_SUMOVER},
  {"Mat",     LEVEL_MAT},
  {"Den",     LEVEL_DEN},
  {"pave",    LEVEL_PAVE}
};

typedef struct term {
  struct term *last;
  char *f[LEVELS];
  int nterms[LEVELS], coll;
} TERM;

typedef struct btree {
  struct btree *lt, *gt;
  char *sym;
  char abb[0];
} BTREE;

char *tok;
TERM *termp, *old1;
int maxintsize;
char zero[] = "";
BTREE *root = NULL;


void report_error(MLCONST char *tag, const char *arg)
{
  int p;

  MLPutFunction(stdlink, "EvaluatePacket", 1);
  MLPutFunction(stdlink, "Message", arg ? 2 : 1);
  MLPutFunction(stdlink, "MessageName", 2);
  MLPutSymbol(stdlink, "ReadForm");
  MLPutString(stdlink, tag);
  if( arg ) MLPutString(stdlink, arg);
  MLEndPacket(stdlink);

  do {
    p = MLNextPacket(stdlink);
    MLNewPacket(stdlink);
  } while( p != RETURNPKT );
}


char *getabbr(char *s)
{
  BTREE *lp, **node = &root;
  MLCONST char *mmares;
  int p;

  while( (lp = *node) ) {
    p = strcmp(s, lp->abb);
    if( p == 0 ) return lp->sym;
    node = p < 0 ? &lp->lt : &lp->gt;
  }

  MLPutFunction(stdlink, "EvaluatePacket", 1);
  MLPutFunction(stdlink, "ToString", 1);
  MLPutFunction(stdlink, "ToExpression", 1);
  MLPutString(stdlink, s);
  MLEndPacket(stdlink);

  while( MLNextPacket(stdlink) != RETURNPKT )
    MLNewPacket(stdlink);
  MLGetString(stdlink, &mmares);

  p = strlen(s);
  lp = malloc(p + strlen(mmares) + 2 + sizeof(BTREE));
  lp->lt = lp->gt = NULL;
  *node = lp;
  strcpy(lp->abb, s);
  s = lp->sym = lp->abb + p + 1;
  strcpy(s, mmares);

  MLDisownString(stdlink, mmares);
  return s;
}


TERM *downsize(TERM *tp, char *end)
{
  TERM *new;
  char **f;
  int off;

  new = realloc(tp, end - (char *)tp);
  if( (off = (char *)tp - (char *)new) ) {
    for(f = new->f; f < &new->f[LEVELS]; ++f)
      if( *f >= (char *)tp && *f <= end ) *f -= off;
  }
  return new;
}


char *putfac(char *to, char *from)
{
  if( *from ) return memccpy(to, from, 0, STRINGSIZE);
  *to++ = '1';
  *to++ = 0;
  return to;
}


void collect_pave()
{
  TERM *tp, *old;
  char *s;
  int i;

  do {
    for(old = termp; (tp = old->last); ) {
      for(i = LEVEL_PAVE + 1; i < LEVELS; ++i)
        if( strcmp(termp->f[i], tp->f[i]) ) {
          old = tp;
          goto loop;
        }
      if( termp->coll == 0 ) {
        s = termp->f[LEVEL_PAVE];
        s = putfac(termp->f[LEVEL_PAVE] = malloc(maxintsize), s);
        termp->coll = 1;
      }
      *(s - 1) = '+';
      s = putfac(s, tp->f[LEVEL_PAVE]);
      old->last = tp->last;
      free(tp);
loop: ;
    }
    if( termp->coll ) termp->f[LEVEL_PAVE] =
      realloc(termp->f[LEVEL_PAVE], s - termp->f[LEVEL_PAVE]);
  } while( (termp = termp->last) );
}


void orderchain(TERM *t1p, int level)
{
  TERM *t2p, *old2, *ini;
  int c = 0, c2, *nterms = &t1p->nterms[level];

  do {
    ++c;
    c2 = 0;
    ini = t1p;
    do {
      ++c2;
      old1 = t1p;
      t1p = old1->last;
      if( t1p == NULL ) goto next;
    } while( strcmp(ini->f[level], t1p->f[level]) == 0 );
    t2p = t1p;
    do {
      old2 = t2p;
over:
      t2p = old2->last;
      if( t2p == NULL ) goto next;
    } while( strcmp(ini->f[level], t2p->f[level]) );
    old1->last = t2p;
    old1 = t2p;
    old2->last = t2p->last;
    ++c2;
    goto over;
next:
    if( level > LEVEL_COEFF ) {
      old1->last = NULL;
      orderchain(ini, level - 1);
    }
    else ini->nterms[level - 1] = c2;
  } while( (old1->last = t1p) );
  *nterms = c;
}


TERM *transmit(TERM *tp, int level)
{
  int n = tp->nterms[level], ntimes, i;

  if( level == LEVEL_SUMOVER ) MLPutFunction(stdlink, "List", n);
  else if( n > 1 ) MLPutFunction(stdlink, "Plus", n);

  while(n--) {
    ntimes = *tp->f[level] != 0;
    for(i = level - 1; i > LEVEL_PAVE; --i) {
      ++ntimes;
      if( tp->nterms[i] > 1 ) goto sendit;
      if( *tp->f[i] == 0 ) --ntimes;
    }
	/* orderchain goes down only to LEVEL_COEFF, hence: */
    if( *tp->f[LEVEL_PAVE] ) ++ntimes;
sendit:
    switch(ntimes) {
    case 0:
      MLPutInteger(stdlink, 1);
      break;
    default:
      MLPutFunction(stdlink, "Times", ntimes);
    case 1:
      if( *tp->f[level] ) {
        MLPutFunction(stdlink, "ToExpression", 1);
        MLPutString(stdlink, tp->f[level]);
      }
      for(i = level - 1; i > LEVEL_PAVE; --i) {
        if( tp->nterms[i] > 1 ) {
          tp = transmit(tp, i);
          goto loop;
        }
        if( *tp->f[i] ) {
          MLPutFunction(stdlink, "ToExpression", 1);
          MLPutString(stdlink, tp->f[i]);
        }
      }
      if( *tp->f[LEVEL_PAVE] ) {
        MLPutFunction(stdlink, "ToExpression", 1);
        MLPutString(stdlink, tp->f[LEVEL_PAVE]);
      }
    }
    tp = tp->last;
loop: ;
  }
  return tp;
}


void readform(const char *filename)
{
  FILE *file;
  char line[1024], *si, *di, *ind, *delim, *beg, **pp;
  char *er, errmsg[512], *erp = errmsg;
  char brackets[20], *br = brackets;
  int inexpr = 0, thislev, newlev;
  TERM *expressions[MAXEXPR], **exprp = expressions, **ep;
  TERM *tp, *last;
  FUN *funp;

  file = *filename == '!' ?
    popen(filename + 1, "r") : fopen(filename, "r");
  if( file == NULL ) {
    report_error("noopen", filename);
    MLPutFunction(stdlink, "Abort", 0);
    MLEndPacket(stdlink);
    return;
  }

  termp = NULL;
  maxintsize = 0;

  for( ; ; ) {

nextline:
    do {
      if( MLAbort ) goto abort;
      if( feof(file) ) {
        if( erp > errmsg ) {
          *(erp - 1) = 0;	/* discard last \n */
          report_error("formerror", errmsg);
          goto abort;
        }
        inexpr = (int)(exprp - expressions);
        if( inexpr == 0 ) {
          report_error("nooutput", NULL);
          goto abort;
        }
        MLPutFunction(stdlink, "List", inexpr);
        for(ep = expressions; ep < exprp; ++ep) {
          orderchain(*ep, LEVELS - 1);
          transmit(*ep, LEVELS - 1);
        }
        goto quit;
      }
      *line = 0;
      si = fgets(line, sizeof(line), file);
      if( (er = strstr(line, "-->")) ||
          (er = strstr(line, "==>")) ||
          (er = strstr(line, "===")) ) {
        er += 4;
        *erp = 0;
        if( !strstr(errmsg, er) &&
            (int)(erp - errmsg) + strlen(er) < sizeof(errmsg) )
          erp = memccpy(erp, er, '\n', sizeof(errmsg));
      }
      if( inexpr && *line == '\n' ) {
        *di++ = 0;
        termp = downsize(termp, di);
        goto newterm;
      }
      if( !inexpr && (er = strchr(line, '=')) ) {
newterm:
        tp = malloc(sizeof(TERM) + TERMBUF);
        beg = delim = di = (char *)tp + sizeof(TERM);
        tp->last = termp;
        termp = tp;
        for(pp = tp->f; pp < tp->f + LEVELS; ++pp) *pp = zero;
        tp->f[thislev = LEVEL_COEFF] = di;
        tp->coll = 0;
        if( inexpr ) goto nextline;
        inexpr = 1;
        si = er + 1;
        break;
      }
    } while( !inexpr || erp > errmsg );

    for( ; *si; ++si)
      if( *si > ' ' ) switch(*si) {
      case '+':
      case '-':
      case '*':
        *di++ = *si;
        if( br == brackets ) delim = di;
        break;

      case '(':
        if( br == brackets ) {
          *di = 0;
          newlev = LEVEL_COEFF;
          for(funp = funtab;
              funp < &funtab[sizeof(funtab)/sizeof(FUN)];
              ++funp)
            if( strcmp(delim, funp->name) == 0 ) {
              newlev = funp->level;
              break;
            }
          if( thislev != newlev ) {
            if( delim > beg ) *(delim - 1) = 0;
            switch(thislev) {
            case LEVEL_MAT:
              termp->f[LEVEL_MAT] = getabbr(termp->f[LEVEL_MAT]);
              break;
            case LEVEL_PAVE:
              maxintsize += (int)(delim - termp->f[LEVEL_PAVE]) + 2;
            }
            termp->f[thislev = newlev] = delim;
          }
        }
        if( di == beg || strchr("+-*/^,([", *(di - 1)) )
          *di++ = '(', *br++ = ')';
        else *di++ = '[', *br++ = ']';
        break;
      case ')':
        *di++ = *--br;
        break;

      case ';':
        *di++ = 0;
        *exprp++ = termp = downsize(termp, di);
        if( exprp >= expressions + MAXEXPR ) {
          report_error("toomany", NULL);
          goto abort;
        }
        if( maxintsize ) collect_pave();
        termp = NULL;
        maxintsize = inexpr = 0;
        goto nextline;

      case '_':
        if( *(di - 1) == 'i' ) *(di - 1) = 'I';
        else *di++ = '$';
        break;
      case '?':
        ind = di - 2;
        do *(ind + 3) = *ind; while( *--ind != 'N' );
        *ind++ = 'L';
        *ind++ = 'o';
        *ind++ = 'r';
        *ind++ = '[';
        di += 2;
        *di++ = ']';
        break;
      default:
        *di++ = *si;
        break;
      }
  }

abort:
  MLPutFunction(stdlink, "Abort", 0);
quit:
  MLEndPacket(stdlink);
  while( exprp > expressions )
    for(tp = *--exprp; tp; tp = last) {
      if( tp->coll ) free(tp->f[LEVEL_PAVE]);
      last = tp->last;
      free(tp);
    }
  (*filename == '!' ? pclose : fclose)(file);
}


void cutbranch(BTREE *node)
{
  if( node ) {
    cutbranch(node->lt);
    cutbranch(node->gt);
    free(node);
  }
}

void clearcache(void)
{
  cutbranch(root);
  root = NULL;
  MLPutSymbol(stdlink, "Null");
  MLEndPacket(stdlink);
}


main(int argc, char **argv)
{
  return MLMain(argc, argv);
}

# line 595 "ReadForm.c"


void readform P(( kcharp_ct _tp1));

#if MLPROTOTYPES
static int _tr0( MLINK mlp)
#else
static int _tr0(mlp) MLINK mlp;
#endif
{
	int	res = 0;
	kcharp_ct _tp1;
	if ( ! MLGetString( mlp, &_tp1) ) goto L0;
	if ( ! MLNewPacket(mlp) ) goto L1;

	readform(_tp1);

	res = 1;
L1:	MLDisownString(mlp, _tp1);

L0:	return res;
} /* _tr0 */


void clearcache P(( void));

#if MLPROTOTYPES
static int _tr1( MLINK mlp)
#else
static int _tr1(mlp) MLINK mlp;
#endif
{
	int	res = 0;
	if ( ! MLNewPacket(mlp) ) goto L0;
	if( !mlp) return res; /* avoid unused parameter warning */

	clearcache();

	res = 1;

L0:	return res;
} /* _tr1 */


static struct func {
	int   f_nargs;
	int   manual;
	int   (*f_func)P((MLINK));
	char  *f_name;
	} _tramps[2] = {
		{ 1, 0, _tr0, "readform" },
		{ 0, 0, _tr1, "clearcache" }
		};

static char* evalstrs[] = {
	"ReadForm::noopen = \"Cannot open `1`.\"",
	(char*)0,
	"ReadForm::nooutput =   \"Something went wrong, there was no outpu",
	"t from FORM.\"",
	(char*)0,
	"ReadForm::toomany =   \"Too many expressions. Increase MAXEXPR in",
	" ReadForm.tm.\"",
	(char*)0,
	"ReadForm::formerror = \"`1`\"",
	(char*)0,
	(char*)0
};
#define CARDOF_EVALSTRS 4

static int _definepattern P(( MLINK, char*, char*, int));

static int _doevalstr P(( MLINK, int));

int  _MLDoCallPacket P(( MLINK, struct func[], int));


#if MLPROTOTYPES
int MLInstall( MLINK mlp)
#else
int MLInstall(mlp) MLINK mlp;
#endif
{
	int _res;
	_res = MLConnect(mlp);
	if (_res) _res = _definepattern(mlp, "ReadForm[filename_String]", "{filename}", 0);
	if (_res) _res = _definepattern(mlp, "ClearCache[]", "{}", 1);
	if (_res) _res = _doevalstr( mlp, 0);
	if (_res) _res = _doevalstr( mlp, 1);
	if (_res) _res = _doevalstr( mlp, 2);
	if (_res) _res = _doevalstr( mlp, 3);
	if (_res) _res = MLPutSymbol( mlp, "End");
	if (_res) _res = MLFlush( mlp);
	return _res;
} /* MLInstall */


#if MLPROTOTYPES
int MLDoCallPacket( MLINK mlp)
#else
int MLDoCallPacket( mlp) MLINK mlp;
#endif
{
	return _MLDoCallPacket( mlp, _tramps, 2);
} /* MLDoCallPacket */

/******************************* begin trailer ********************************/

#ifndef EVALSTRS_AS_BYTESTRINGS
#	define EVALSTRS_AS_BYTESTRINGS 1
#endif

#if CARDOF_EVALSTRS
static int  _doevalstr( MLINK mlp, int n)
{
	long bytesleft, charsleft, bytesnow;
#if !EVALSTRS_AS_BYTESTRINGS
	long charsnow;
#endif
	char **s, **p;
	char *t;

	s = evalstrs;
	while( n-- > 0){
		if( *s == 0) break;
		while( *s++ != 0){}
	}
	if( *s == 0) return 0;
	bytesleft = 0;
	charsleft = 0;
	p = s;
	while( *p){
		t = *p; while( *t) ++t;
		bytesnow = t - *p;
		bytesleft += bytesnow;
		charsleft += bytesnow;
#if !EVALSTRS_AS_BYTESTRINGS
		t = *p;
		charsleft -= MLCharacterOffset( &t, t + bytesnow, bytesnow);
		/* assert( t == *p + bytesnow); */
#endif
		++p;
	}


	MLPutNext( mlp, MLTKSTR);
#if EVALSTRS_AS_BYTESTRINGS
	p = s;
	while( *p){
		t = *p; while( *t) ++t;
		bytesnow = t - *p;
		bytesleft -= bytesnow;
		MLPut8BitCharacters( mlp, bytesleft, (unsigned char*)*p, bytesnow);
		++p;
	}
#else
	MLPut7BitCount( mlp, charsleft, bytesleft);
	p = s;
	while( *p){
		t = *p; while( *t) ++t;
		bytesnow = t - *p;
		bytesleft -= bytesnow;
		t = *p;
		charsnow = bytesnow - MLCharacterOffset( &t, t + bytesnow, bytesnow);
		/* assert( t == *p + bytesnow); */
		charsleft -= charsnow;
		MLPut7BitCharacters(  mlp, charsleft, *p, bytesnow, charsnow);
		++p;
	}
#endif
	return MLError( mlp) == MLEOK;
}
#endif /* CARDOF_EVALSTRS */


static int  _definepattern( MLINK mlp, char *patt, char *args, int func_n)
{
	MLPutFunction( mlp, "DefineExternal", (long)3);
	  MLPutString( mlp, patt);
	  MLPutString( mlp, args);
	  MLPutInteger( mlp, func_n);
	return !MLError(mlp);
} /* _definepattern */


int _MLDoCallPacket( MLINK mlp, struct func functable[], int nfuncs)
{
	long len;
	int n, res = 0;
	struct func* funcp;

	if( ! MLGetInteger( mlp, &n) ||  n < 0 ||  n >= nfuncs) goto L0;
	funcp = &functable[n];

	if( funcp->f_nargs >= 0
	&& ( ! MLCheckFunction(mlp, "List", &len)
	     || ( !funcp->manual && (len != funcp->f_nargs))
	     || (  funcp->manual && (len <  funcp->f_nargs))
	   )
	) goto L0;

	stdlink = mlp;
	res = (*funcp->f_func)( mlp);

L0:	if( res == 0)
		res = MLClearError( mlp) && MLPutSymbol( mlp, "$Failed");
	return res && MLEndPacket( mlp) && MLNewPacket( mlp);
} /* _MLDoCallPacket */


mlapi_packet MLAnswer( MLINK mlp)
{
	mlapi_packet pkt = 0;

	while( !MLDone && !MLError(mlp)
	&& (pkt = MLNextPacket(mlp), pkt) && pkt == CALLPKT){
		MLAbort = 0;
		if( !MLDoCallPacket(mlp)) pkt = 0;
	}
	MLAbort = 0;
	return pkt;
}



/*
	Module[ { me = $ParentLink},
		$ParentLink = contents of RESUMEPKT;
		Message[ MessageName[$ParentLink, "notfe"], me];
		me]
*/

static int refuse_to_be_a_frontend( MLINK mlp)
{
	int pkt;

	MLPutFunction( mlp, "EvaluatePacket", 1);
	  MLPutFunction( mlp, "Module", 2);
	    MLPutFunction( mlp, "List", 1);
		  MLPutFunction( mlp, "Set", 2);
		    MLPutSymbol( mlp, "me");
	        MLPutSymbol( mlp, "$ParentLink");
	  MLPutFunction( mlp, "CompoundExpression", 3);
	    MLPutFunction( mlp, "Set", 2);
	      MLPutSymbol( mlp, "$ParentLink");
	      MLTransferExpression( mlp, mlp);
	    MLPutFunction( mlp, "Message", 2);
	      MLPutFunction( mlp, "MessageName", 2);
	        MLPutSymbol( mlp, "$ParentLink");
	        MLPutString( mlp, "notfe");
	      MLPutSymbol( mlp, "me");
	    MLPutSymbol( mlp, "me");
	MLEndPacket( mlp);

	while( (pkt = MLNextPacket( mlp), pkt) && pkt != SUSPENDPKT)
		MLNewPacket( mlp);
	MLNewPacket( mlp);
	return MLError( mlp) == MLEOK;
}


int MLEvaluate( MLINK mlp, charp_ct s)
{
	if( MLAbort) return 0;
	return MLPutFunction( mlp, "EvaluatePacket", 1L)
		&& MLPutFunction( mlp, "ToExpression", 1L)
		&& MLPutString( mlp, s)
		&& MLEndPacket( mlp);
}


int MLEvaluateString( MLINK mlp, charp_ct s)
{
	int pkt;
	if( MLAbort) return 0;
	if( MLEvaluate( mlp, s)){
		while( (pkt = MLAnswer( mlp), pkt) && pkt != RETURNPKT)
			MLNewPacket( mlp);
		MLNewPacket( mlp);
	}
	return MLError( mlp) == MLEOK;
} /* MLEvaluateString */


#if __BORLANDC__
#pragma argsused
#endif

MLMDEFN( void, MLDefaultHandler, ( MLINK mlp, unsigned long message, unsigned long n))
{
#if !__BORLANDC__
	mlp = (MLINK)0; /* suppress unused warning */
	n = 0;          /* suppress unused warning */
#endif

	switch (message){
	case MLTerminateMessage:
		MLDone = 1;
	case MLInterruptMessage:
	case MLAbortMessage:
		MLAbort = 1;
	default:
		return;
	}
}



static int _MLMain( charpp_ct argv, charpp_ct argv_end, charp_ct commandline)
{
	MLINK mlp;
	long err;

	if( !stdenv)
		stdenv = MLInitialize( (MLParametersPointer)0);
	if( stdenv == (MLEnvironment)0) goto R0;

	if( !stdyielder)
		stdyielder = MLCreateYieldFunction( stdenv,
			NewMLYielderProc( MLDefaultYielder), 0);
	if( !stdhandler)
		stdhandler = MLCreateMessageHandler( stdenv,
			NewMLHandlerProc( MLDefaultHandler), 0);


	mlp = commandline
		? MLOpenString( stdenv, commandline, &err)
		: MLOpenArgv( stdenv, argv, argv_end, &err);
	if( mlp == (MLINK)0){
		MLAlert( stdenv, MLErrorString( stdenv, err));
		goto R1;
	}

	if( MLIconWindow){
		char textbuf[64];
		int len;
		len = GetWindowText(MLIconWindow, textbuf, sizeof(textbuf)-2);
		strcat( textbuf + len, "(");
		_fstrncpy( textbuf + len + 1, MLName(mlp), sizeof(textbuf) - len - 3);
		textbuf[sizeof(textbuf) - 2] = '\0';
		strcat( textbuf, ")");
		SetWindowText( MLIconWindow, textbuf);
	}

	if( MLInstance){
		if( stdyielder) MLSetYieldFunction( mlp, stdyielder);
		if( stdhandler) MLSetMessageHandler( mlp, stdhandler);
	}

	if( MLInstall( mlp))
		while( MLAnswer( mlp) == RESUMEPKT){
			if( ! refuse_to_be_a_frontend( mlp)) break;
		}

	MLClose( mlp);
R1:	MLDeinitialize( stdenv);
	stdenv = (MLEnvironment)0;
R0:	return !MLDone;
} /* _MLMain */


int MLMainString( charp_ct commandline)
{
	return _MLMain( (charpp_ct)0, (charpp_ct)0, commandline);
}

int MLMainArgv( char** argv, char** argv_end) /* note not FAR pointers */
{   
	static char FAR * far_argv[128];
	int count = 0;
	
	while(argv < argv_end)
		far_argv[count++] = *argv++;
		 
	return _MLMain( far_argv, far_argv + count, (charp_ct)0);

}

int MLMain( int argc, charpp_ct argv)
{
 	return _MLMain( argv, argv + argc, (charp_ct)0);
}
 
