(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4916,        167]*)
(*NotebookOutlinePosition[      5589,        191]*)
(*  CellTagsIndexPosition[      5545,        187]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(<< FeynArts`\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(<< FormCalc\\\\FormCalc.m\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(<< FormCalc\\\\tools\\\\ScanGraphics.m\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(FortranDir := "\<fortran_smbgf\>"\)], "Input"],

Cell[BoxData[
    \(<< \ FormCalc\\\\examples\\\\ZZZZ\\\\ZZZZ_smbgf.m\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Run["\<CompileRun.bat \>"<>\ FortranDir\ <>\ "\< t t t t 100 150\>"]\)],
   "Input"],

Cell[CellGroupData[{

Cell["\<\
ReadList[OpenRead[\"CompileRun.out\", DOSTextFormat -> True], String]\
\>", "Input"],

Cell["\<\
ReadList[OpenRead[FortranDir<>\"\\\\Run.out\", DOSTextFormat -> True], \
String]\
\>", "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Install["\<FormCalc\\ReadData.exe\>"]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(n = ReadData[FortranDir\ <>\ "\<\\runplt\>"]\)], "Input"],

Cell[CellGroupData[{

Cell["Table[Para[x],{x,n}]", "Input"],

Cell["Table[Data[x],{x,n}]", "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"ScanPlot3D[Para[n]\[LeftDoubleBracket]1\[RightDoubleBracket]\
\[LeftDoubleBracket]1\[RightDoubleBracket], Para[n]\[LeftDoubleBracket]1\
\[RightDoubleBracket]\[LeftDoubleBracket]1\[RightDoubleBracket], n, \
MagnifyingFactor -> 1000]"], "Input"],

Cell["$MissingPoints", "Input"],

Cell[CellGroupData[{

Cell[TextData[
"ScanDensityPlot[Para[n]\[LeftDoubleBracket]1\[RightDoubleBracket]\
\[LeftDoubleBracket]1\[RightDoubleBracket], Para[n]\[LeftDoubleBracket]1\
\[RightDoubleBracket]\[LeftDoubleBracket]1\[RightDoubleBracket], n, \
RenderMissing -> RGBColor[0, 0, 1]]"], "Input"],

Cell["$MissingPoints", "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Clear[DataRow]
DataRow[x_, tree_, loop_] := {x, (loop - tree)/tree}\
\>", "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Install["\<LoopTool\\LoopTools.exe\>"]\)], "Input"],

Cell[TextData[
"B0[Para[n]\[LeftDoubleBracket]1\[RightDoubleBracket]\[LeftDoubleBracket]2\
\[RightDoubleBracket], Para[n]\[LeftDoubleBracket]2\[RightDoubleBracket]\
\[LeftDoubleBracket]2\[RightDoubleBracket],Para[n]\[LeftDoubleBracket]3\
\[RightDoubleBracket]\[LeftDoubleBracket]2\[RightDoubleBracket]]"], "Input"],

Cell[TextData[
"InputForm[Cget[Para[n]\[LeftDoubleBracket]1\[RightDoubleBracket]\
\[LeftDoubleBracket]2\[RightDoubleBracket], Para[n]\[LeftDoubleBracket]2\
\[RightDoubleBracket]\[LeftDoubleBracket]2\[RightDoubleBracket],Para[n]\
\[LeftDoubleBracket]3\[RightDoubleBracket]\[LeftDoubleBracket]2\
\[RightDoubleBracket], \n\tPara[n]\[LeftDoubleBracket]4\[RightDoubleBracket]\
\[LeftDoubleBracket]2\[RightDoubleBracket], Para[n]\[LeftDoubleBracket]5\
\[RightDoubleBracket]\[LeftDoubleBracket]2\[RightDoubleBracket],Para[n]\
\[LeftDoubleBracket]6\[RightDoubleBracket]\[LeftDoubleBracket]2\
\[RightDoubleBracket]]]"], "Input"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
    \(Run[\ "\<pnuglot.bat \>"<>\ FortranDir]\)], "Input"]
}, Open  ]],

Cell[BoxData[
    \(Print["\<time used: \>", \ SessionTime[]\  - \ time1]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 740}},
CellGrouping->Manual,
WindowSize->{596, 515},
WindowMargins->{{91, Automatic}, {Automatic, 11}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 80, 2, 46, "Input"],
Cell[1814, 55, 93, 2, 46, "Input"],
Cell[1910, 59, 106, 2, 46, "Input"],
Cell[2019, 63, 66, 1, 30, "Input"],
Cell[2088, 66, 82, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2195, 71, 104, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[2324, 77, 94, 2, 30, "Input"],
Cell[2421, 81, 105, 3, 48, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2563, 89, 70, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2658, 94, 77, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2760, 99, 37, 0, 30, "Input"],
Cell[2800, 101, 37, 0, 30, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[2898, 108, 259, 4, 30, "Input"],
Cell[3160, 114, 31, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[3216, 118, 274, 4, 48, "Input"],
Cell[3493, 124, 31, 0, 30, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3573, 130, 92, 3, 48, "Input"],

Cell[CellGroupData[{
Cell[3690, 137, 71, 1, 30, "Input"],
Cell[3764, 140, 314, 4, 30, "Input"],
Cell[4081, 146, 619, 9, 48, "Input"]
}, Open  ]]
}, Open  ]],
Cell[4727, 159, 72, 1, 30, "Input"]
}, Open  ]],
Cell[4814, 163, 86, 1, 30, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

