(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   5113278,     162949]*)
(*NotebookOutlinePosition[   5113952,     162973]*)
(*  CellTagsIndexPosition[   5113908,     162969]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(<< FeynArts`\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"FeynArts 3"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"by Hagen Eck, Sepp Kueblbeck, and Thomas Hahn"\)], 
  "Print"],

Cell[BoxData[
    \(TraditionalForm\`"last revised 19 Oct 01"\)], "Print"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< FormCalc\\\\FormCalc.m\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"FormCalc 3.1"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"by Thomas Hahn"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"last revised 4 Feb 02"\)], "Print"]
}, Open  ]],

Cell[BoxData[
    \(<< FormCalc\\\\tools\\\\ScanGraphics.m\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[BoxData[
    \(time1\  = \ SessionTime[]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`1.70300000000000011`\)], "Output"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CKM\  = \ IndexDelta\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`IndexDelta\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(FortranDir\  := \ "\<fortran_mssm\>"\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[Paint, \ PaintLevel\  -> \ {Classes}, \ 
      ColumnsXRows\  -> \ {4, \ 5}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm
    \`{PaintLevel \[Rule] {Classes}, ColumnsXRows \[Rule] {4, 5}, 
      AutoEdit \[Rule] True, SheetHeader \[Rule] Automatic, 
      Numbering \[Rule] Full, FieldNumbers \[Rule] False, 
      DisplayFunction \[RuleDelayed] $DisplayFunction}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \( (*\ take\ the\ comments\ out\ if\ you\ want\ the\ diagrams\ painted\n
      DoPaint[diags_, \ file_]\  := \ 
        \((\n\ \ If[\ FileType["\<diagrams\>"]\  =!= \ Directory, \n\ \ \ \ 
            CreateDirectory["\<diagrams\>"]\ ]; \n\ \ 
          Paint[diags, \n\ \ \ \ 
            DisplayFunction\  -> \ 
              \((Display["\<diagrams/\>"\ <>\ file\ <>\ "\<.ps\>", \ #]&)\)]
            \n)\)\n*) \)], "Input"],

Cell[BoxData[
    \(\( (*\ 
      Tweeked\ the\ Paint\  - \ 
        Turned\ off\ .ps\ out\ and\ added\ the\ Topology\ Editor\ switch\ *) 
      \nDoPaint[diags_, \ file_]\  := \ 
      \((\n\ \ If[\ FileType["\<diagrams\>"]\  =!= \ Directory, \n\ \ \ \ 
          CreateDirectory["\<diagrams\>"]\ ]; \n\ \ 
        Paint[diags, \ \ AutoEdit\  -> \ True]\n)\)\n\)\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Small[ME]\  = \ \(Small[ME2]\  = \ 0\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`0\)], "Output"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eeHH\  = 
      \ {\(-F[2, \ {1}]\), \ F[2, \ {1}]}\  -> \ {\(-S[5]\), \ S[5]}\)], 
  "Input"],

Cell[BoxData[
    \(TraditionalForm
    \`{\(-\(F(2, {1})\)\), F(2, {1})} \[Rule] {\(-\(S(5)\)\), S(5)}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[InsertFields, \n\ \ Model\  -> \ "\<MSSM\>", \ 
      Restrictions\  -> \ NoLightFHCoupling]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm
    \`{Model \[Rule] "MSSM", GenericModel \[Rule] "Lorentz", 
      InsertionLevel \[Rule] Classes, ExcludeParticles \[Rule] {}, 
      LastSelections \[Rule] {}, ExcludeFieldPoints \[Rule] {}, 
      Restrictions \[Rule] NoLightFHCoupling}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(inss\  := \ \(ins\  = \ InsertFields[tops, \ eeHH]\)\)], "Input"],

Cell[BoxData[
    \(\(tops\  = \ 
      CreateCTTopologies[1, \ 2\  -> \ 2, \n\ \ 
        ExcludeTopologies\  -> \ {TadpoleCTs, \ WFCorrectionCTs}]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\t (*\ 
      this\ is\ because\ there\ are\ no\ counter\ terms\ in\ MSSM.mod\ 
        \(yet : \)\ *) \n
    ins\  = \ InsertFields[tops, \ eeHH\  /. \ S[5]\  -> \ S[3], \ 
        Model\  -> \ "\<SMc\>"]; \nTheLabel[S[3]]\  = \ "\<H\>"; \)\)], 
  "Input"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("initializing generic model file \
"\[InvisibleSpace]"C:\\PROGRA~1\\WOLFRA~1\\MATHEM~1\\3.0\\AddOns\\\
Applications\\Models\\Lorentz.gen"\),
        SequenceForm[ 
        "initializing generic model file ", 
          "C:\\PROGRA~1\\WOLFRA~1\\MATHEM~1\\3.0\\AddOns\\Applications\\\
Models\\Lorentz.gen"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"> $SVMixing is OFF"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("generic model "\[InvisibleSpace]"Lorentz"\[InvisibleSpace]" \
initialized"\),
        SequenceForm[ "generic model ", "Lorentz", " initialized"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("initializing classes model file \
"\[InvisibleSpace]"C:\\PROGRA~1\\WOLFRA~1\\MATHEM~1\\3.0\\AddOns\\\
Applications\\Models\\SMc.mod"\),
        SequenceForm[ 
        "initializing classes model file ", 
          "C:\\PROGRA~1\\WOLFRA~1\\MATHEM~1\\3.0\\AddOns\\Applications\\\
Models\\SMc.mod"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> "\[InvisibleSpace]46
          \[InvisibleSpace]" particles (incl. antiparticles) in "\
\[InvisibleSpace]16\[InvisibleSpace]" classes"\),
        SequenceForm[ 
        "> ", 46, " particles (incl. antiparticles) in ", 16, " classes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"> $CounterTerms are ON"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> "\[InvisibleSpace]88\[InvisibleSpace]" vertices"\),
        SequenceForm[ "> ", 88, " vertices"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> "\[InvisibleSpace]114
          \[InvisibleSpace]" counter terms of order 1"\),
        SequenceForm[ "> ", 114, " counter terms of order 1"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> "\[InvisibleSpace]6
          \[InvisibleSpace]" counter terms of order 2"\),
        SequenceForm[ "> ", 6, " counter terms of order 2"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("classes model "\[InvisibleSpace]"SMc"\[InvisibleSpace]" \
initialized"\),
        SequenceForm[ "classes model ", "SMc", " initialized"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("Excluding "\[InvisibleSpace]18
          \[InvisibleSpace]" field point(s) (incl. charge conjugate ones)"\),
        SequenceForm[ 
        "Excluding ", 18, " field point(s) (incl. charge conjugate ones)"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("inserting at level(s) "\[InvisibleSpace]{Generic, Classes}\),
        SequenceForm[ "inserting at level(s) ", {Generic, Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]1
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]2
          \[InvisibleSpace]": "\[InvisibleSpace]"1 Generic, 2 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Generic, 2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]3
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]4
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 4, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]5
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 5, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]6
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 6, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]7
          \[InvisibleSpace]": "\[InvisibleSpace]"1 Generic, 2 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 7, ": ", "1 Generic, 2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]8
          \[InvisibleSpace]": "\[InvisibleSpace]"1 Generic, 4 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 8, ": ", "1 Generic, 4 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]9
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 9, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]10
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 10, ": ", "0 Generic, 0 Classes insertions"],
        
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("in total: "\[InvisibleSpace]"3 Generic, 8 Classes insertions"\),
        SequenceForm[ "in total: ", "3 Generic, 8 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("Restoring "\[InvisibleSpace]18\[InvisibleSpace]" field point(s)"\),
        
        SequenceForm[ "Restoring ", 18, " field point(s)"],
        Editable->False], TraditionalForm]], "Print"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DoPaint[ins, \ "\<counter\>"]; \)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm
    \`Shape::"wait" \( : \ \) 
      "Starting Java and the topology editor. This may take a moment."\)], 
  "Message"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]1
          \[InvisibleSpace]": "\[InvisibleSpace]"2 diagrams"\),
        SequenceForm[ "> Top. ", 1, ": ", "2 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]2
          \[InvisibleSpace]": "\[InvisibleSpace]"2 diagrams"\),
        SequenceForm[ "> Top. ", 2, ": ", "2 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]3
          \[InvisibleSpace]": "\[InvisibleSpace]"4 diagrams"\),
        SequenceForm[ "> Top. ", 3, ": ", "4 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.325 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.0113636 0 0.0113636 [
[ 0 0 0 0 ]
[ 1 1.325 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.325 L
0 1.325 L
closepath
clip
newpath
% Start of sub-graphic
p
0 1 0.25 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.68182 .5 m
.67727 .50393 L
.67273 .50738 L
.66818 .50991 L
.66363 .51122 L
.65909 .51114 L
.65454 .50968 L
.65 .50703 L
.64545 .50351 L
.64091 .49955 L
.63636 .49564 L
.63182 .49228 L
.62727 .48987 L
.62273 .48871 L
.61818 .48894 L
.61364 .49054 L
.60909 .49331 L
.60455 .4969 L
.6 .50088 L
.59545 .50474 L
.59091 .50802 L
.58636 .51031 L
.58182 .51131 L
.57727 .51092 L
.57273 .50918 L
.56818 .5063 L
.56364 .50264 L
.55909 .49865 L
.55455 .49482 L
.55 .49164 L
.54546 .48948 L
.54091 .48863 L
.53636 .48918 L
.53182 .49106 L
.52727 .49404 L
.52273 .49777 L
.51818 .50176 L
.51364 .50553 L
.50909 .50862 L
.50455 .51064 L
.5 .51135 L
.49545 .51064 L
.49091 .50862 L
.48636 .50553 L
.48182 .50176 L
.47727 .49777 L
.47273 .49404 L
.46818 .49106 L
.46364 .48918 L
.45909 .48863 L
Mistroke
.45454 .48948 L
.45 .49164 L
.44545 .49482 L
.44091 .49865 L
.43636 .50264 L
.43182 .5063 L
.42727 .50918 L
.42273 .51092 L
.41818 .51131 L
.41364 .51031 L
.40909 .50802 L
.40455 .50474 L
.4 .50088 L
.39545 .4969 L
.39091 .49331 L
.38636 .49054 L
.38182 .48894 L
.37727 .48871 L
.37273 .48987 L
.36818 .49228 L
.36364 .49564 L
.35909 .49955 L
.35455 .50351 L
.35 .50703 L
.34546 .50968 L
.34091 .51114 L
.33637 .51122 L
.33182 .50991 L
.32727 .50738 L
.32273 .50393 L
.31818 .5 L
Mfstroke
gsave
.5 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.015 w
.65909 .47727 m
.70455 .52273 L
s
.65909 .52273 m
.70455 .47727 L
s
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C1) show
77.812500 14.625000 moveto
(N1) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 1 0.5 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.68182 .5 m
.67727 .50393 L
.67273 .50738 L
.66818 .50991 L
.66363 .51122 L
.65909 .51114 L
.65454 .50968 L
.65 .50703 L
.64545 .50351 L
.64091 .49955 L
.63636 .49564 L
.63182 .49228 L
.62727 .48987 L
.62273 .48871 L
.61818 .48894 L
.61364 .49054 L
.60909 .49331 L
.60455 .4969 L
.6 .50088 L
.59545 .50474 L
.59091 .50802 L
.58636 .51031 L
.58182 .51131 L
.57727 .51092 L
.57273 .50918 L
.56818 .5063 L
.56364 .50264 L
.55909 .49865 L
.55455 .49482 L
.55 .49164 L
.54546 .48948 L
.54091 .48863 L
.53636 .48918 L
.53182 .49106 L
.52727 .49404 L
.52273 .49777 L
.51818 .50176 L
.51364 .50553 L
.50909 .50862 L
.50455 .51064 L
.5 .51135 L
.49545 .51064 L
.49091 .50862 L
.48636 .50553 L
.48182 .50176 L
.47727 .49777 L
.47273 .49404 L
.46818 .49106 L
.46364 .48918 L
.45909 .48863 L
Mistroke
.45454 .48948 L
.45 .49164 L
.44545 .49482 L
.44091 .49865 L
.43636 .50264 L
.43182 .5063 L
.42727 .50918 L
.42273 .51092 L
.41818 .51131 L
.41364 .51031 L
.40909 .50802 L
.40455 .50474 L
.4 .50088 L
.39545 .4969 L
.39091 .49331 L
.38636 .49054 L
.38182 .48894 L
.37727 .48871 L
.37273 .48987 L
.36818 .49228 L
.36364 .49564 L
.35909 .49955 L
.35455 .50351 L
.35 .50703 L
.34546 .50968 L
.34091 .51114 L
.33637 .51122 L
.33182 .50991 L
.32727 .50738 L
.32273 .50393 L
.31818 .5 L
Mfstroke
gsave
.5 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.015 w
.65909 .47727 m
.70455 .52273 L
s
.65909 .52273 m
.70455 .47727 L
s
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C2) show
77.812500 14.625000 moveto
(N2) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 1 0.75 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.68182 .5 m
.67727 .50393 L
.67273 .50738 L
.66818 .50991 L
.66363 .51122 L
.65909 .51114 L
.65454 .50968 L
.65 .50703 L
.64545 .50351 L
.64091 .49955 L
.63636 .49564 L
.63182 .49228 L
.62727 .48987 L
.62273 .48871 L
.61818 .48894 L
.61364 .49054 L
.60909 .49331 L
.60455 .4969 L
.6 .50088 L
.59545 .50474 L
.59091 .50802 L
.58636 .51031 L
.58182 .51131 L
.57727 .51092 L
.57273 .50918 L
.56818 .5063 L
.56364 .50264 L
.55909 .49865 L
.55455 .49482 L
.55 .49164 L
.54546 .48948 L
.54091 .48863 L
.53636 .48918 L
.53182 .49106 L
.52727 .49404 L
.52273 .49777 L
.51818 .50176 L
.51364 .50553 L
.50909 .50862 L
.50455 .51064 L
.5 .51135 L
.49545 .51064 L
.49091 .50862 L
.48636 .50553 L
.48182 .50176 L
.47727 .49777 L
.47273 .49404 L
.46818 .49106 L
.46364 .48918 L
.45909 .48863 L
Mistroke
.45454 .48948 L
.45 .49164 L
.44545 .49482 L
.44091 .49865 L
.43636 .50264 L
.43182 .5063 L
.42727 .50918 L
.42273 .51092 L
.41818 .51131 L
.41364 .51031 L
.40909 .50802 L
.40455 .50474 L
.4 .50088 L
.39545 .4969 L
.39091 .49331 L
.38636 .49054 L
.38182 .48894 L
.37727 .48871 L
.37273 .48987 L
.36818 .49228 L
.36364 .49564 L
.35909 .49955 L
.35455 .50351 L
.35 .50703 L
.34546 .50968 L
.34091 .51114 L
.33637 .51122 L
.33182 .50991 L
.32727 .50738 L
.32273 .50393 L
.31818 .5 L
Mfstroke
gsave
.5 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.68182 .5 Mdot
.015 w
.29545 .47727 m
.34091 .52273 L
s
.29545 .52273 m
.34091 .47727 L
s
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C1) show
77.812500 14.625000 moveto
(N3) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 1 1 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.68182 .5 m
.67727 .50393 L
.67273 .50738 L
.66818 .50991 L
.66363 .51122 L
.65909 .51114 L
.65454 .50968 L
.65 .50703 L
.64545 .50351 L
.64091 .49955 L
.63636 .49564 L
.63182 .49228 L
.62727 .48987 L
.62273 .48871 L
.61818 .48894 L
.61364 .49054 L
.60909 .49331 L
.60455 .4969 L
.6 .50088 L
.59545 .50474 L
.59091 .50802 L
.58636 .51031 L
.58182 .51131 L
.57727 .51092 L
.57273 .50918 L
.56818 .5063 L
.56364 .50264 L
.55909 .49865 L
.55455 .49482 L
.55 .49164 L
.54546 .48948 L
.54091 .48863 L
.53636 .48918 L
.53182 .49106 L
.52727 .49404 L
.52273 .49777 L
.51818 .50176 L
.51364 .50553 L
.50909 .50862 L
.50455 .51064 L
.5 .51135 L
.49545 .51064 L
.49091 .50862 L
.48636 .50553 L
.48182 .50176 L
.47727 .49777 L
.47273 .49404 L
.46818 .49106 L
.46364 .48918 L
.45909 .48863 L
Mistroke
.45454 .48948 L
.45 .49164 L
.44545 .49482 L
.44091 .49865 L
.43636 .50264 L
.43182 .5063 L
.42727 .50918 L
.42273 .51092 L
.41818 .51131 L
.41364 .51031 L
.40909 .50802 L
.40455 .50474 L
.4 .50088 L
.39545 .4969 L
.39091 .49331 L
.38636 .49054 L
.38182 .48894 L
.37727 .48871 L
.37273 .48987 L
.36818 .49228 L
.36364 .49564 L
.35909 .49955 L
.35455 .50351 L
.35 .50703 L
.34546 .50968 L
.34091 .51114 L
.33637 .51122 L
.33182 .50991 L
.32727 .50738 L
.32273 .50393 L
.31818 .5 L
Mfstroke
gsave
.5 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.68182 .5 Mdot
.015 w
.29545 .47727 m
.34091 .52273 L
s
.29545 .52273 m
.34091 .47727 L
s
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C2) show
77.812500 14.625000 moveto
(N4) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.75 0.25 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.31818 .5 m
.32273 .49565 L
.32727 .49197 L
.33182 .4895 L
.33636 .48864 L
.34091 .4895 L
.34546 .49197 L
.35 .49565 L
.35455 .5 L
.35909 .50435 L
.36364 .50804 L
.36818 .5105 L
.37273 .51137 L
.37727 .5105 L
.38182 .50804 L
.38636 .50435 L
.39091 .5 L
.39545 .49566 L
.4 .49197 L
.40455 .48951 L
.40909 .48864 L
.41364 .48951 L
.41818 .49197 L
.42273 .49566 L
.42727 .5 L
.43182 .50435 L
.43636 .50804 L
.44091 .5105 L
.44546 .51137 L
.45 .5105 L
.45455 .50804 L
.45909 .50435 L
.46364 .5 L
.46818 .49565 L
.47273 .49197 L
.47727 .4895 L
.48182 .48864 L
.48636 .4895 L
.49091 .49197 L
.49545 .49565 L
.5 .5 L
s
gsave
.40909 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.68182 .5 m
.67727 .50435 L
.67273 .50803 L
.66818 .5105 L
.66364 .51136 L
.65909 .5105 L
.65454 .50803 L
.65 .50435 L
.64545 .5 L
.64091 .49565 L
.63636 .49196 L
.63182 .4895 L
.62727 .48863 L
.62273 .4895 L
.61818 .49196 L
.61364 .49565 L
.60909 .5 L
.60455 .50434 L
.6 .50803 L
.59545 .51049 L
.59091 .51136 L
.58636 .51049 L
.58182 .50803 L
.57727 .50434 L
.57273 .5 L
.56818 .49565 L
.56364 .49196 L
.55909 .4895 L
.55454 .48863 L
.55 .4895 L
.54545 .49196 L
.54091 .49565 L
.53636 .5 L
.53182 .50435 L
.52727 .50803 L
.52273 .5105 L
.51818 .51136 L
.51364 .5105 L
.50909 .50803 L
.50455 .50435 L
.5 .5 L
s
gsave
.59091 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.015 w
.47727 .47727 m
.52273 .52273 L
s
.47727 .52273 m
.52273 .47727 L
s
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T3) show
70.187500 14.625000 moveto
(C1) show
77.812500 14.625000 moveto
(N5) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.75 0.5 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.31818 .5 m
.32273 .49565 L
.32727 .49197 L
.33182 .4895 L
.33636 .48864 L
.34091 .4895 L
.34546 .49197 L
.35 .49565 L
.35455 .5 L
.35909 .50435 L
.36364 .50804 L
.36818 .5105 L
.37273 .51137 L
.37727 .5105 L
.38182 .50804 L
.38636 .50435 L
.39091 .5 L
.39545 .49566 L
.4 .49197 L
.40455 .48951 L
.40909 .48864 L
.41364 .48951 L
.41818 .49197 L
.42273 .49566 L
.42727 .5 L
.43182 .50435 L
.43636 .50804 L
.44091 .5105 L
.44546 .51137 L
.45 .5105 L
.45455 .50804 L
.45909 .50435 L
.46364 .5 L
.46818 .49565 L
.47273 .49197 L
.47727 .4895 L
.48182 .48864 L
.48636 .4895 L
.49091 .49197 L
.49545 .49565 L
.5 .5 L
s
gsave
.40909 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.68182 .5 m
.67727 .50435 L
.67273 .50803 L
.66818 .5105 L
.66364 .51136 L
.65909 .5105 L
.65454 .50803 L
.65 .50435 L
.64545 .5 L
.64091 .49565 L
.63636 .49196 L
.63182 .4895 L
.62727 .48863 L
.62273 .4895 L
.61818 .49196 L
.61364 .49565 L
.60909 .5 L
.60455 .50434 L
.6 .50803 L
.59545 .51049 L
.59091 .51136 L
.58636 .51049 L
.58182 .50803 L
.57727 .50434 L
.57273 .5 L
.56818 .49565 L
.56364 .49196 L
.55909 .4895 L
.55454 .48863 L
.55 .4895 L
.54545 .49196 L
.54091 .49565 L
.53636 .5 L
.53182 .50435 L
.52727 .50803 L
.52273 .5105 L
.51818 .51136 L
.51364 .5105 L
.50909 .50803 L
.50455 .50435 L
.5 .5 L
s
gsave
.59091 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.015 w
.47727 .47727 m
.52273 .52273 L
s
.47727 .52273 m
.52273 .47727 L
s
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T3) show
70.187500 14.625000 moveto
(C2) show
77.812500 14.625000 moveto
(N6) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.75 0.75 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.31818 .5 m
.32273 .49565 L
.32727 .49197 L
.33182 .4895 L
.33636 .48864 L
.34091 .4895 L
.34546 .49197 L
.35 .49565 L
.35455 .5 L
.35909 .50435 L
.36364 .50804 L
.36818 .5105 L
.37273 .51137 L
.37727 .5105 L
.38182 .50804 L
.38636 .50435 L
.39091 .5 L
.39545 .49566 L
.4 .49197 L
.40455 .48951 L
.40909 .48864 L
.41364 .48951 L
.41818 .49197 L
.42273 .49566 L
.42727 .5 L
.43182 .50435 L
.43636 .50804 L
.44091 .5105 L
.44546 .51137 L
.45 .5105 L
.45455 .50804 L
.45909 .50435 L
.46364 .5 L
.46818 .49565 L
.47273 .49197 L
.47727 .4895 L
.48182 .48864 L
.48636 .4895 L
.49091 .49197 L
.49545 .49565 L
.5 .5 L
s
gsave
.40909 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.68182 .5 m
.67727 .50435 L
.67273 .50803 L
.66818 .5105 L
.66364 .51136 L
.65909 .5105 L
.65454 .50803 L
.65 .50435 L
.64545 .5 L
.64091 .49565 L
.63636 .49196 L
.63182 .4895 L
.62727 .48863 L
.62273 .4895 L
.61818 .49196 L
.61364 .49565 L
.60909 .5 L
.60455 .50434 L
.6 .50803 L
.59545 .51049 L
.59091 .51136 L
.58636 .51049 L
.58182 .50803 L
.57727 .50434 L
.57273 .5 L
.56818 .49565 L
.56364 .49196 L
.55909 .4895 L
.55454 .48863 L
.55 .4895 L
.54545 .49196 L
.54091 .49565 L
.53636 .5 L
.53182 .50435 L
.52727 .50803 L
.52273 .5105 L
.51818 .51136 L
.51364 .5105 L
.50909 .50803 L
.50455 .50435 L
.5 .5 L
s
gsave
.59091 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.015 w
.47727 .47727 m
.52273 .52273 L
s
.47727 .52273 m
.52273 .47727 L
s
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T3) show
70.187500 14.625000 moveto
(C3) show
77.812500 14.625000 moveto
(N7) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.75 1 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.31818 .5 m
.32273 .49565 L
.32727 .49197 L
.33182 .4895 L
.33636 .48864 L
.34091 .4895 L
.34546 .49197 L
.35 .49565 L
.35455 .5 L
.35909 .50435 L
.36364 .50804 L
.36818 .5105 L
.37273 .51137 L
.37727 .5105 L
.38182 .50804 L
.38636 .50435 L
.39091 .5 L
.39545 .49566 L
.4 .49197 L
.40455 .48951 L
.40909 .48864 L
.41364 .48951 L
.41818 .49197 L
.42273 .49566 L
.42727 .5 L
.43182 .50435 L
.43636 .50804 L
.44091 .5105 L
.44546 .51137 L
.45 .5105 L
.45455 .50804 L
.45909 .50435 L
.46364 .5 L
.46818 .49565 L
.47273 .49197 L
.47727 .4895 L
.48182 .48864 L
.48636 .4895 L
.49091 .49197 L
.49545 .49565 L
.5 .5 L
s
gsave
.40909 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.68182 .5 m
.67727 .50435 L
.67273 .50803 L
.66818 .5105 L
.66364 .51136 L
.65909 .5105 L
.65454 .50803 L
.65 .50435 L
.64545 .5 L
.64091 .49565 L
.63636 .49196 L
.63182 .4895 L
.62727 .48863 L
.62273 .4895 L
.61818 .49196 L
.61364 .49565 L
.60909 .5 L
.60455 .50434 L
.6 .50803 L
.59545 .51049 L
.59091 .51136 L
.58636 .51049 L
.58182 .50803 L
.57727 .50434 L
.57273 .5 L
.56818 .49565 L
.56364 .49196 L
.55909 .4895 L
.55454 .48863 L
.55 .4895 L
.54545 .49196 L
.54091 .49565 L
.53636 .5 L
.53182 .50435 L
.52727 .50803 L
.52273 .5105 L
.51818 .51136 L
.51364 .5105 L
.50909 .50803 L
.50455 .50435 L
.5 .5 L
s
gsave
.59091 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.015 w
.47727 .47727 m
.52273 .52273 L
s
.47727 .52273 m
.52273 .47727 L
s
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T3) show
70.187500 14.625000 moveto
(C4) show
77.812500 14.625000 moveto
(N8) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.39773 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.44886 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.5 1.295 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
63.000000 14.625000 moveto
(\\256) show
68.750000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
gsave
.55114 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.60227 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{217.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003I000182000`400?l00000o`00003of@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00
f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo
003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00
f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo
003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00
f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo
003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo000A0?ooo`040000003oool0
000000000080oooo0`0000020?ooo`060000003oool000000?ooo`000000oooo0P00000S0?ooo`04
0000003oool0000000000080oooo0`000000203oool000000000003oool000000?ooo`000000oooo
0P00000S0?ooo`040000003oool0000000000080oooo0`0000001`3oool000000000003oool00000
0?ooo`0000009P3oool010000000oooo0000000000020?ooo`<000001@3oool010000000oooo0000
003oool200000180oooo000A0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0000000200000080oooo0P00000R0?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool00P3oool00`000000oooo00000002000000040?ooo`00000000000000
0280oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
0000008000000P3oool00`000000oooo0?ooo`0Q0?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool0oooo0P0000020?ooo`<0000000<0oooo0000000000004P3oool00140oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000800000
00<0oooo0000003oool08`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0
oooo100000000`3oool000000?ooo`0S0?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool00P3oool00`000000oooo0000000200000080oooo00<000000?ooo`3oool08@3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo0?ooo`8000000P3oool3000000030?ooo`00
000000000180oooo000<0?ooo`8000000P3oool3000000030?ooo`000000oooo0080oooo0P000004
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0703oool200000080oooo0`000000
0`3oool000000?ooo`020?ooo`8000000P3oool00`000000oooo000000040?ooo`030000003oool0
oooo01`0oooo0P0000020?ooo`<0000000<0oooo0000003oool00P3oool200000080oooo00<00000
0?ooo`0000000`3oool3000001d0oooo0P0000020?ooo`<0000000<0oooo0000003oool00P3oool2
000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`00303oool30000
03<0oooo0`00000c0?ooo`<00000<`3oool3000002P0oooo000=0?ooo`030000003oool0oooo03<0
oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo02L0
oooo003I0?ooo`007P3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo04`0oooo0002
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo01T0oooo0P00000C0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool06@3oool2000001<0oooo00<000000?ooo`3oool00@3oool000<0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0000000B0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0000000B0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo00040?ooo`80
0000603oool300000100oooo00<000000?ooo`3oool01P3oool2000001T0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`060?ooo`800000603oool300000100oooo00<000000?ooo`3o
ool01P3oool2000001T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`030?ooo`00
1P3oool00`000000oooo0?ooo`0V0?ooo`8000002`3oool00`000000oooo0?ooo`0E0?ooo`<00000
3P3oool2000000/0oooo00<000000?ooo`3oool09P3oool2000000/0oooo00<000000?ooo`3oool0
5@3oool3000000l0oooo00<000000?ooo`3oool0103oool000L0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`060?ooo`00203oool2000002<0oooo00<000000?ooo`3oool03P3oool2
000002<0oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?ooo`3oool03P3oool2
000002<0oooo00<000000?ooo`3oool01`3oool000P0oooo0`00000O0?ooo`<000004@3oool30000
01l0oooo0`00000A0?ooo`<000007`3oool300000140oooo0`00000O0?ooo`<000002P3oool00080
oooo0P0000070?ooo`030000003oool0oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000
oooo0?ooo`0L0?ooo`8000003@3oool2000000H0oooo00<000000?ooo`3oool0703oool2000000d0
oooo0P0000060?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02@3oool00080oooo
0`0000070?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03@3oool3000000H0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<000001P3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool02`3oool000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo00`0oooo000>0?ooo`8000005`3oool00`000000oooo0?ooo`0J
0?ooo`8000005`3oool00`000000oooo0?ooo`0J0?ooo`8000005`3oool00`000000oooo0?ooo`0J
0?ooo`8000005`3oool00`000000oooo0?ooo`0=0?ooo`00403oool300000080oooo0P0000020?oo
o`80000000@0oooo00000000000000000P3oool200000080oooo0P00000O0?ooo`030000003oool0
00000080oooo0P0000020?ooo`80000000@0oooo00000000000000000P3oool200000080oooo0P00
000O0?ooo`030000003oool000000080oooo0P0000020?ooo`80000000@0oooo0000000000000000
0P3oool200000080oooo0P00000O0?ooo`030000003oool0000000<0oooo00H000000?ooo`3oool0
oooo0000003oool300000080oooo0P0000030?ooo`030000003oool0oooo00h0oooo000A0?oooa@0
00008P3ooolD00000280oooo5000000R0?oooaD000004@3oool00100oooo00<000000?ooo`3oool0
0P0000020?ooo`<0000000<0oooo0000000000000P3oool200000080oooo0`0000090?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool00P0000020?ooo`<0000000<0oooo000000000000
0P3oool200000080oooo0`0000090?ooo`030000003oool0oooo01@0oooo00D000000?ooo`3oool0
oooo000000020?ooo`<0000000<0oooo0000000000000P3oool200000080oooo0`0000090?ooo`03
0000003oool0oooo01@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool00000
008000000P3oool200000080oooo0P0000000`3oool000000?ooo`070?ooo`030000003oool0oooo
00D0oooo000>0?ooo`8000005P3oool2000000L0oooo0`00000B0?ooo`8000005P3oool2000000L0
oooo0`00000B0?ooo`8000005P3oool2000000L0oooo0`00000B0?ooo`8000005`3oool00`000000
oooo0?ooo`050?ooo`<000001@3oool000d0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`040?ooo`030000003oool000000140oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`040?ooo`030000003oool000000140oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`040?ooo`030000003oool000000140oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`040?ooo`030000003oool0000000D0oooo000<0?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`002P3oool2000001h0oooo00<00000
0?ooo`3oool04`3oool2000001h0oooo00<000000?ooo`3oool04`3oool2000001h0oooo00<00000
0?ooo`3oool04`3oool2000001l0oooo00<000000?ooo`3oool02@3oool000T0oooo0P00000P0?oo
o`8000004P3oool200000200oooo0`00000A0?ooo`800000803oool300000140oooo0P00000Q0?oo
o`8000002@3oool000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`80
0000403oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01D0oooo0P00000@0?ooo`03
0000003oool0oooo0240oooo0P00000@0?ooo`030000003oool0oooo0240oooo0P0000090?ooo`00
1`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0:0?ooo`800000603oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00X0oooo0P00000H0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`0000006@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`0000006@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`040?ooo`00103oool2
000000h0oooo0`00000I0?ooo`800000203oool2000000h0oooo0`00000I0?ooo`800000203oool2
000000l0oooo00<000000?ooo`3oool0603oool2000000P0oooo0P00000?0?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool00`3oool000<0oooo00<000000?ooo`3oool0;03oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0>0?ooo`<000006`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00h0oooo0`00000K0?ooo`030000003oool0oooo0080oooo00020?ooo`030000003oool0oooo02h0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02h0
oooo00<000000?ooo`3oool00@3oool002@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0403oool002@0oooo0`00
000c0?ooo`<00000<`3oool3000003<0oooo0`00000@0?ooo`00903oool00`000000oooo0000000c
0?ooo`030000003oool0000003<0oooo00<000000?ooo`000000<`3oool00`000000oooo0000000@
0?ooo`00903oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?oo
o`3oool0<`3oool00`000000oooo0?ooo`0@0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo000A0?ooo`040000003oool0oooo00000080oooo
0`0000020?ooo`050000003oool000000?ooo`0000000P3oool00`000000oooo0?ooo`0Q0?ooo`04
0000003oool0oooo00000080oooo0`000000203oool000000000003oool000000?ooo`000000oooo
0P00000S0?ooo`040000003oool0000000000080oooo0`0000020?ooo`060000003oool000000?oo
o`000000oooo0P00000S0?ooo`040000003oool0000000000080oooo0`0000000`3oool000000000
00020?ooo`030000003oool0000001D0oooo000A0?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0000000200000080oooo00<000000?ooo`3oool08@3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000
0P0000020?ooo`030000003oool0oooo0240oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`020?ooo`030000003oool00000008000000P3oool00`000000oooo0?ooo`0Q0?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030000
00030?ooo`00000000000180oooo000A0?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool00P3oool00`000000oooo0000000200000080oooo00<000000?ooo`3oool08@3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo100000030?ooo`030000003oool0
oooo0200oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo00<000000?ooo`000000
0P0000020?ooo`030000003oool0oooo0240oooo00L000000?ooo`3oool0oooo0000003oool00000
00D0oooo00<000000?ooo`0000000P0000000`3oool000000000000B0?ooo`00303oool200000080
oooo0`0000050?ooo`800000103oool00`000000oooo0?ooo`0Q0?ooo`8000000P3oool3000000D0
oooo0P0000020?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0703oool200000080
oooo0`0000000`3oool000000?ooo`020?ooo`800000103oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01d0oooo0P0000001P3oool00000000000000000oooo000000<0oooo0P000002
0?ooo`040000003oool0oooo000001L0oooo000<0?ooo`<00000<`3oool3000003<0oooo0`00000d
0?ooo`<000009`3oool000d0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?oo
o`030000003oool0oooo03@0oooo00<000000?ooo`3oool09P3oool00=T0oooo000I0?ooo`030000
003oool0oooo06T0oooo00<000000?ooo`3oool0D@3oool00080oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0503o
ool2000001P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0D0?ooo`800000603o
ool00`000000oooo0?ooo`010?ooo`000`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
000001L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
000001L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool00P3oool000@0oooo0P00000C0?ooo`<000005@3oool00`00
0000oooo0?ooo`060?ooo`800000503oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
00H0oooo0P00000C0?ooo`<000005@3oool00`000000oooo0?ooo`060?ooo`800000503oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo00<0oooo00060?ooo`030000003oool0oooo02H0
oooo0P00000;0?ooo`030000003oool0oooo0100oooo0`00000C0?ooo`8000002`3oool00`000000
oooo0?ooo`0V0?ooo`8000002`3oool00`000000oooo0?ooo`0@0?ooo`<00000503oool00`000000
oooo0?ooo`040?ooo`001`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02@0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00H0oooo
00080?ooo`8000008`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?oo
o`0>0?ooo`8000008`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?oo
o`070?ooo`00203oool3000001l0oooo0`00000A0?ooo`<000007`3oool300000140oooo0`00000O
0?ooo`<000004@3oool3000001l0oooo0`00000:0?ooo`000P3oool2000000L0oooo00<000000?oo
o`3oool0703oool2000000d0oooo0P0000060?ooo`030000003oool0oooo01`0oooo0P00000=0?oo
o`8000001P3oool00`000000oooo0?ooo`0L0?ooo`8000003@3oool2000000H0oooo00<000000?oo
o`3oool07@3oool00`000000oooo0?ooo`090?ooo`000P3oool3000000L0oooo00<000000?ooo`3o
ool06P3oool00`000000oooo0?ooo`0=0?ooo`<000001P3oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool03@3oool3000000H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0;0?ooo`00
0`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
303oool000h0oooo0P00000G0?ooo`030000003oool0oooo01X0oooo0P00000G0?ooo`030000003o
ool0oooo01X0oooo0P00000G0?ooo`030000003oool0oooo01X0oooo0P00000G0?ooo`030000003o
ool0oooo00d0oooo000@0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`020?ooo`080000003oool0oooo0?ooo`000000oooo0000003oool2000001l0oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00P000000?ooo`3oool0oooo0000
003oool000000?ooo`8000007`3oool01@000000oooo0000003oool0000000<0oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo0P00000O0?ooo`050000003oool0
00000?ooo`000000103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0>0?ooo`004@3oool5000000030?ooo`000000000000H0000000<0
oooo0000000000001000000Q0?ooo`D0000000<0oooo0000000000001P0000000`3oool000000000
000400000240oooo00<000000?ooo`0000000P0000000`3oool0000000000006000000030?ooo`00
0000000000<000008P3oool00`000000oooo0000000;000000030?ooo`000000000000@000004@3o
ool00100oooo0`0000030?ooo`8000000P3oool200000080oooo0P0000030?ooo`@00000203oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0000000<0oooo0P0000020?ooo`8000000`3oool2
00000080oooo100000080?ooo`030000003oool0oooo01@0oooo00<000000?ooo`0000000`3oool2
00000080oooo0P0000030?ooo`8000000P3oool3000000T0oooo00<000000?ooo`3oool0503oool0
0`000000oooo000000030?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`80000000<0oooo
0000003oool01`3oool00`000000oooo0?ooo`050?ooo`003P3oool2000001H0oooo0P0000070?oo
o`<000004P3oool2000001H0oooo0P0000070?ooo`<000004P3oool2000001H0oooo0P0000070?oo
o`<000004P3oool2000001L0oooo00<000000?ooo`3oool01@3oool3000000D0oooo000=0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0103oool00`000000oooo000000050?ooo`00
303oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
1@3oool000/0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo01`0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0L0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`090?ooo`002@3oool2
00000200oooo0P00000B0?ooo`800000803oool300000140oooo0P00000P0?ooo`<000004@3oool2
00000240oooo0P0000090?ooo`00203oool00`000000oooo0?ooo`0Q0?ooo`800000403oool00`00
0000oooo0?ooo`0Q0?ooo`800000403oool00`000000oooo0?ooo`0Q0?ooo`800000403oool00`00
0000oooo0?ooo`0Q0?ooo`8000002@3oool000L0oooo00<000000?ooo`3oool0903oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0T0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`000000
oooo0?ooo`060?ooo`001P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00@0oooo
00040?ooo`800000:P3oool2000000P0oooo0P00000Z0?ooo`800000203oool2000002X0oooo0P00
00080?ooo`800000:`3oool00`000000oooo0?ooo`030?ooo`000`3oool00`000000oooo0?ooo`0/
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0/
0?ooo`030000003oool0oooo0080oooo00020?ooo`030000003oool0oooo02h0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0;P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02h0oooo00<000000?oo
o`3oool00@3oool002@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?ooo`03
0000003oool0oooo03<0oooo00<000000?ooo`3oool0403oool002@0oooo0`00000c0?ooo`<00000
<`3oool3000003<0oooo0`00000@0?ooo`00903oool00`000000oooo0000000c0?ooo`030000003o
ool0000003<0oooo00<000000?ooo`000000<`3oool00`000000oooo0000000@0?ooo`00903oool0
0`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool0
0`000000oooo0?ooo`0@0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00=T0oooo003I0?ooo`00E03oool3000000P0oooo0`00000;0?ooo`030000003o
ool0oooo00@0oooo00@000000?ooo`3oool000001`3oool010000000oooo0?ooo`00001F0?ooo`00
E03oool3000000P0oooo0`0000080?ooo`D000001@3oool010000000oooo0?ooo`0000070?ooo`04
0000003oool0oooo000005H0oooo001D0?ooo`<00000203oool3000000/0oooo00<000000?ooo`3o
ool0103oool4000000L0oooo1000001F0?ooo`00M03oool010000000oooo0?ooo`0000070?ooo`04
0000003oool0oooo000005H0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00001
\
\>"],
  ImageRangeCache->{{{0, 216.313}, {287, 0}} -> {-0.000440006, -0.0790874, 
  0.406824, 0.406824}, {{0, 54.0625}, {70.4375, 16.375}} -> {-1.00011,
   -89.1283, 0.406941, 0.406941}, {{54.0625, 108.125}, {70.4375, 16.375}} ->
   {-23.0004, -89.1283, 0.406941, 0.406941}, {{108.125, 162.188}, {70.4375, 
  16.375}} -> {-45.0006, -89.1283, 0.406941, 0.406941}, {{162.188, 216.313}, {
  70.4375, 16.375}} -> {-67.0136, -89.1283, 0.406941, 0.406941}, {{0, 
  54.0625}, {124.563, 70.4375}} -> {-1.00011, -67.1153, 0.406941, 0.406941},
   {{54.0625, 108.125}, {124.563, 70.4375}} -> {-23.0004, -67.1153, 0.406941, 
  0.406941}, {{108.125, 162.188}, {124.563, 70.4375}} -> {-45.0006, -67.1153, 
  0.406941, 0.406941}, {{162.188, 216.313}, {124.563, 70.4375}} -> {-66.9246,
   -67.0262, 0.406471, 0.406471}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(counter\  = \ CreateFeynAmp[ins]\  /. \ SW\  -> \ \(-SW\)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("creating amplitudes at level(s) "\[InvisibleSpace]{Generic, 
            Classes}\),
        SequenceForm[ "creating amplitudes at level(s) ", {Generic, Classes}],
        
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]1
          \[InvisibleSpace]": "\[InvisibleSpace]"1 Generic, 2 Classes \
amplitudes"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 Generic, 2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]2
          \[InvisibleSpace]": "\[InvisibleSpace]"1 Generic, 2 Classes \
amplitudes"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Generic, 2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]3
          \[InvisibleSpace]": "\[InvisibleSpace]"1 Generic, 4 Classes \
amplitudes"\),
        SequenceForm[ "> Top. ", 3, ": ", "1 Generic, 4 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("in total: "\[InvisibleSpace]"3 Generic, 8 Classes amplitudes"\),
        SequenceForm[ "in total: ", "3 Generic, 8 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{"FeynAmpList", "(", 
            RowBox[{
            \(Model \[Rule] "SMc"\), ",", \(GenericModel \[Rule] "Lorentz"\), 
              ",", \(InsertionLevel \[Rule] Classes\), ",", 
              \(ExcludeParticles \[Rule] {}\), ",", 
              \(LastSelections \[Rule] {}\), ",", 
              \(ExcludeFieldPoints \[Rule] {}\), ",", 
              \(Restrictions \[Rule] 
                \(ExcludeFieldPoints 
                  \[Rule] {\((FieldPoint(_))\) (\(\(-\(F(2)\)\), F(2), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(2)\)\), F(1), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(3, {1, ___})\)\), 
                      F(3, {1, ___}), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(3, {2, ___})\)\), 
                      F(3, {2, ___}), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(4)\)\), F(4), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(4)\)\), F(3, {1, ___}), S
                      \)), \((FieldPoint(_))\) (\(\(-\(F(4)\)\), 
                      F(3, {2, ___}), S\))}\)\), ",", 
              RowBox[{"Process", "\[Rule]", 
                RowBox[{
                  RowBox[{"(", GridBox[{
                        {\(-\(F(2, {1})\)\), 
                          FormBox[\("p"\[InvisibleSpace]1\),
                            "TraditionalForm"], "ME"},
                        {\(F(2, {1})\), 
                          FormBox[\("p"\[InvisibleSpace]2\),
                            "TraditionalForm"], "ME"}
                        }], ")"}], "\[Rule]", 
                  RowBox[{"(", GridBox[{
                        {\(-\(S(3)\)\), 
                          FormBox[\("k"\[InvisibleSpace]1\),
                            "TraditionalForm"], "MW"},
                        {\(S(3)\), 
                          FormBox[\("k"\[InvisibleSpace]2\),
                            "TraditionalForm"], "MW"}
                        }], ")"}]}]}]}], ")"}], ")"}], "(", 
        RowBox[{
          RowBox[{"FeynAmp", "(", 
            RowBox[{
            \(GraphID(Topology == 1, Generic == 1)\), ",", \(Integral()\), 
              ",", 
              RowBox[{"RelativeCF", " ", 
                FormBox[
                  RowBox[{
                    RowBox[{\("v"\&"_"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]1\),
                            SequenceForm[ "p", 1],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}], ".", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]1\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((0)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}], "+", 
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]1\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "+"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((0)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}]}], ")"}], ".", 
                    RowBox[{\("u"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]2\),
                            SequenceForm[ "p", 2],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}]}],
                  "TraditionalForm"], " ", 
                FormBox[
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]2\),
                            SequenceForm[ "k", 2],
                            Editable->False],
                          "TraditionalForm"], "-", 
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]1\),
                            SequenceForm[ "k", 1],
                            Editable->False],
                          "TraditionalForm"]}], ")"}], "[", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"], "]"}],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[\("g"\),
                    "TraditionalForm"], "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                        SequenceForm[ "Lor", 1],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                FormBox[
                  FractionBox["1", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]1\),
                                SequenceForm[ "k", 1],
                                Editable->False],
                              "TraditionalForm"], "+", 
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]2\),
                                SequenceForm[ "k", 2],
                                Editable->False],
                              "TraditionalForm"]}], ")"}], "2"], "-", 
                      SuperscriptBox[
                        RowBox[{"Mass", "(", 
                          RowBox[{"V", "(", 
                            FormBox[
                              InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                                SequenceForm[ "Gen", 5],
                                Editable->False],
                              "TraditionalForm"], ")"}], ")"}], "2"]}]],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[
                    TagBox[\(G\_SSV\%\((1)\)\),
                      DisplayForm],
                    "TraditionalForm"], "(", 
                  FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                    "TraditionalForm"], ")"}]}], ",", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Mass", "(", 
                      RowBox[{"V", "(", 
                        FormBox[
                          InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                            SequenceForm[ "Gen", 5],
                            Editable->False],
                          "TraditionalForm"], ")"}], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"-"\),
                                    Subscript[ "-"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "-"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"+"\),
                                    Subscript[ "+"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "+"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_SSV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                        "TraditionalForm"], ")"}], ",", "RelativeCF"}], "}"}],
                 "\[Rule]", 
                \(\((Insertions(Classes))\) (
                  \({0, \[ImaginaryI]\ EL, \[ImaginaryI]\ EL, 
                    \[ImaginaryI]\ EL\ \((
                      dZAA1\/2 + dZe1 + dZGp1 - 
                        \(dZZA1\ \((SW2 - CW2)\)\)\/\(4\ CW\ SW\))\), 1}, {
                    MZ, \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - 1\/2)\)\)\/\(CW\ SW
                            \)\)\), \(-\(\(\[ImaginaryI]\ EL\ SW\)\/CW\)\), 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - CW2)\)\ 
                            \((\(-\(dSW1\/\(CW2\ SW\ \((SW2 - CW2)\)\)\)\) + 
                                dZe1 + dZGp1 + dZZZ1\/2 - 
                                \(CW\ dZAZ1\ SW\)\/\(SW2 - CW2\))\)\)\/\(2\ CW
                            \ SW\)\)\), 1}\))\)}]}], ")"}], ",", 
          RowBox[{"FeynAmp", "(", 
            RowBox[{
            \(GraphID(Topology == 2, Generic == 1)\), ",", \(Integral()\), 
              ",", 
              RowBox[{"RelativeCF", " ", 
                FormBox[
                  RowBox[{
                    RowBox[{\("v"\&"_"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]1\),
                            SequenceForm[ "p", 1],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}], ".", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]1\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((1)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}], "+", 
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]1\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "+"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((1)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}]}], ")"}], ".", 
                    RowBox[{\("u"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]2\),
                            SequenceForm[ "p", 2],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}]}],
                  "TraditionalForm"], " ", 
                FormBox[
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]2\),
                            SequenceForm[ "k", 2],
                            Editable->False],
                          "TraditionalForm"], "-", 
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]1\),
                            SequenceForm[ "k", 1],
                            Editable->False],
                          "TraditionalForm"]}], ")"}], "[", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"], "]"}],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[\("g"\),
                    "TraditionalForm"], "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                        SequenceForm[ "Lor", 1],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                FormBox[
                  FractionBox["1", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]1\),
                                SequenceForm[ "k", 1],
                                Editable->False],
                              "TraditionalForm"], "+", 
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]2\),
                                SequenceForm[ "k", 2],
                                Editable->False],
                              "TraditionalForm"]}], ")"}], "2"], "-", 
                      SuperscriptBox[
                        RowBox[{"Mass", "(", 
                          RowBox[{"V", "(", 
                            FormBox[
                              InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                                SequenceForm[ "Gen", 5],
                                Editable->False],
                              "TraditionalForm"], ")"}], ")"}], "2"]}]],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[
                    TagBox[\(G\_SSV\%\((0)\)\),
                      DisplayForm],
                    "TraditionalForm"], "(", 
                  FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                    "TraditionalForm"], ")"}]}], ",", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Mass", "(", 
                      RowBox[{"V", "(", 
                        FormBox[
                          InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                            SequenceForm[ "Gen", 5],
                            Editable->False],
                          "TraditionalForm"], ")"}], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_SSV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"-"\),
                                    Subscript[ "-"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "-"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"+"\),
                                    Subscript[ "+"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "+"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", "RelativeCF"}], "}"}],
                 "\[Rule]", 
                RowBox[{\((Insertions(Classes))\), "(", 
                  RowBox[{
                    RowBox[{"{", 
                      RowBox[{"0", ",", \(\[ImaginaryI]\ EL\), ",", 
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            RowBox[{
                            \(dZAA1\/2\), "+", "dZe1", "-", 
                              \(\(dZZA1\ \((SW2 - 1\/2)\)\)\/\(2\ CW\ SW\)\), 
                              "+", 
                              RowBox[{\(1\/2\), " ", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{
                                      \(dZfL1(2, 1, 1)\), "\[InvisibleSpace]",
                                         
                                        InterpretationBox[\(\[Null]\^"*"\),
                                        Superscript[ "*"],
                                        Editable->False]}],
                                      SequenceForm[ 
                                        dZfL1[ 2, 1, 1], 
                                        Superscript[ "*"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "+", 
                              \(1\/2\ \(dZfL1(2, 1, 1)\)\)}], ")"}]}], ",", 
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            RowBox[{
                            \(dZAA1\/2\), "+", "dZe1", "-", 
                              \(\(dZZA1\ SW\)\/\(2\ CW\)\), "+", 
                              RowBox[{\(1\/2\), " ", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{
                                      \(dZfR1(2, 1, 1)\), "\[InvisibleSpace]",
                                         
                                        InterpretationBox[\(\[Null]\^"*"\),
                                        Superscript[ "*"],
                                        Editable->False]}],
                                      SequenceForm[ 
                                        dZfR1[ 2, 1, 1], 
                                        Superscript[ "*"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "+", 
                              \(1\/2\ \(dZfR1(2, 1, 1)\)\)}], ")"}]}], ",", 
                        "1"}], "}"}], ",", 
                    RowBox[{"{", 
                      RowBox[{
                      "MZ", ",", 
                        \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - CW2)\)\)\/\(2\ CW\ 
                                SW\)\)\), ",", 
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            RowBox[{
                            \(dZAZ1\/2\), "-", 
                              \(\(\((dZe1 - dSW1\/\(CW2\ SW\))\)\ SW\)\/CW\), 
                              "-", \(\(dZZZ1\ \((SW2 - 1\/2)\)\)\/\(2\ CW\ SW
                                    \)\), "+", 
                              \(\(dZe1 - 
                                    \(dSW1\ \((SW2 - CW2)\)\)\/\(CW2\ SW
                                        \)\)\/\(2\ CW\ SW\)\), "-", 
                              FractionBox[
                                RowBox[{\((SW2 - 1\/2)\), " ", 
                                  RowBox[{"(", 
                                    RowBox[{
                                      RowBox[{\(1\/2\), " ", 
                                        RowBox[{"(", 
                                        FormBox[
                                        InterpretationBox[
                                        RowBox[{
                                        \(dZfL1(2, 1, 1)\), 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\^"*"\),
                                        Superscript[ "*"],
                                        Editable->False]}],
                                        SequenceForm[ 
                                        dZfL1[ 2, 1, 1], 
                                        Superscript[ "*"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}], "+", 
                                      \(1\/2\ \(dZfL1(2, 1, 1)\)\)}], ")"}]}],
                                 \(CW\ SW\)]}], ")"}]}], ",", 
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            RowBox[{
                            \(dZAZ1\/2\), "-", \(\(dZZZ1\ SW\)\/\(2\ CW\)\), 
                              "-", \(\(\((dZe1 - dSW1\/\(CW2\ SW\))\)\ SW
                                    \)\/CW\), "-", 
                              FractionBox[
                                RowBox[{"SW", " ", 
                                  RowBox[{"(", 
                                    RowBox[{
                                      RowBox[{\(1\/2\), " ", 
                                        RowBox[{"(", 
                                        FormBox[
                                        InterpretationBox[
                                        RowBox[{
                                        \(dZfR1(2, 1, 1)\), 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\^"*"\),
                                        Superscript[ "*"],
                                        Editable->False]}],
                                        SequenceForm[ 
                                        dZfR1[ 2, 1, 1], 
                                        Superscript[ "*"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}], "+", 
                                      \(1\/2\ \(dZfR1(2, 1, 1)\)\)}], ")"}]}],
                                 "CW"]}], ")"}]}], ",", "1"}], "}"}]}], 
                  ")"}]}]}], ")"}], ",", 
          RowBox[{"FeynAmp", "(", 
            RowBox[{
            \(GraphID(Topology == 3, Generic == 1)\), ",", \(Integral()\), 
              ",", 
              RowBox[{\(-\[ImaginaryI]\), " ", "RelativeCF", " ", 
                FormBox[
                  RowBox[{
                    RowBox[{\("v"\&"_"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]1\),
                            SequenceForm[ "p", 1],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}], ".", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]2\),
                                    SequenceForm[ "Lor", 2],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((0)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}], "+", 
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]2\),
                                    SequenceForm[ "Lor", 2],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "+"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((0)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}]}], ")"}], ".", 
                    RowBox[{\("u"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]2\),
                            SequenceForm[ "p", 2],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}]}],
                  "TraditionalForm"], " ", 
                FormBox[
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]2\),
                            SequenceForm[ "k", 2],
                            Editable->False],
                          "TraditionalForm"], "-", 
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]1\),
                            SequenceForm[ "k", 1],
                            Editable->False],
                          "TraditionalForm"]}], ")"}], "[", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]4\),
                        SequenceForm[ "Lor", 4],
                        Editable->False],
                      "TraditionalForm"], "]"}],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[\("g"\),
                    "TraditionalForm"], "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                        SequenceForm[ "Lor", 1],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                RowBox[{
                  FormBox[\("g"\),
                    "TraditionalForm"], "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                        SequenceForm[ "Lor", 3],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]4\),
                        SequenceForm[ "Lor", 4],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                FormBox[
                  FractionBox["1", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{"-", 
                              RowBox[{"(", 
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "k", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}], "-", 
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]2\),
                                SequenceForm[ "k", 2],
                                Editable->False],
                              "TraditionalForm"]}], ")"}], "2"], "-", 
                      SuperscriptBox[
                        RowBox[{"Mass", "(", 
                          RowBox[{"V", "(", 
                            FormBox[
                              InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                                SequenceForm[ "Gen", 5],
                                Editable->False],
                              "TraditionalForm"], ")"}], ")"}], "2"]}]],
                  "TraditionalForm"], " ", 
                FormBox[
                  FractionBox["1", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]1\),
                                SequenceForm[ "k", 1],
                                Editable->False],
                              "TraditionalForm"], "+", 
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]2\),
                                SequenceForm[ "k", 2],
                                Editable->False],
                              "TraditionalForm"]}], ")"}], "2"], "-", 
                      SuperscriptBox[
                        RowBox[{"Mass", "(", 
                          RowBox[{"V", "(", 
                            FormBox[
                              InterpretationBox[\("Gen"\[InvisibleSpace]6\),
                                SequenceForm[ "Gen", 6],
                                Editable->False],
                              "TraditionalForm"], ")"}], ")"}], "2"]}]],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[
                    TagBox[\(G\_SSV\%\((0)\)\),
                      DisplayForm],
                    "TraditionalForm"], "(", 
                  FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                    "TraditionalForm"], ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      FormBox[
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"-", 
                                RowBox[{"(", 
                                  FormBox[
                                    
                                    InterpretationBox[
                                      \("k"\[InvisibleSpace]1\),
                                      SequenceForm[ "k", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "-", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "[", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                              SequenceForm[ "Lor", 1],
                              Editable->False],
                            "TraditionalForm"], "]"}],
                        "TraditionalForm"], " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"], "+", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "[", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                              SequenceForm[ "Lor", 3],
                              Editable->False],
                            "TraditionalForm"], "]"}],
                        "TraditionalForm"], " ", 
                      RowBox[{
                        FormBox[
                          TagBox[\(G\_VV\%\((1)\)\),
                            DisplayForm],
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[\(\((Mom(1))\) (\(KI1(2)\))\),
                            "TraditionalForm"], " ", 
                          FormBox[\(\((Mom(2))\) (\(KI1(1)\))\),
                            "TraditionalForm"]}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox[\("g"\),
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                              SequenceForm[ "Lor", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                              SequenceForm[ "Lor", 3],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{
                        FormBox[
                          TagBox[\(G\_VV\%\((1)\)\),
                            DisplayForm],
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[\("g"\),
                            "TraditionalForm"], "(", \(KI1(1), KI1(2)\), 
                          ")"}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox[\("g"\),
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                              SequenceForm[ "Lor", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                              SequenceForm[ "Lor", 3],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"-", 
                                RowBox[{"(", 
                                  FormBox[
                                    
                                    InterpretationBox[
                                      \("k"\[InvisibleSpace]1\),
                                      SequenceForm[ "k", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "-", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"], "+", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}]}],
                        "TraditionalForm"], " ", 
                      RowBox[{
                        FormBox[
                          TagBox[\(G\_VV\%\((1)\)\),
                            DisplayForm],
                          "TraditionalForm"], "(", 
                        RowBox[{
                          RowBox[{
                            FormBox[\("g"\),
                              "TraditionalForm"], "(", \(KI1(1), KI1(2)\), 
                            ")"}], " ", 
                          FormBox[\(\(Mom(1)\).\(Mom(2)\)\),
                            "TraditionalForm"]}], ")"}]}]}], ")"}]}], ",", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Mass", "(", 
                      RowBox[{"V", "(", 
                        FormBox[
                          InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                            SequenceForm[ "Gen", 5],
                            Editable->False],
                          "TraditionalForm"], ")"}], ")"}], ",", 
                    RowBox[{"Mass", "(", 
                      RowBox[{"V", "(", 
                        FormBox[
                          InterpretationBox[\("Gen"\[InvisibleSpace]6\),
                            SequenceForm[ "Gen", 6],
                            Editable->False],
                          "TraditionalForm"], ")"}], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"-"\),
                                    Subscript[ "-"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "-"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"+"\),
                                    Subscript[ "+"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "+"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_SSV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_VV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      RowBox[{
                        FormBox[\(\((Mom(1))\) (\(KI1(2)\))\),
                          "TraditionalForm"], " ", 
                        FormBox[\(\((Mom(2))\) (\(KI1(1)\))\),
                          "TraditionalForm"]}], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_VV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      RowBox[{
                        FormBox[\("g"\),
                          "TraditionalForm"], "(", \(KI1(1), KI1(2)\), ")"}], 
                      ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_VV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      RowBox[{
                        RowBox[{
                          FormBox[\("g"\),
                            "TraditionalForm"], "(", \(KI1(1), KI1(2)\), 
                          ")"}], " ", 
                        FormBox[\(\(Mom(1)\).\(Mom(2)\)\),
                          "TraditionalForm"]}], ")"}], ",", "RelativeCF"}], 
                  "}"}], "\[Rule]", 
                \(\((Insertions(Classes))\) (
                  \({0, 0, \[ImaginaryI]\ EL, \[ImaginaryI]\ EL, 
                    \[ImaginaryI]\ EL, \(-\[ImaginaryI]\)\ dZAA1, 0, 
                    \[ImaginaryI]\ dZAA1, 1}, {0, MZ, \[ImaginaryI]\ EL, 
                    \[ImaginaryI]\ EL, 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - CW2)\)\)\/\(2\ CW\ SW
                            \)\)\), 
                    \[ImaginaryI]\ \((\(-\(dZAZ1\/2\)\) - dZZA1\/2)\), 
                    \(\[ImaginaryI]\ dZZA1\ MZ2\)\/2, 
                    \[ImaginaryI]\ \((dZAZ1\/2 + dZZA1\/2)\), 1}, {MZ, 0, 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - 1\/2)\)\)\/\(CW\ SW
                            \)\)\), \(-\(\(\[ImaginaryI]\ EL\ SW\)\/CW\)\), 
                    \[ImaginaryI]\ EL, 
                    \[ImaginaryI]\ \((\(-\(dZAZ1\/2\)\) - dZZA1\/2)\), 
                    \(\[ImaginaryI]\ dZZA1\ MZ2\)\/2, 
                    \[ImaginaryI]\ \((dZAZ1\/2 + dZZA1\/2)\), 1}, {MZ, MZ, 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - 1\/2)\)\)\/\(CW\ SW
                            \)\)\), \(-\(\(\[ImaginaryI]\ EL\ SW\)\/CW\)\), 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - CW2)\)\)\/\(2\ CW\ SW
                            \)\)\), \(-\[ImaginaryI]\)\ dZZZ1, 
                    \[ImaginaryI]\ \((dMZsq1 + dZZZ1\ MZ2)\), 
                    \[ImaginaryI]\ dZZZ1, 1}\))\)}]}], ")"}]}], ")"}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(tops\  = \ CreateTopologies[0, \ 2\  -> \ 2]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DoPaint[inss, \ "\<born\>"]; \)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("initializing classes model file \
"\[InvisibleSpace]"C:\\PROGRA~1\\WOLFRA~1\\MATHEM~1\\3.0\\AddOns\\\
Applications\\Models\\MSSM.mod"\),
        SequenceForm[ 
        "initializing classes model file ", 
          "C:\\PROGRA~1\\WOLFRA~1\\MATHEM~1\\3.0\\AddOns\\Applications\\\
Models\\MSSM.mod"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> "\[InvisibleSpace]94
          \[InvisibleSpace]" particles (incl. antiparticles) in "\
\[InvisibleSpace]23\[InvisibleSpace]" classes"\),
        SequenceForm[ 
        "> ", 94, " particles (incl. antiparticles) in ", 23, " classes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"> $CounterTerms are ON"\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> "\[InvisibleSpace]383\[InvisibleSpace]" vertices"\),
        SequenceForm[ "> ", 383, " vertices"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("classes model "\[InvisibleSpace]"MSSM"\[InvisibleSpace]" \
initialized"\),
        SequenceForm[ "classes model ", "MSSM", " initialized"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("Excluding "\[InvisibleSpace]18
          \[InvisibleSpace]" field point(s) (incl. charge conjugate ones)"\),
        SequenceForm[ 
        "Excluding ", 18, " field point(s) (incl. charge conjugate ones)"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("inserting at level(s) "\[InvisibleSpace]{Generic, Classes}\),
        SequenceForm[ "inserting at level(s) ", {Generic, Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]1
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]2
          \[InvisibleSpace]": "\[InvisibleSpace]"1 Generic, 2 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 2, ": ", "1 Generic, 2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]3
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]4
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 4, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("in total: "\[InvisibleSpace]"1 Generic, 2 Classes insertions"\),
        SequenceForm[ "in total: ", "1 Generic, 2 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("Restoring "\[InvisibleSpace]18\[InvisibleSpace]" field point(s)"\),
        
        SequenceForm[ "Restoring ", 18, " field point(s)"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]1
          \[InvisibleSpace]": "\[InvisibleSpace]"2 diagrams"\),
        SequenceForm[ "> Top. ", 1, ": ", "2 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.325 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.0113636 0 0.0113636 [
[ 0 0 0 0 ]
[ 1 1.325 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.325 L
0 1.325 L
closepath
clip
newpath
% Start of sub-graphic
p
0 1 0.25 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.68182 .5 m
.67727 .50393 L
.67273 .50738 L
.66818 .50991 L
.66363 .51122 L
.65909 .51114 L
.65454 .50968 L
.65 .50703 L
.64545 .50351 L
.64091 .49955 L
.63636 .49564 L
.63182 .49228 L
.62727 .48987 L
.62273 .48871 L
.61818 .48894 L
.61364 .49054 L
.60909 .49331 L
.60455 .4969 L
.6 .50088 L
.59545 .50474 L
.59091 .50802 L
.58636 .51031 L
.58182 .51131 L
.57727 .51092 L
.57273 .50918 L
.56818 .5063 L
.56364 .50264 L
.55909 .49865 L
.55455 .49482 L
.55 .49164 L
.54546 .48948 L
.54091 .48863 L
.53636 .48918 L
.53182 .49106 L
.52727 .49404 L
.52273 .49777 L
.51818 .50176 L
.51364 .50553 L
.50909 .50862 L
.50455 .51064 L
.5 .51135 L
.49545 .51064 L
.49091 .50862 L
.48636 .50553 L
.48182 .50176 L
.47727 .49777 L
.47273 .49404 L
.46818 .49106 L
.46364 .48918 L
.45909 .48863 L
Mistroke
.45454 .48948 L
.45 .49164 L
.44545 .49482 L
.44091 .49865 L
.43636 .50264 L
.43182 .5063 L
.42727 .50918 L
.42273 .51092 L
.41818 .51131 L
.41364 .51031 L
.40909 .50802 L
.40455 .50474 L
.4 .50088 L
.39545 .4969 L
.39091 .49331 L
.38636 .49054 L
.38182 .48894 L
.37727 .48871 L
.37273 .48987 L
.36818 .49228 L
.36364 .49564 L
.35909 .49955 L
.35455 .50351 L
.35 .50703 L
.34546 .50968 L
.34091 .51114 L
.33637 .51122 L
.33182 .50991 L
.32727 .50738 L
.32273 .50393 L
.31818 .5 L
Mfstroke
gsave
.5 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C1) show
77.812500 14.625000 moveto
(N1) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 1 0.5 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.68182 .5 m
.67727 .50393 L
.67273 .50738 L
.66818 .50991 L
.66363 .51122 L
.65909 .51114 L
.65454 .50968 L
.65 .50703 L
.64545 .50351 L
.64091 .49955 L
.63636 .49564 L
.63182 .49228 L
.62727 .48987 L
.62273 .48871 L
.61818 .48894 L
.61364 .49054 L
.60909 .49331 L
.60455 .4969 L
.6 .50088 L
.59545 .50474 L
.59091 .50802 L
.58636 .51031 L
.58182 .51131 L
.57727 .51092 L
.57273 .50918 L
.56818 .5063 L
.56364 .50264 L
.55909 .49865 L
.55455 .49482 L
.55 .49164 L
.54546 .48948 L
.54091 .48863 L
.53636 .48918 L
.53182 .49106 L
.52727 .49404 L
.52273 .49777 L
.51818 .50176 L
.51364 .50553 L
.50909 .50862 L
.50455 .51064 L
.5 .51135 L
.49545 .51064 L
.49091 .50862 L
.48636 .50553 L
.48182 .50176 L
.47727 .49777 L
.47273 .49404 L
.46818 .49106 L
.46364 .48918 L
.45909 .48863 L
Mistroke
.45454 .48948 L
.45 .49164 L
.44545 .49482 L
.44091 .49865 L
.43636 .50264 L
.43182 .5063 L
.42727 .50918 L
.42273 .51092 L
.41818 .51131 L
.41364 .51031 L
.40909 .50802 L
.40455 .50474 L
.4 .50088 L
.39545 .4969 L
.39091 .49331 L
.38636 .49054 L
.38182 .48894 L
.37727 .48871 L
.37273 .48987 L
.36818 .49228 L
.36364 .49564 L
.35909 .49955 L
.35455 .50351 L
.35 .50703 L
.34546 .50968 L
.34091 .51114 L
.33637 .51122 L
.33182 .50991 L
.32727 .50738 L
.32273 .50393 L
.31818 .5 L
Mfstroke
gsave
.5 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C2) show
77.812500 14.625000 moveto
(N2) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.39773 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.44886 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.5 1.295 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
63.000000 14.625000 moveto
(\\256) show
68.750000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
gsave
.55114 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.60227 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{217.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003I000182000`400?l00000o`00003of@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00
f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo
003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00
f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo
003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00
f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo
003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00
f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo
000A0?ooo`040000003oool0oooo00000080oooo0`0000020?ooo`050000003oool000000?ooo`00
00000P3oool00`000000oooo0?ooo`0Q0?ooo`040000003oool0oooo00000080oooo0`000000203o
ool000000000003oool000000?ooo`000000oooo0P00001o0?ooo`004@3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P0000020?ooo`030000
003oool0oooo0240oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool00000008000000P3oool00`000000oooo0?ooo`1m0?ooo`004@3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P0000020?ooo`03
0000003oool0oooo0240oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?oo
o`@000000`3oool00`000000oooo0?ooo`1l0?ooo`00303oool200000080oooo0`0000050?ooo`80
0000103oool00`000000oooo0?ooo`0Q0?ooo`8000000P3oool3000000D0oooo0P0000020?ooo`03
0000003oool0000000@0oooo00<000000?ooo`3oool0O@3oool000`0oooo0`00000c0?ooo`<00000
U03oool000d0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`2C0?ooo`00f@3oool0
01T0oooo00<000000?ooo`3oool0_@3oool00080oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0503oool2000001P0
oooo00<000000?ooo`3oool0K@3oool000<0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0000000G0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo06h0oooo00040?ooo`8000004`3oool3000001D0oooo00<0
00000?ooo`3oool01P3oool2000001@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`1_0?ooo`001P3oool00`000000oooo0?ooo`0V0?ooo`8000002`3oool00`000000oooo0?ooo`0@
0?ooo`<000004`3oool200000780oooo00070?ooo`030000003oool0oooo02@0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0780oooo00080?ooo`80
00008`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?ooo`1c0?ooo`00
203oool3000001l0oooo0`00000A0?ooo`<000007`3oool3000007H0oooo00020?ooo`8000001`3o
ool00`000000oooo0?ooo`0L0?ooo`8000003@3oool2000000H0oooo00<000000?ooo`3oool0703o
ool2000007L0oooo00020?ooo`<000001`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0M`3oool0
00<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
07P0oooo000>0?ooo`8000005`3oool00`000000oooo0?ooo`0J0?ooo`8000005`3oool00`000000
oooo0?ooo`1i0?ooo`00403oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo0P00000O0?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3o
ool2000007`0oooo000A0?ooo`D0000000<0oooo0000000000001P0000000`3oool0000000000003
00000280oooo1@0000000`3oool0000000000006000000030?ooo`000000000000<00000OP3oool0
0100oooo0`0000030?ooo`8000000P3oool200000080oooo0P0000030?ooo`<000002@3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0000000<0oooo0P0000020?ooo`8000000`3oool20000
0080oooo0`0000090?ooo`030000003oool0oooo0740oooo000>0?ooo`8000005P3oool2000000L0
oooo0`00000B0?ooo`8000005P3oool2000000L0oooo0`00001a0?ooo`003@3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000004@3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`000000L@3oool000`0oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0740oooo000;
0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0L
0?ooo`030000003oool0oooo07H0oooo00090?ooo`800000803oool200000180oooo0P00000P0?oo
o`<00000M@3oool000P0oooo00<000000?ooo`3oool08@3oool200000100oooo00<000000?ooo`3o
ool08@3oool2000007D0oooo00070?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0780oooo00060?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo0740oooo00040?ooo`800000:P3oool2000000P0oooo0P00000Z0?ooo`800000L@3oool0
00<0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
02`0oooo00<000000?ooo`3oool0KP3oool00080oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0K@3oool002@0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`1l0?ooo`00903oool3000003<0oooo0`00
001l0?ooo`00903oool00`000000oooo0000000c0?ooo`030000003oool0000007`0oooo000T0?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool0O03oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00
f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool005@0oooo0`000008
0?ooo`<000002`3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000L0oooo00@0
00000?ooo`3oool00000EP3oool005@0oooo0`0000080?ooo`<00000203oool5000000D0oooo00@0
00000?ooo`3oool000001`3oool010000000oooo0?ooo`00001F0?ooo`00E03oool3000000P0oooo
0`00000;0?ooo`030000003oool0oooo00@0oooo100000070?ooo`@00000EP3oool007@0oooo00@0
00000?ooo`3oool000001`3oool010000000oooo0?ooo`00001F0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00=T0oooo0000\
\>"],
  ImageRangeCache->{{{0, 216.313}, {287, 0}} -> {-0.000440006, -0.0790874, 
  0.406824, 0.406824}, {{0, 54.0625}, {70.4375, 16.375}} -> {-1.00011,
   -89.1283, 0.406941, 0.406941}, {{54.0625, 108.125}, {70.4375, 16.375}} ->
   {-23.0004, -89.1283, 0.406941, 0.406941}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(born\  = \ CalcFeynAmp[bornamp\  = \ CreateFeynAmp[ins]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("creating amplitudes at level(s) "\[InvisibleSpace]{Generic, 
            Classes}\),
        SequenceForm[ "creating amplitudes at level(s) ", {Generic, Classes}],
        
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]1
          \[InvisibleSpace]": "\[InvisibleSpace]"1 Generic, 2 Classes \
amplitudes"\),
        SequenceForm[ "> Top. ", 1, ": ", "1 Generic, 2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("in total: "\[InvisibleSpace]"1 Generic, 2 Classes amplitudes"\),
        SequenceForm[ "in total: ", "1 Generic, 2 Classes amplitudes"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> "\[InvisibleSpace]1
          \[InvisibleSpace]" amplitudes with insertions"\),
        SequenceForm[ "> ", 1, " amplitudes with insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> "\[InvisibleSpace]0
          \[InvisibleSpace]" amplitudes without insertions"\),
        SequenceForm[ "> ", 0, " amplitudes without insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell["running FORM... ", "Print"],

Cell[BoxData[
    \(TraditionalForm\`"Done"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm\`"ok"\)], "Print"],

Cell[BoxData[
    \(TraditionalForm
    \`\((Amp({ME, ME} \[Rule] {MHp, MHp}))\) (
      \(\((8\ Alfa\ \[Pi]\ \(Den(S, 0)\) + 
              \((\(4\ \[Pi]\ SW2\ Alfa\)\/CW2 + \(2\ \[Pi]\ Alfa\)\/SW2 - 
                    \(2\ \[Pi]\ Alfa\)\/CW2 - 4\ \[Pi]\ Alfa)\)\ 
                \(Den(S, MZ2)\))\)\ \(Mat(F1)\) + 
        \((8\ Alfa\ \[Pi]\ \(Den(S, 0)\) + 
              \((\(4\ Alfa\ \[Pi]\ SW2\)\/CW2 - 4\ Alfa\ \[Pi])\)\ 
                \(Den(S, MZ2)\))\)\ \(Mat(F2)\)\))\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(counter\  = \ Head[bornamp]@@\ counter\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", 
          RowBox[{"FeynAmpList", "(", 
            RowBox[{
            \(Model \[Rule] "MSSM"\), ",", \(GenericModel \[Rule] "Lorentz"\),
               ",", \(InsertionLevel \[Rule] Classes\), ",", 
              \(ExcludeParticles \[Rule] {}\), ",", 
              \(LastSelections \[Rule] {}\), ",", 
              \(ExcludeFieldPoints \[Rule] {}\), ",", 
              \(Restrictions \[Rule] 
                \(ExcludeFieldPoints 
                  \[Rule] {\((FieldPoint(_))\) (\(\(-\(F(2)\)\), F(2), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(2)\)\), F(1), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(3, {1, ___})\)\), 
                      F(3, {1, ___}), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(3, {2, ___})\)\), 
                      F(3, {2, ___}), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(4)\)\), F(4), S\)), 
                    \((FieldPoint(_))\) (\(\(-\(F(4)\)\), F(3, {1, ___}), S
                      \)), \((FieldPoint(_))\) (\(\(-\(F(4)\)\), 
                      F(3, {2, ___}), S\))}\)\), ",", 
              RowBox[{"Process", "\[Rule]", 
                RowBox[{
                  RowBox[{"(", GridBox[{
                        {\(-\(F(2, {1})\)\), 
                          FormBox[\("p"\[InvisibleSpace]1\),
                            "TraditionalForm"], "ME"},
                        {\(F(2, {1})\), 
                          FormBox[\("p"\[InvisibleSpace]2\),
                            "TraditionalForm"], "ME"}
                        }], ")"}], "\[Rule]", 
                  RowBox[{"(", GridBox[{
                        {\(-\(S(5)\)\), 
                          FormBox[\("k"\[InvisibleSpace]1\),
                            "TraditionalForm"], "MHp"},
                        {\(S(5)\), 
                          FormBox[\("k"\[InvisibleSpace]2\),
                            "TraditionalForm"], "MHp"}
                        }], ")"}]}]}]}], ")"}], ")"}], "(", 
        RowBox[{
          RowBox[{"FeynAmp", "(", 
            RowBox[{
            \(GraphID(Topology == 1, Generic == 1)\), ",", \(Integral()\), 
              ",", 
              RowBox[{"RelativeCF", " ", 
                FormBox[
                  RowBox[{
                    RowBox[{\("v"\&"_"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]1\),
                            SequenceForm[ "p", 1],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}], ".", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]1\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((0)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}], "+", 
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]1\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "+"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((0)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}]}], ")"}], ".", 
                    RowBox[{\("u"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]2\),
                            SequenceForm[ "p", 2],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}]}],
                  "TraditionalForm"], " ", 
                FormBox[
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]2\),
                            SequenceForm[ "k", 2],
                            Editable->False],
                          "TraditionalForm"], "-", 
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]1\),
                            SequenceForm[ "k", 1],
                            Editable->False],
                          "TraditionalForm"]}], ")"}], "[", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"], "]"}],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[\("g"\),
                    "TraditionalForm"], "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                        SequenceForm[ "Lor", 1],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                FormBox[
                  FractionBox["1", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]1\),
                                SequenceForm[ "k", 1],
                                Editable->False],
                              "TraditionalForm"], "+", 
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]2\),
                                SequenceForm[ "k", 2],
                                Editable->False],
                              "TraditionalForm"]}], ")"}], "2"], "-", 
                      SuperscriptBox[
                        RowBox[{"Mass", "(", 
                          RowBox[{"V", "(", 
                            FormBox[
                              InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                                SequenceForm[ "Gen", 5],
                                Editable->False],
                              "TraditionalForm"], ")"}], ")"}], "2"]}]],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[
                    TagBox[\(G\_SSV\%\((1)\)\),
                      DisplayForm],
                    "TraditionalForm"], "(", 
                  FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                    "TraditionalForm"], ")"}]}], ",", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Mass", "(", 
                      RowBox[{"V", "(", 
                        FormBox[
                          InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                            SequenceForm[ "Gen", 5],
                            Editable->False],
                          "TraditionalForm"], ")"}], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"-"\),
                                    Subscript[ "-"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "-"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"+"\),
                                    Subscript[ "+"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "+"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_SSV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                        "TraditionalForm"], ")"}], ",", "RelativeCF"}], "}"}],
                 "\[Rule]", 
                \(\((Insertions(Classes))\) (
                  \({0, \[ImaginaryI]\ EL, \[ImaginaryI]\ EL, 
                    \[ImaginaryI]\ EL\ \((
                      dZAA1\/2 + dZe1 + dZGp1 - 
                        \(dZZA1\ \((SW2 - CW2)\)\)\/\(4\ CW\ SW\))\), 1}, {
                    MZ, \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - 1\/2)\)\)\/\(CW\ SW
                            \)\)\), \(-\(\(\[ImaginaryI]\ EL\ SW\)\/CW\)\), 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - CW2)\)\ 
                            \((\(-\(dSW1\/\(CW2\ SW\ \((SW2 - CW2)\)\)\)\) + 
                                dZe1 + dZGp1 + dZZZ1\/2 - 
                                \(CW\ dZAZ1\ SW\)\/\(SW2 - CW2\))\)\)\/\(2\ CW
                            \ SW\)\)\), 1}\))\)}]}], ")"}], ",", 
          RowBox[{"FeynAmp", "(", 
            RowBox[{
            \(GraphID(Topology == 2, Generic == 1)\), ",", \(Integral()\), 
              ",", 
              RowBox[{"RelativeCF", " ", 
                FormBox[
                  RowBox[{
                    RowBox[{\("v"\&"_"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]1\),
                            SequenceForm[ "p", 1],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}], ".", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]1\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((1)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}], "+", 
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]1\),
                                    SequenceForm[ "Lor", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "+"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((1)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}]}], ")"}], ".", 
                    RowBox[{\("u"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]2\),
                            SequenceForm[ "p", 2],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}]}],
                  "TraditionalForm"], " ", 
                FormBox[
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]2\),
                            SequenceForm[ "k", 2],
                            Editable->False],
                          "TraditionalForm"], "-", 
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]1\),
                            SequenceForm[ "k", 1],
                            Editable->False],
                          "TraditionalForm"]}], ")"}], "[", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"], "]"}],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[\("g"\),
                    "TraditionalForm"], "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                        SequenceForm[ "Lor", 1],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                FormBox[
                  FractionBox["1", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]1\),
                                SequenceForm[ "k", 1],
                                Editable->False],
                              "TraditionalForm"], "+", 
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]2\),
                                SequenceForm[ "k", 2],
                                Editable->False],
                              "TraditionalForm"]}], ")"}], "2"], "-", 
                      SuperscriptBox[
                        RowBox[{"Mass", "(", 
                          RowBox[{"V", "(", 
                            FormBox[
                              InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                                SequenceForm[ "Gen", 5],
                                Editable->False],
                              "TraditionalForm"], ")"}], ")"}], "2"]}]],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[
                    TagBox[\(G\_SSV\%\((0)\)\),
                      DisplayForm],
                    "TraditionalForm"], "(", 
                  FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                    "TraditionalForm"], ")"}]}], ",", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Mass", "(", 
                      RowBox[{"V", "(", 
                        FormBox[
                          InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                            SequenceForm[ "Gen", 5],
                            Editable->False],
                          "TraditionalForm"], ")"}], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_SSV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"-"\),
                                    Subscript[ "-"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "-"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"+"\),
                                    Subscript[ "+"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "+"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", "RelativeCF"}], "}"}],
                 "\[Rule]", 
                RowBox[{\((Insertions(Classes))\), "(", 
                  RowBox[{
                    RowBox[{"{", 
                      RowBox[{"0", ",", \(\[ImaginaryI]\ EL\), ",", 
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            RowBox[{
                            \(dZAA1\/2\), "+", "dZe1", "-", 
                              \(\(dZZA1\ \((SW2 - 1\/2)\)\)\/\(2\ CW\ SW\)\), 
                              "+", 
                              RowBox[{\(1\/2\), " ", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{
                                      \(dZfL1(2, 1, 1)\), "\[InvisibleSpace]",
                                         
                                        InterpretationBox[\(\[Null]\^"*"\),
                                        Superscript[ "*"],
                                        Editable->False]}],
                                      SequenceForm[ 
                                        dZfL1[ 2, 1, 1], 
                                        Superscript[ "*"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "+", 
                              \(1\/2\ \(dZfL1(2, 1, 1)\)\)}], ")"}]}], ",", 
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            RowBox[{
                            \(dZAA1\/2\), "+", "dZe1", "-", 
                              \(\(dZZA1\ SW\)\/\(2\ CW\)\), "+", 
                              RowBox[{\(1\/2\), " ", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{
                                      \(dZfR1(2, 1, 1)\), "\[InvisibleSpace]",
                                         
                                        InterpretationBox[\(\[Null]\^"*"\),
                                        Superscript[ "*"],
                                        Editable->False]}],
                                      SequenceForm[ 
                                        dZfR1[ 2, 1, 1], 
                                        Superscript[ "*"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "+", 
                              \(1\/2\ \(dZfR1(2, 1, 1)\)\)}], ")"}]}], ",", 
                        "1"}], "}"}], ",", 
                    RowBox[{"{", 
                      RowBox[{
                      "MZ", ",", 
                        \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - CW2)\)\)\/\(2\ CW\ 
                                SW\)\)\), ",", 
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            RowBox[{
                            \(dZAZ1\/2\), "-", 
                              \(\(\((dZe1 - dSW1\/\(CW2\ SW\))\)\ SW\)\/CW\), 
                              "-", \(\(dZZZ1\ \((SW2 - 1\/2)\)\)\/\(2\ CW\ SW
                                    \)\), "+", 
                              \(\(dZe1 - 
                                    \(dSW1\ \((SW2 - CW2)\)\)\/\(CW2\ SW
                                        \)\)\/\(2\ CW\ SW\)\), "-", 
                              FractionBox[
                                RowBox[{\((SW2 - 1\/2)\), " ", 
                                  RowBox[{"(", 
                                    RowBox[{
                                      RowBox[{\(1\/2\), " ", 
                                        RowBox[{"(", 
                                        FormBox[
                                        InterpretationBox[
                                        RowBox[{
                                        \(dZfL1(2, 1, 1)\), 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\^"*"\),
                                        Superscript[ "*"],
                                        Editable->False]}],
                                        SequenceForm[ 
                                        dZfL1[ 2, 1, 1], 
                                        Superscript[ "*"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}], "+", 
                                      \(1\/2\ \(dZfL1(2, 1, 1)\)\)}], ")"}]}],
                                 \(CW\ SW\)]}], ")"}]}], ",", 
                        RowBox[{"\[ImaginaryI]", " ", "EL", " ", 
                          RowBox[{"(", 
                            RowBox[{
                            \(dZAZ1\/2\), "-", \(\(dZZZ1\ SW\)\/\(2\ CW\)\), 
                              "-", \(\(\((dZe1 - dSW1\/\(CW2\ SW\))\)\ SW
                                    \)\/CW\), "-", 
                              FractionBox[
                                RowBox[{"SW", " ", 
                                  RowBox[{"(", 
                                    RowBox[{
                                      RowBox[{\(1\/2\), " ", 
                                        RowBox[{"(", 
                                        FormBox[
                                        InterpretationBox[
                                        RowBox[{
                                        \(dZfR1(2, 1, 1)\), 
                                        "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\^"*"\),
                                        Superscript[ "*"],
                                        Editable->False]}],
                                        SequenceForm[ 
                                        dZfR1[ 2, 1, 1], 
                                        Superscript[ "*"]],
                                        Editable->False],
                                        "TraditionalForm"], ")"}]}], "+", 
                                      \(1\/2\ \(dZfR1(2, 1, 1)\)\)}], ")"}]}],
                                 "CW"]}], ")"}]}], ",", "1"}], "}"}]}], 
                  ")"}]}]}], ")"}], ",", 
          RowBox[{"FeynAmp", "(", 
            RowBox[{
            \(GraphID(Topology == 3, Generic == 1)\), ",", \(Integral()\), 
              ",", 
              RowBox[{\(-\[ImaginaryI]\), " ", "RelativeCF", " ", 
                FormBox[
                  RowBox[{
                    RowBox[{\("v"\&"_"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]1\),
                            SequenceForm[ "p", 1],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}], ".", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]2\),
                                    SequenceForm[ "Lor", 2],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "-"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((0)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"-"\),
                                        Subscript[ "-"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "-"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}], "+", 
                        RowBox[{
                          FormBox[
                            RowBox[{
                              RowBox[{
                                FormBox[\("ga"\),
                                  "TraditionalForm"], "(", 
                                FormBox[
                                  
                                  InterpretationBox[
                                    \("Lor"\[InvisibleSpace]2\),
                                    SequenceForm[ "Lor", 2],
                                    Editable->False],
                                  "TraditionalForm"], ")"}], ".", 
                              RowBox[{"(", 
                                FormBox[
                                  InterpretationBox[
                                    RowBox[{\("om"\), "\[InvisibleSpace]", 
                                      InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                    SequenceForm[ "om", 
                                      Subscript[ "+"]],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}],
                            "TraditionalForm"], " ", 
                          RowBox[{
                            FormBox[
                              TagBox[\(G\_FFV\%\((0)\)\),
                                DisplayForm],
                              "TraditionalForm"], "(", 
                            FormBox[
                              RowBox[{
                                RowBox[{
                                  FormBox[\("ga"\),
                                    "TraditionalForm"], "(", \(KI1(3)\), 
                                  ")"}], ".", 
                                RowBox[{"(", 
                                  FormBox[
                                    InterpretationBox[
                                      RowBox[{\("om"\), "\[InvisibleSpace]", 
                                        InterpretationBox[\(\[Null]\_"+"\),
                                        Subscript[ "+"],
                                        Editable->False]}],
                                      SequenceForm[ "om", 
                                        Subscript[ "+"]],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}],
                              "TraditionalForm"], ")"}]}]}], ")"}], ".", 
                    RowBox[{\("u"\), "[", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("p"\[InvisibleSpace]2\),
                            SequenceForm[ "p", 2],
                            Editable->False],
                          "TraditionalForm"], ",", "ME"}], "]"}]}],
                  "TraditionalForm"], " ", 
                FormBox[
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]2\),
                            SequenceForm[ "k", 2],
                            Editable->False],
                          "TraditionalForm"], "-", 
                        FormBox[
                          InterpretationBox[\("k"\[InvisibleSpace]1\),
                            SequenceForm[ "k", 1],
                            Editable->False],
                          "TraditionalForm"]}], ")"}], "[", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]4\),
                        SequenceForm[ "Lor", 4],
                        Editable->False],
                      "TraditionalForm"], "]"}],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[\("g"\),
                    "TraditionalForm"], "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                        SequenceForm[ "Lor", 1],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]2\),
                        SequenceForm[ "Lor", 2],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                RowBox[{
                  FormBox[\("g"\),
                    "TraditionalForm"], "(", 
                  RowBox[{
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                        SequenceForm[ "Lor", 3],
                        Editable->False],
                      "TraditionalForm"], ",", 
                    FormBox[
                      InterpretationBox[\("Lor"\[InvisibleSpace]4\),
                        SequenceForm[ "Lor", 4],
                        Editable->False],
                      "TraditionalForm"]}], ")"}], " ", 
                FormBox[
                  FractionBox["1", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{"-", 
                              RowBox[{"(", 
                                FormBox[
                                  
                                  InterpretationBox[\("k"\[InvisibleSpace]1\),
                                    
                                    SequenceForm[ "k", 1],
                                    Editable->False],
                                  "TraditionalForm"], ")"}]}], "-", 
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]2\),
                                SequenceForm[ "k", 2],
                                Editable->False],
                              "TraditionalForm"]}], ")"}], "2"], "-", 
                      SuperscriptBox[
                        RowBox[{"Mass", "(", 
                          RowBox[{"V", "(", 
                            FormBox[
                              InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                                SequenceForm[ "Gen", 5],
                                Editable->False],
                              "TraditionalForm"], ")"}], ")"}], "2"]}]],
                  "TraditionalForm"], " ", 
                FormBox[
                  FractionBox["1", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          RowBox[{
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]1\),
                                SequenceForm[ "k", 1],
                                Editable->False],
                              "TraditionalForm"], "+", 
                            FormBox[
                              InterpretationBox[\("k"\[InvisibleSpace]2\),
                                SequenceForm[ "k", 2],
                                Editable->False],
                              "TraditionalForm"]}], ")"}], "2"], "-", 
                      SuperscriptBox[
                        RowBox[{"Mass", "(", 
                          RowBox[{"V", "(", 
                            FormBox[
                              InterpretationBox[\("Gen"\[InvisibleSpace]6\),
                                SequenceForm[ "Gen", 6],
                                Editable->False],
                              "TraditionalForm"], ")"}], ")"}], "2"]}]],
                  "TraditionalForm"], " ", 
                RowBox[{
                  FormBox[
                    TagBox[\(G\_SSV\%\((0)\)\),
                      DisplayForm],
                    "TraditionalForm"], "(", 
                  FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                    "TraditionalForm"], ")"}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      FormBox[
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"-", 
                                RowBox[{"(", 
                                  FormBox[
                                    
                                    InterpretationBox[
                                      \("k"\[InvisibleSpace]1\),
                                      SequenceForm[ "k", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "-", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "[", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                              SequenceForm[ "Lor", 1],
                              Editable->False],
                            "TraditionalForm"], "]"}],
                        "TraditionalForm"], " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"], "+", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], "[", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                              SequenceForm[ "Lor", 3],
                              Editable->False],
                            "TraditionalForm"], "]"}],
                        "TraditionalForm"], " ", 
                      RowBox[{
                        FormBox[
                          TagBox[\(G\_VV\%\((1)\)\),
                            DisplayForm],
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[\(\((Mom(1))\) (\(KI1(2)\))\),
                            "TraditionalForm"], " ", 
                          FormBox[\(\((Mom(2))\) (\(KI1(1)\))\),
                            "TraditionalForm"]}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox[\("g"\),
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                              SequenceForm[ "Lor", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                              SequenceForm[ "Lor", 3],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      RowBox[{
                        FormBox[
                          TagBox[\(G\_VV\%\((1)\)\),
                            DisplayForm],
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[\("g"\),
                            "TraditionalForm"], "(", \(KI1(1), KI1(2)\), 
                          ")"}], ")"}]}], "+", 
                    RowBox[{
                      RowBox[{
                        FormBox[\("g"\),
                          "TraditionalForm"], "(", 
                        RowBox[{
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]1\),
                              SequenceForm[ "Lor", 1],
                              Editable->False],
                            "TraditionalForm"], ",", 
                          FormBox[
                            InterpretationBox[\("Lor"\[InvisibleSpace]3\),
                              SequenceForm[ "Lor", 3],
                              Editable->False],
                            "TraditionalForm"]}], ")"}], " ", 
                      FormBox[
                        RowBox[{
                          RowBox[{"(", 
                            RowBox[{
                              RowBox[{"-", 
                                RowBox[{"(", 
                                  FormBox[
                                    
                                    InterpretationBox[
                                      \("k"\[InvisibleSpace]1\),
                                      SequenceForm[ "k", 1],
                                      Editable->False],
                                    "TraditionalForm"], ")"}]}], "-", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}], ".", 
                          RowBox[{"(", 
                            RowBox[{
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]1\),
                                  SequenceForm[ "k", 1],
                                  Editable->False],
                                "TraditionalForm"], "+", 
                              FormBox[
                                InterpretationBox[\("k"\[InvisibleSpace]2\),
                                  SequenceForm[ "k", 2],
                                  Editable->False],
                                "TraditionalForm"]}], ")"}]}],
                        "TraditionalForm"], " ", 
                      RowBox[{
                        FormBox[
                          TagBox[\(G\_VV\%\((1)\)\),
                            DisplayForm],
                          "TraditionalForm"], "(", 
                        RowBox[{
                          RowBox[{
                            FormBox[\("g"\),
                              "TraditionalForm"], "(", \(KI1(1), KI1(2)\), 
                            ")"}], " ", 
                          FormBox[\(\(Mom(1)\).\(Mom(2)\)\),
                            "TraditionalForm"]}], ")"}]}]}], ")"}]}], ",", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"Mass", "(", 
                      RowBox[{"V", "(", 
                        FormBox[
                          InterpretationBox[\("Gen"\[InvisibleSpace]5\),
                            SequenceForm[ "Gen", 5],
                            Editable->False],
                          "TraditionalForm"], ")"}], ")"}], ",", 
                    RowBox[{"Mass", "(", 
                      RowBox[{"V", "(", 
                        FormBox[
                          InterpretationBox[\("Gen"\[InvisibleSpace]6\),
                            SequenceForm[ "Gen", 6],
                            Editable->False],
                          "TraditionalForm"], ")"}], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"-"\),
                                    Subscript[ "-"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "-"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_FFV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\("ga"\),
                              "TraditionalForm"], "(", \(KI1(3)\), ")"}], ".",
                           
                          RowBox[{"(", 
                            FormBox[
                              InterpretationBox[
                                RowBox[{\("om"\), "\[InvisibleSpace]", 
                                  InterpretationBox[\(\[Null]\_"+"\),
                                    Subscript[ "+"],
                                    Editable->False]}],
                                SequenceForm[ "om", 
                                  Subscript[ "+"]],
                                Editable->False],
                              "TraditionalForm"], ")"}]}],
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_SSV\%\((0)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      FormBox[\(\((Mom(1) - Mom(2))\)[KI1(3)]\),
                        "TraditionalForm"], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_VV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      RowBox[{
                        FormBox[\(\((Mom(1))\) (\(KI1(2)\))\),
                          "TraditionalForm"], " ", 
                        FormBox[\(\((Mom(2))\) (\(KI1(1)\))\),
                          "TraditionalForm"]}], ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_VV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      RowBox[{
                        FormBox[\("g"\),
                          "TraditionalForm"], "(", \(KI1(1), KI1(2)\), ")"}], 
                      ")"}], ",", 
                    RowBox[{
                      FormBox[
                        TagBox[\(G\_VV\%\((1)\)\),
                          DisplayForm],
                        "TraditionalForm"], "(", 
                      RowBox[{
                        RowBox[{
                          FormBox[\("g"\),
                            "TraditionalForm"], "(", \(KI1(1), KI1(2)\), 
                          ")"}], " ", 
                        FormBox[\(\(Mom(1)\).\(Mom(2)\)\),
                          "TraditionalForm"]}], ")"}], ",", "RelativeCF"}], 
                  "}"}], "\[Rule]", 
                \(\((Insertions(Classes))\) (
                  \({0, 0, \[ImaginaryI]\ EL, \[ImaginaryI]\ EL, 
                    \[ImaginaryI]\ EL, \(-\[ImaginaryI]\)\ dZAA1, 0, 
                    \[ImaginaryI]\ dZAA1, 1}, {0, MZ, \[ImaginaryI]\ EL, 
                    \[ImaginaryI]\ EL, 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - CW2)\)\)\/\(2\ CW\ SW
                            \)\)\), 
                    \[ImaginaryI]\ \((\(-\(dZAZ1\/2\)\) - dZZA1\/2)\), 
                    \(\[ImaginaryI]\ dZZA1\ MZ2\)\/2, 
                    \[ImaginaryI]\ \((dZAZ1\/2 + dZZA1\/2)\), 1}, {MZ, 0, 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - 1\/2)\)\)\/\(CW\ SW
                            \)\)\), \(-\(\(\[ImaginaryI]\ EL\ SW\)\/CW\)\), 
                    \[ImaginaryI]\ EL, 
                    \[ImaginaryI]\ \((\(-\(dZAZ1\/2\)\) - dZZA1\/2)\), 
                    \(\[ImaginaryI]\ dZZA1\ MZ2\)\/2, 
                    \[ImaginaryI]\ \((dZAZ1\/2 + dZZA1\/2)\), 1}, {MZ, MZ, 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - 1\/2)\)\)\/\(CW\ SW
                            \)\)\), \(-\(\(\[ImaginaryI]\ EL\ SW\)\/CW\)\), 
                    \(-\(\(\[ImaginaryI]\ EL\ \((SW2 - CW2)\)\)\/\(2\ CW\ SW
                            \)\)\), \(-\[ImaginaryI]\)\ dZZZ1, 
                    \[ImaginaryI]\ \((dMZsq1 + dZZZ1\ MZ2)\), 
                    \[ImaginaryI]\ dZZZ1, 1}\))\)}]}], ")"}]}], ")"}], 
      TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(tops\  = \ 
      CreateTopologies[1, \ 2\  -> \ 2, \n\ \ 
        ExcludeTopologies\  -> 
          \ {Tadpoles, \ WFCorrections, \ Triangles, \ AllBoxes}]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DoPaint[inss, \ "\<self\>"]; \)\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("Excluding "\[InvisibleSpace]18
          \[InvisibleSpace]" field point(s) (incl. charge conjugate ones)"\),
        SequenceForm[ 
        "Excluding ", 18, " field point(s) (incl. charge conjugate ones)"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("inserting at level(s) "\[InvisibleSpace]{Generic, Classes}\),
        SequenceForm[ "inserting at level(s) ", {Generic, Classes}],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]1
          \[InvisibleSpace]": "\[InvisibleSpace]"2 Generic, 29 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 1, ": ", "2 Generic, 29 Classes insertions"],
        
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]2
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 2, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]3
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 3, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]4
          \[InvisibleSpace]": "\[InvisibleSpace]"10 Generic, 117 Classes \
insertions"\),
        SequenceForm[ 
        "> Top. ", 4, ": ", "10 Generic, 117 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]5
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 5, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]6
          \[InvisibleSpace]": "\[InvisibleSpace]"0 Generic, 0 Classes \
insertions"\),
        SequenceForm[ "> Top. ", 6, ": ", "0 Generic, 0 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("in total: "\[InvisibleSpace]"12 Generic, 146 Classes insertions"\),
        
        SequenceForm[ "in total: ", "12 Generic, 146 Classes insertions"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    \(TraditionalForm\`""\)], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("Restoring "\[InvisibleSpace]18\[InvisibleSpace]" field point(s)"\),
        
        SequenceForm[ "Restoring ", 18, " field point(s)"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]1
          \[InvisibleSpace]": "\[InvisibleSpace]"29 diagrams"\),
        SequenceForm[ "> Top. ", 1, ": ", "29 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
    FormBox[
      InterpretationBox[
        \("> Top. "\[InvisibleSpace]2
          \[InvisibleSpace]": "\[InvisibleSpace]"117 diagrams"\),
        SequenceForm[ "> Top. ", 2, ": ", "117 diagrams"],
        Editable->False], TraditionalForm]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.325 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.0113636 0 0.0113636 [
[ 0 0 0 0 ]
[ 1 1.325 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.325 L
0 1.325 L
closepath
clip
newpath
% Start of sub-graphic
p
0 1 0.25 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C1) show
77.812500 14.625000 moveto
(N1) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 1 0.5 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C2) show
77.812500 14.625000 moveto
(N2) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 1 0.75 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C3) show
77.812500 14.625000 moveto
(N3) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 1 1 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C4) show
77.812500 14.625000 moveto
(N4) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.75 0.25 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C5) show
77.812500 14.625000 moveto
(N5) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.75 0.5 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C6) show
77.812500 14.625000 moveto
(N6) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.75 0.75 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C7) show
77.812500 14.625000 moveto
(N7) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.75 1 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C8) show
77.812500 14.625000 moveto
(N8) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.5 0.25 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -74 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C9) show
77.812500 14.625000 moveto
(N9) show
84.125000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.5 0.5 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C10) show
80.562500 14.625000 moveto
(N10) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.5 0.75 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C11) show
80.562500 14.625000 moveto
(N11) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.5 1 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C12) show
80.562500 14.625000 moveto
(N12) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.25 0.25 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C13) show
80.562500 14.625000 moveto
(N13) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.25 0.5 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C14) show
80.562500 14.625000 moveto
(N14) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.25 0.75 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C15) show
80.562500 14.625000 moveto
(N15) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.25 1 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
gsave
.5 .71342 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C16) show
80.562500 14.625000 moveto
(N16) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 0.25 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
gsave
.5 .71342 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C17) show
80.562500 14.625000 moveto
(N17) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0 0.5 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
gsave
.5 .71342 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(A) show
66.937500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C18) show
80.562500 14.625000 moveto
(N18) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0 0.75 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
gsave
.5 .71342 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C19) show
80.562500 14.625000 moveto
(N19) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0 1 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C20) show
80.562500 14.625000 moveto
(N20) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.39773 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.44886 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.5 1.295 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
63.000000 14.625000 moveto
(\\256) show
68.750000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
gsave
.55114 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.60227 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{217.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003I000182000`400?l00000o`00003of@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool000h0oooo00@000000?ooo`3o
ool000000P3oool300000080oooo00<000000?ooo`3oool00`3oool00`000000oooo000000020?oo
o`030000003oool0oooo01d0oooo00@000000?ooo`3oool000000P3oool300000080oooo00@00000
0?ooo`00000000000P3oool00`000000oooo000000020?ooo`040000003oool00000000001`0oooo
00@000000?ooo`3oool000000P3oool300000080oooo00@000000?ooo`00000000000P3oool00`00
0000oooo000000020?ooo`040000003oool00000000001`0oooo00@000000?ooo`3oool000000P3o
ool3000000040?ooo`00000000000?ooo`8000000P3oool010000000oooo0000003oool200000003
0?ooo`000000000000l0oooo000>0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000020?ooo`<000000P3oool010000000oooo0?ooo`00000L
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo0000
000000020?ooo`<000000P3oool010000000oooo00000000000L0?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000040?ooo`0000000000
00000080oooo00<000000?ooo`3oool00P00000K0?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool00P3oool01P000000oooo0000003oool000000?ooo`<000000P3oool01@000000
oooo0000003oool0000000h0oooo000>0?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool00P3oool010000000oooo0?ooo`0000020?ooo`<000000P3oool010000000oooo0?ooo`00
000L0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo
0000000000020?ooo`<000000P3oool010000000oooo00000000000L0?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool00P3oool01P000000oooo0000003oool000000?ooo`<00000
0P3oool01@000000oooo0000003oool0000001/0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`030?ooo`<000000P3oool3000000<0oooo0`00000?0?ooo`003@3oool3000000D0
oooo0P0000040?ooo`<0000000<0oooo0000003oool01@3oool3000001X0oooo0`0000050?ooo`80
00001@3oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo01T0oooo0`0000050?oo
o`8000001@3oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo01T0oooo0`000005
0?ooo`8000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00@0
00000?ooo`3oool000003`3oool000`0oooo0P00000d0?ooo`800000=03oool2000003D0oooo0P00
000X0?ooo`00303oool3000003<0oooo0`00000c0?ooo`<00000=03oool3000002L0oooo000=0?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0d0?oo
o`030000003oool0oooo02H0oooo003I0?ooo`000P3oool00`000000oooo0?ooo`0^0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo02h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0^0?ooo`030000
003oool0oooo0040oooo00030?ooo`030000003oool0oooo00h0oooo0P00000L0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool03P3oool2000001`0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0>0?ooo`800000703oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00h0oooo0P00000L0?ooo`030000003oool0oooo0080oooo00040?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`020?ooo`001@3oool20000
00h0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`070?ooo`8000003P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo00L0oooo0P00000>0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool01`3oool2000000h0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`030?ooo`001`3oool00`000000oooo0?ooo`0:0?ooo`<00000603oool2000000`0
oooo00<000000?ooo`3oool02P3oool3000001P0oooo0P00000<0?ooo`030000003oool0oooo00X0
oooo0`00000H0?ooo`800000303oool00`000000oooo0?ooo`0:0?ooo`<000006@3oool00`000000
oooo0?ooo`040?ooo`00203oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02<0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00H0oooo
00080?ooo`8000008`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?oo
o`0>0?ooo`8000008`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?oo
o`070?ooo`002@3oool2000001l0oooo0`00000C0?ooo`030000003oool0oooo01d0oooo0`00000C
0?ooo`030000003oool0oooo01d0oooo0`00000C0?ooo`030000003oool0oooo01d0oooo0`00000:
0?ooo`000P3oool2000000L0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P0000060?oo
o`030000003oool0oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?ooo`0L0?oo
o`8000003@3oool2000000H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`090?oo
o`000P3oool3000000L0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<0
00001P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00d0oooo0`0000060?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool03@3oool3000000H0oooo00<000000?ooo`3o
ool06P3oool00`000000oooo0?ooo`0;0?ooo`000`3oool00`000000oooo0?ooo`070?ooo`800000
6@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo0P00000I0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool2000001T0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`060?ooo`8000006@3oool00`000000oooo0?ooo`0<0?ooo`003`3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00d0oooo000@0?ooo`030000003oool0
oooo008000000P3oool200000080oooo0P0000020?ooo`8000000P3oool4000001l0oooo00<00000
0?ooo`3oool00P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`@000007`3oool0
0`000000oooo0?ooo`0200000080oooo0P0000020?ooo`8000000P3oool200000080oooo1000000O
0?ooo`030000003oool0oooo008000000P3oool200000080oooo0P0000020?ooo`8000000P3oool2
000000030?ooo`000000oooo00l0oooo000A0?oooa@000002P3oool00`000000oooo0?ooo`0E0?oo
oa@000002P3oool00`000000oooo0?ooo`0E0?ooo`<0000000<0oooo0000000000003P00000:0?oo
o`030000003oool0oooo01D0oooo0`0000000`3oool000000000000?000000T0oooo00<000000?oo
o`3oool01@3oool00100oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`80
00001P3oool00`000000oooo0?ooo`070?ooo`<00000503oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`<0
0000503oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`070?ooo`<00000503oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`<0
00001@3oool000h0oooo0P0000060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
103oool2000000L0oooo00<000000?ooo`0000004P3oool2000000H0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`040?ooo`8000001`3oool00`000000oooo0000000B0?ooo`800000
1P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo0P0000070?ooo`030000
003oool000000180oooo0P0000060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000D0oooo000=0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo000<0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo000:0?ooo`8000002P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool04`3oool20000
00X0oooo00<000000?ooo`3oool01P3oool2000000T0oooo00<000000?ooo`3oool04`3oool20000
00X0oooo00<000000?ooo`3oool01P3oool2000000T0oooo00<000000?ooo`3oool04`3oool20000
00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo00090?ooo`8000002`3oool00`000000oooo0?ooo`0B0?ooo`8000004P3oool2000000/0
oooo00<000000?ooo`3oool04P3oool300000140oooo0P00000;0?ooo`030000003oool0oooo0180
oooo0`00000A0?ooo`8000002`3oool00`000000oooo0?ooo`0C0?ooo`8000002@3oool000P0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`800000303oool200000100oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`800000303oool200000100oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`800000303oool200000100oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`800000303oool2000000T0oooo
00070?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103oool2000000h0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo0P00
000>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`040?ooo`8000003P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0103oool2000000h0oooo00<000000?ooo`3oool01P3oool000H0oooo00<00000
0?ooo`3oool03`3oool2000000060?ooo`00000000000000003oool000003`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00l0oooo0P0000001P3oool00000000000000000oooo0000
00l0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`80000000H0oooo0000
0000000000000?ooo`00000?0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03`3o
ool2000000060?ooo`00000000000000003oool00000403oool00`000000oooo0?ooo`040?ooo`00
103oool2000001@0oooo0P0000020?ooo`<000003`3oool2000000P0oooo0P00000D0?ooo`800000
0P3oool3000000l0oooo0P0000080?ooo`800000503oool200000080oooo0`00000?0?ooo`800000
203oool2000001<0oooo0`0000020?ooo`<00000403oool00`000000oooo0?ooo`030?ooo`000`3o
ool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;03o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0080oooo00020?ooo`030000003oool0
oooo02h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo02h0oooo00<000000?ooo`3oool00@3oool002@0oooo00<000000?ooo`3oool0<`3oool00`00
0000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0403oool002@0
oooo0`00000c0?ooo`<00000<`3oool3000003<0oooo0`00000@0?ooo`00903oool00`000000oooo
0000000c0?ooo`030000003oool0000003<0oooo00<000000?ooo`000000<`3oool00`000000oooo
0000000@0?ooo`00903oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0<`3oool00`000000oooo0?ooo`0@0?ooo`005`3oool00`000000oooo0?ooo`0c
0?ooo`800000=03oool4000003<0oooo00<000000?ooo`3oool0703oool001L0oooo0`00000c0?oo
o`030000003oool0000003<0oooo00@000000?ooo`0000000000<`3oool3000001`0oooo000G0?oo
o`040000003oool000000?ooo`800000<03oool200000080oooo0P00000`0?ooo`040000003oool0
00000?ooo`800000<@3oool00`000000oooo0000000L0?ooo`005`3oool010000000oooo0?ooo`3o
ool200000340oooo00<000000?ooo`3oool00P00000a0?ooo`80000000<0oooo000000000000<@3o
ool00`000000oooo0?ooo`0L0?ooo`006`3oool2000003@0oooo0P00000d0?ooo`800000D03oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`003P3oool010000000oooo0?ooo`0000020?ooo`<000000P3oool01000
0000oooo0000000000020?ooo`030000003oool000000080oooo00@000000?ooo`0000000000703o
ool010000000oooo0?ooo`0000020?ooo`<000000P3oool00`000000oooo0?ooo`030?ooo`030000
003oool000000080oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`0000020?ooo`<0
00000P3oool010000000oooo0000000000020?ooo`030000003oool000000080oooo00@000000?oo
o`0000000000703oool010000000oooo0?ooo`0000020?ooo`<000000P3oool010000000oooo0000
000000020?ooo`030000003oool000000080oooo00@000000?ooo`00000000003`3oool000h0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0000
0080oooo0`0000020?ooo`040000003oool0oooo000001`0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`020?ooo`040000003oool0000000000080oooo0`0000020?ooo`040000
003oool00000000001`0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080000000@0oooo00000000000000000P3oool00`000000oooo0?ooo`02
000001/0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool000000080000000@0oooo00000000000000000P3oool00`000000oooo00000002000000h0oooo
000>0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000020?ooo`<000000P3oool010000000oooo0?ooo`00000L0?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool00P3oool010000000oooo0000000000020?ooo`<000000P3o
ool010000000oooo00000000000L0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo000000030?ooo`<000000P3oool00`000000oooo0000000M0?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo000000030?oo
o`<000000P3oool00`000000oooo0000000@0?ooo`003@3oool3000000D0oooo0P0000050?ooo`04
0000003oool0oooo000000L0oooo00<000000?ooo`3oool06@3oool3000000D0oooo0P0000080?oo
o`030000003oool0oooo0240oooo0`0000050?ooo`8000001@3oool010000000oooo0?ooo`000007
0?ooo`030000003oool0oooo01T0oooo0`0000050?ooo`8000001@3oool010000000oooo0?ooo`00
00070?ooo`030000003oool0oooo00d0oooo000<0?ooo`800000=03oool2000003@0oooo0P00000e
0?ooo`800000:03oool000`0oooo0`00000c0?ooo`<00000<`3oool3000003@0oooo0`00000W0?oo
o`003@3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3o
ool0=03oool00`000000oooo0?ooo`0V0?ooo`00f@3oool00=T0oooo00020?ooo`030000003oool0
oooo00l0oooo0P00000M0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03`3oool2
000001d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`8000007@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00l0oooo0P00000M0?ooo`030000003oool0
oooo0040oooo00030?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`020?ooo`00103oool2000000l0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`060?ooo`8000003`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00H0
oooo0P00000?0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool2000000l0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`030?ooo`001P3oool00`000000oooo
0?ooo`0;0?ooo`<00000603oool2000000/0oooo00<000000?ooo`3oool02`3oool3000001P0oooo
0P00000;0?ooo`030000003oool0oooo00/0oooo0`00000H0?ooo`8000002`3oool00`000000oooo
0?ooo`0;0?ooo`<000006@3oool00`000000oooo0?ooo`040?ooo`001`3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo00H0oooo00080?ooo`8000008`3oool00`000000oooo0?ooo`0>
0?ooo`8000008`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?ooo`0>
0?ooo`8000008`3oool00`000000oooo0?ooo`070?ooo`00203oool3000001l0oooo0`00000A0?oo
o`<000007`3oool300000140oooo0`00000O0?ooo`<000004@3oool3000001l0oooo0`00000:0?oo
o`000P3oool2000000L0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P0000060?ooo`03
0000003oool0oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?ooo`0L0?ooo`80
00003@3oool2000000H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`090?ooo`00
0P3oool3000000L0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<00000
1P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00d0oooo0`0000060?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool03@3oool3000000H0oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`0;0?ooo`000`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool0303oool000h0oooo0P00000G0?ooo`030000003oool0
oooo01X0oooo0P00000G0?ooo`030000003oool0oooo01X0oooo0P00000G0?ooo`030000003oool0
oooo01X0oooo0P00000G0?ooo`030000003oool0oooo00d0oooo000@0?ooo`030000003oool0oooo
008000000P3oool200000080oooo0P0000020?ooo`8000000P3oool4000001l0oooo00<000000?oo
o`3oool00P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`@000007`3oool00`00
0000oooo0?ooo`0200000080oooo0P0000020?ooo`8000000P3oool200000080oooo1000000O0?oo
o`030000003oool0oooo008000000P3oool200000080oooo0P0000020?ooo`8000000P3oool20000
00030?ooo`000000oooo00l0oooo000A0?oooa@000008P3ooolD00000280oooo0`0000000`3oool0
00000000000>00000280oooo0`0000000`3oool000000000000?00000140oooo000@0?ooo`030000
003oool0oooo00@0oooo0P0000040?ooo`8000001P3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool0103oool2000000D0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
103oool2000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`003P3o
ool2000000H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`8000001`3o
ool300000180oooo0P0000060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103o
ool2000000L0oooo0`00000B0?ooo`8000001P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00@0oooo0P0000070?ooo`<000004P3oool2000000H0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo0`0000050?ooo`003@3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0000000A0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool000000140oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000004@3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0103oool0
0`000000oooo000000050?ooo`00303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00D0oooo000:0?ooo`8000002P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool04`3oool2000000X0oooo00<000000?ooo`3oool01P3oool2000000T0
oooo00<000000?ooo`3oool04`3oool2000000X0oooo00<000000?ooo`3oool01P3oool2000000T0
oooo00<000000?ooo`3oool04`3oool2000000X0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00090?ooo`8000002`3oool00`000000oooo
0?ooo`0B0?ooo`8000004P3oool2000000/0oooo00<000000?ooo`3oool04P3oool300000140oooo
0P00000;0?ooo`030000003oool0oooo0180oooo0`00000A0?ooo`8000002`3oool00`000000oooo
0?ooo`0C0?ooo`8000002@3oool000P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`050?ooo`800000303oool200000100oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`050?ooo`800000303oool200000100oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`040?ooo`800000303oool200000100oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00X0oooo0P0000090?ooo`001`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00@0oooo0P00000>0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`8000003P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103oool2000000h0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo0P00000>
0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00l0oooo0P0000020?oo
o`80000000<0oooo0000003oool03P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00l0oooo0P0000020?ooo`80000000<0oooo0000003oool03P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00l0oooo0P0000030?ooo`030000003oool0000000l0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`8000000`3oool00`000000oooo0000000@0?oo
o`030000003oool0oooo00@0oooo00040?ooo`8000004`3oool300000080oooo0`00000?0?ooo`80
0000203oool2000001<0oooo0`0000020?ooo`<000003`3oool2000000P0oooo0P00000C0?ooo`@0
000000@0oooo00000000000000003`3oool2000000P0oooo0P00000D0?ooo`<000000P3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo00<0oooo00030?ooo`030000003oool0oooo02`0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01P0
oooo0`00000A0?ooo`030000003oool0oooo0080oooo00020?ooo`030000003oool0oooo02h0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02h0oooo
00<000000?ooo`3oool00@3oool002@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?oo
o`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0403oool002@0oooo0`00000c
0?ooo`<00000<`3oool3000003<0oooo0`00000@0?ooo`00903oool00`000000oooo0000000c0?oo
o`030000003oool0000003<0oooo00<000000?ooo`000000<`3oool00`000000oooo0000000@0?oo
o`006`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`0@0?ooo`00603oool2000000030?ooo`000000oooo0340oooo
0P0000000`3oool000000?ooo`0a0?ooo`80000000<0oooo0000003oool0<@3oool00`000000oooo
0?ooo`0L0?ooo`00603oool400000380oooo0P0000000`3oool000000?ooo`0a0?ooo`80000000<0
oooo0000003oool0<@3oool2000001d0oooo000I0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool0=03oool00`000000oooo0?ooo`0b0?ooo`80000000<0oooo0000000000006P3oool0
0;X0oooo00<000000?ooo`3oool00P00000J0?ooo`00603oool2000003@0oooo0P00001]0?ooo`80
00006P3oool001P0oooo0P0000000`3oool000000000000a0?ooo`80000000<0oooo000000000000
<@3oool2000005<0oooo000K0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<03o
ool2000005<0oooo00270?ooo`800000D03oool008L0oooo00<000000?ooo`3oool0C`3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo000A0?ooo`040000003o
ool0oooo00000080oooo0`000000203oool000000000003oool000000?ooo`000000oooo0P00000P
0?ooo`040000003oool0oooo00000080oooo0`0000020?ooo`040000003oool0000000000080oooo
00<000000?ooo`0000000P3oool010000000oooo00000000000L0?ooo`040000003oool0oooo0000
0080oooo0`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool0
10000000oooo0?ooo`00000L0?ooo`040000003oool0oooo00000080oooo0`0000020?ooo`040000
003oool0000000000080oooo00<000000?ooo`0000000P3oool010000000oooo00000000000?0?oo
o`004@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo1@0000020?oo
o`8000007`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00H00000
0?ooo`000000oooo0000003oool300000080oooo00D000000?ooo`000000oooo0000000K0?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000002
0?ooo`<000000P3oool010000000oooo0?ooo`00000L0?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`<000000P3oool010000000
oooo0?ooo`00000?0?ooo`004@3oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo
0?ooo`000000oooo10000000103oool000000?ooo`00000O0?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool00P3oool010000000oooo0000000000020?ooo`<000000P3oool01000
0000oooo00000000000L0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000020?ooo`<000000P3oool010000000oooo0?ooo`00000L0?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`3oool0
00000?ooo`<000000P3oool01@000000oooo0?ooo`3oool0000000h0oooo000@0?ooo`<000001@3o
ool200000080oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`0M0?ooo`<000001@3o
ool2000000D0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`0I0?ooo`<00000
1@3oool2000000P0oooo00<000000?ooo`3oool08@3oool3000000D0oooo0P0000050?ooo`040000
003oool0oooo000000L0oooo00<000000?ooo`3oool03@3oool000`0oooo0P00000d0?ooo`800000
=03oool2000003D0oooo0P00000X0?ooo`00303oool3000003<0oooo0`00000c0?ooo`<00000=03o
ool3000002L0oooo000=0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool0
0`000000oooo0?ooo`0d0?ooo`030000003oool0oooo02H0oooo003I0?ooo`00503oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo08`0oooo00020?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00l0oooo
0P00000M0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03`3oool2000001d0oooo
00<000000?ooo`3oool00@3oool000<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0000
000L0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0000
000L0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo0080oooo00040?ooo`8000003P3oool3000001X0oooo00<00000
0?ooo`3oool01P3oool2000000h0oooo0`00000J0?ooo`030000003oool0oooo00H0oooo0P00000?
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool2000000l0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`030?ooo`001P3oool00`000000oooo0?ooo`0V0?oo
o`8000002`3oool00`000000oooo0?ooo`0V0?ooo`8000002`3oool00`000000oooo0?ooo`0;0?oo
o`<00000603oool2000000/0oooo00<000000?ooo`3oool02`3oool3000001T0oooo00<000000?oo
o`3oool0103oool000L0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0T0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`060?ooo`00
203oool2000002<0oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?ooo`3oool0
3P3oool2000002<0oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?ooo`3oool0
1`3oool000P0oooo0`00000O0?ooo`<000004@3oool3000001l0oooo0`00000A0?ooo`<000007`3o
ool300000140oooo0`00000O0?ooo`<000002P3oool00080oooo0P0000070?ooo`030000003oool0
oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?ooo`0L0?ooo`8000003@3oool2
000000H0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P0000060?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool02@3oool00080oooo0`0000070?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool03@3oool3000000H0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0=0?ooo`<000001P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool02`3oool000<0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00`0
oooo000>0?ooo`8000005`3oool00`000000oooo0?ooo`0J0?ooo`8000005`3oool00`000000oooo
0?ooo`0J0?ooo`8000005`3oool00`000000oooo0?ooo`0J0?ooo`8000005`3oool00`000000oooo
0?ooo`0=0?ooo`00403oool00`000000oooo0?ooo`0200000080oooo0P0000020?ooo`8000000P3o
ool200000080oooo1000000O0?ooo`030000003oool0oooo008000000P3oool200000080oooo0P00
00020?ooo`8000000P3oool4000001l0oooo00<000000?ooo`3oool00P0000020?ooo`8000000P3o
ool200000080oooo0P0000020?ooo`@000007`3oool00`000000oooo0?ooo`0200000080oooo0P00
00020?ooo`8000000P3oool200000080oooo0P0000000`3oool000000?ooo`0?0?ooo`004@3ooolD
00000280oooo5000000R0?ooo`<0000000<0oooo0000000000003P00000R0?ooo`<0000000D0oooo
00000000000000000?ooo`0=00000140oooo000@0?ooo`030000003oool0000000<0oooo00D00000
0?ooo`000000oooo000000020?ooo`8000000P3oool01@000000oooo0?ooo`3oool0000000T0oooo
00<000000?ooo`3oool0503oool00`000000oooo000000030?ooo`050000003oool000000?ooo`00
00000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0503oool00`000000oooo000000030?ooo`050000003oool000000?ooo`0000000`3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0D0?ooo`030000003oool0000000<0oooo00D000000?ooo`000000oooo000000030?ooo`050000
003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0
oooo000>0?ooo`8000001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo
0P0000070?ooo`<000004P3oool2000000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`040?ooo`8000001`3oool300000180oooo0P0000070?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0103oool2000000L0oooo0`00000B0?ooo`8000001`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool3000000D0oooo
000=0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`040?ooo`030000003oool000000140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000004@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0103oool00`000000oooo0000
000A0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0000000D0oooo000<0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool01@3oool000X0oooo0P00000:0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0C0?ooo`8000002P3oool00`000000oooo0?ooo`060?oo
o`8000002@3oool00`000000oooo0?ooo`0C0?ooo`8000002P3oool00`000000oooo0?ooo`060?oo
o`8000002@3oool00`000000oooo0?ooo`0C0?ooo`8000002P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool000T0oooo0P00000;0?ooo`03
0000003oool0oooo0180oooo0P00000B0?ooo`8000002`3oool00`000000oooo0?ooo`0B0?ooo`<0
00004@3oool2000000/0oooo00<000000?ooo`3oool04P3oool300000140oooo0P00000;0?ooo`03
0000003oool0oooo01<0oooo0P0000090?ooo`00203oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool200000100oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo0P00000@0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0103oool2000000`0oooo0P00000@0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0103oool2000000`0oooo0P0000090?ooo`001`3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo0P00000>0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`8000003P3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103o
ool2000000h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00@0oooo0P00000>0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0
oooo00l0oooo0P0000020?ooo`80000000<0oooo0000003oool03P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00l0oooo0P0000020?ooo`80000000<0oooo0000003oool03P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00l0oooo0P0000030?ooo`030000003oool0
000000l0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`8000000`3oool0
0`000000oooo0000000@0?ooo`030000003oool0oooo00@0oooo00040?ooo`8000004`3oool30000
00<0oooo00<000000?ooo`3oool03P3oool2000000P0oooo0P00000C0?ooo`<000000`3oool00`00
0000oooo0?ooo`0>0?ooo`800000203oool2000001<0oooo10000000103oool0000000000000000?
0?ooo`800000203oool2000001<0oooo10000000103oool0000000000000000@0?ooo`030000003o
ool0oooo00<0oooo00030?ooo`030000003oool0oooo01P0oooo0`00000A0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0603oool300000140oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;03oool0
0`000000oooo0?ooo`020?ooo`000P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
02h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
0040oooo000T0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo0100oooo000T0?ooo`<00000<`3oool3000003<0oooo
0`00000c0?ooo`<00000403oool002@0oooo00<000000?ooo`000000<`3oool00`000000oooo0000
000c0?ooo`030000003oool0000003<0oooo00<000000?ooo`000000403oool001/0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0100oooo000H0?oo
o`80000000<0oooo0000003oool0<@3oool2000000030?ooo`000000oooo0340oooo00<000000?oo
o`3oool0<`3oool4000001/0oooo000H0?ooo`80000000<0oooo0000003oool0<@3oool200000003
0?ooo`000000oooo0340oooo0`00000c0?ooo`040000003oool00000000001/0oooo000H0?ooo`03
0000003oool0oooo03@0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0000000c0?ooo`03
0000003oool0000001`0oooo00240?ooo`030000003oool0oooo03@0oooo0P00000L0?ooo`00603o
ool200000;l0oooo000H0?ooo`80000000<0oooo000000000000<@3oool2000008T0oooo000K0?oo
o`030000003oool0oooo0300oooo0P0000290?ooo`00D@3oool2000008H0oooo001A0?ooo`030000
003oool0oooo08D0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`00f@3oool00140oooo00@000000?ooo`3oool000000P3oool3000000080?ooo`0000000000
0?ooo`000000oooo0000003oool2000002<0oooo00@000000?ooo`3oool000000P3oool300000008
0?ooo`00000000000?ooo`000000oooo0000003oool2000002<0oooo00@000000?ooo`3oool00000
0P3oool3000000@0oooo00<000000?ooo`0000009P3oool010000000oooo0?ooo`0000020?ooo`<0
000000<0oooo0000000000000P3oool010000000oooo0000003oool200000180oooo000A0?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool500000080oooo0P00000R0?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool0oooo1P000000103oool000000000
0000000R0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000
oooo0000000200000080oooo00<000000?ooo`3oool08@3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo0?ooo`8000000P3oool3000000030?ooo`00000000000180oooo000A0?oo
o`040000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`<0000000<0
oooo0000003oool08`3oool010000000oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool3000000030?ooo`000000oooo02<0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool00000008000000P3oool00`000000oooo0?ooo`0Q0?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool0oooo0P0000020?ooo`<0000000<0
oooo0000000000004P3oool000`0oooo0P0000020?ooo`<000001@3oool200000080oooo00<00000
0?ooo`000000103oool00`000000oooo0?ooo`0L0?ooo`8000000P3oool3000000D0oooo0P000002
0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0703oool200000080oooo0`000005
0?ooo`80000000<0oooo0000000000000P0000030?ooo`<000007@3oool200000080oooo0`000005
0?ooo`8000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0100oooo000<
0?ooo`<00000<`3oool3000003<0oooo0`00000c0?ooo`<00000:03oool000d0oooo00<000000?oo
o`3oool0<`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?oo
o`3oool09`3oool00=T0oooo000D0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0
<`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0200oooo00020?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`010?ooo`000`3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0000001`0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0000001`0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0000001`0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0000001`0oooo00<000000?ooo`3oool00P3oool0
00@0oooo0P00000>0?ooo`<000006P3oool00`000000oooo0?ooo`060?ooo`8000003P3oool30000
01X0oooo00<000000?ooo`3oool01P3oool2000000h0oooo0`00000J0?ooo`030000003oool0oooo
00H0oooo0P00000>0?ooo`<000006P3oool00`000000oooo0?ooo`030?ooo`001P3oool00`000000
oooo0?ooo`0V0?ooo`8000002`3oool00`000000oooo0?ooo`0V0?ooo`8000002`3oool00`000000
oooo0?ooo`0V0?ooo`8000002`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00@0
oooo00070?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool01P3oool000P0oooo0P00
000S0?ooo`030000003oool0oooo00h0oooo0P00000S0?ooo`030000003oool0oooo00h0oooo0P00
000S0?ooo`030000003oool0oooo00h0oooo0P00000S0?ooo`030000003oool0oooo00L0oooo0008
0?ooo`<000007`3oool300000140oooo0`00000O0?ooo`<000004@3oool3000001l0oooo0`00000A
0?ooo`<000007`3oool3000000X0oooo00020?ooo`8000001`3oool00`000000oooo0?ooo`0L0?oo
o`8000003@3oool2000000H0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P0000060?oo
o`030000003oool0oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo00T0oooo00020?ooo`<000001`3oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool03@3oool3000000H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<0
00001P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00/0oooo00030?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0<0?ooo`003P3o
ool2000001L0oooo00<000000?ooo`3oool06P3oool2000001L0oooo00<000000?ooo`3oool06P3o
ool2000001L0oooo00<000000?ooo`3oool06P3oool2000001L0oooo00<000000?ooo`3oool03@3o
ool00100oooo00<000000?ooo`3oool00P0000020?ooo`8000000P3oool200000080oooo0P000002
0?ooo`@000007`3oool00`000000oooo0?ooo`0200000080oooo0P0000020?ooo`8000000P3oool2
00000080oooo1000000O0?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo0P00
00020?ooo`8000000P3oool4000001l0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo008000000P3oool200000080oooo0P0000000`3oool000000?ooo`0?0?ooo`004@3o
oolD00000280oooo5000000R0?oooa@000008P3ooolE00000140oooo000@0?ooo`<000000P3oool2
000000040?ooo`000000000000000080oooo0P0000020?ooo`8000000P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo01@0oooo00<000000?ooo`0000000P3oool2000000040?ooo`00
0000000000000080oooo0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`0000000P3oool2000000040?ooo`000000000000000080
oooo0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`0000000`3oool01@000000oooo0000003oool000000080oooo0P0000020?oo
o`8000000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo000>0?ooo`80
00001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo0P0000070?ooo`<0
00004P3oool2000000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`80
00001`3oool300000180oooo0P0000070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0103oool2000000L0oooo0`00000B0?ooo`8000001`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool3000000D0oooo000=0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`030000
003oool000000140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`0000004@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0000000D0oooo000<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo000:0?ooo`8000002P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool04`3oool2
000000X0oooo00<000000?ooo`3oool01P3oool2000000T0oooo00<000000?ooo`3oool04`3oool2
000000X0oooo00<000000?ooo`3oool01P3oool2000000T0oooo00<000000?ooo`3oool04`3oool2
000000X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00090?ooo`8000002`3oool00`000000oooo0?ooo`0B0?ooo`8000004P3oool20000
00/0oooo00<000000?ooo`3oool04P3oool300000140oooo0P00000;0?ooo`030000003oool0oooo
0180oooo0`00000A0?ooo`8000002`3oool00`000000oooo0?ooo`0C0?ooo`8000002@3oool000P0
oooo00<000000?ooo`3oool04`3oool2000000`0oooo0P00000@0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool02P3oool200000100oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0:0?ooo`800000403oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00X0
oooo0P0000090?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`8000001P3oool2000000h0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo
0P00000>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`040?ooo`8000003P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0103oool2000000h0oooo00<000000?ooo`3oool01P3oool000H0oooo00<0
00000?ooo`3oool03`3oool010000000oooo0?ooo`3oool2000000030?ooo`000000oooo00h0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo0?ooo`80
000000<0oooo0000003oool03P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0000000?0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`030000003oool000000100
oooo00<000000?ooo`3oool0103oool000@0oooo0P00000C0?ooo`<000000P3oool3000000l0oooo
0P0000080?ooo`8000004`3oool3000000<0oooo00<000000?ooo`3oool03P3oool2000000P0oooo
0P00000C0?ooo`@000000P3oool00`000000oooo0?ooo`0>0?ooo`800000203oool2000001<0oooo
100000020?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool00`3oool000<0oooo00<0
00000?ooo`3oool0;03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01P0oooo0`00
000A0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603oool300000140oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`<000004@3oool00`000000oooo0?oo
o`020?ooo`000P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0;P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02h0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0040oooo000T0?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?oo
o`030000003oool0oooo0100oooo000T0?ooo`<00000<`3oool3000003<0oooo0`00000c0?ooo`<0
0000403oool002@0oooo00<000000?ooo`000000<`3oool00`000000oooo0000000c0?ooo`030000
003oool0000003<0oooo00<000000?ooo`000000403oool001/0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0:P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0100oooo000K0?ooo`030000003oool0
oooo09l0oooo00<000000?ooo`3oool06@3oool001P0oooo0P0000000`3oool000000?ooo`0a0?oo
o`030000003oool0oooo03<0oooo1000000b0?ooo`80000000<0oooo0000003oool06P3oool001P0
oooo0P00000d0?ooo`<00000<`3oool010000000oooo00000000000b0?ooo`<00000703oool001T0
oooo00<000000?ooo`3oool0<P3oool00`000000oooo0000000c0?ooo`030000003oool0000003@0
oooo00<000000?ooo`3oool06`3oool004h0oooo00<000000?ooo`3oool0=03oool2000003<0oooo
0P00000M0?ooo`00603oool200000:00oooo0P00000M0?ooo`00603oool200000:<0oooo0P00000J
0?ooo`006`3oool200000:00oooo00<000000?ooo`3oool06@3oool001/0oooo00<000000?ooo`3o
ool0^`3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I
0?ooo`004@3oool010000000oooo0?ooo`0000020?ooo`<000000P3oool01@000000oooo0000003o
ool000000080oooo00<000000?ooo`3oool08@3oool010000000oooo0?ooo`0000020?ooo`<00000
00P0oooo000000000000oooo0000003oool000000?ooo`8000008`3oool010000000oooo0?ooo`00
00020?ooo`<0000000P0oooo000000000000oooo0000003oool000000?ooo`8000008`3oool01000
0000oooo0?ooo`0000020?ooo`<000001@3oool00`000000oooo0000000E0?ooo`004@3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P000002
0?ooo`030000003oool0oooo0240oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`020?ooo`030000003oool00000008000000P3oool00`000000oooo0?ooo`0Q0?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0000000200000080oooo
00<000000?ooo`3oool08@3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0?oo
o`8000000P3oool3000000030?ooo`00000000000180oooo000A0?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0000000200000080oooo00<000000?oo
o`3oool08@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo10000003
0?ooo`030000003oool0oooo0200oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`020?ooo`030000003oool00000008000000P3oool00`000000oooo0?ooo`0Q0?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool0oooo0P0000020?ooo`<0000000<0oooo00000000
00004P3oool000`0oooo0P0000020?ooo`<000001@3oool2000000@0oooo00<000000?ooo`3oool0
8@3oool200000080oooo0`0000050?ooo`8000000P3oool00`000000oooo000000040?ooo`030000
003oool0oooo01`0oooo0P0000020?ooo`<000001@3oool200000080oooo00<000000?ooo`000000
103oool00`000000oooo0?ooo`0M0?ooo`80000000@0oooo00000000000000001@3oool2000000D0
oooo00<000000?ooo`3oool05@3oool000`0oooo0`00000c0?ooo`<00000<`3oool3000003@0oooo
0`00000W0?ooo`003@3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0=03oool00`000000oooo0?ooo`0V0?ooo`00f@3oool001@0oooo00<000000?oo
o`3oool0<`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?oo
o`3oool0803oool00080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0040oooo00030?ooo`030000003oool0oooo00d0oooo00<000000?ooo`000000
703oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo00<000000?ooo`000000
703oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo00<000000?ooo`000000
703oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo00<000000?ooo`000000
703oool00`000000oooo0?ooo`020?ooo`00103oool2000000h0oooo0`00000J0?ooo`030000003o
ool0oooo00H0oooo0P00000>0?ooo`<000006P3oool00`000000oooo0?ooo`060?ooo`8000003P3o
ool3000001X0oooo00<000000?ooo`3oool01P3oool2000000h0oooo0`00000J0?ooo`030000003o
ool0oooo00<0oooo00060?ooo`030000003oool0oooo02H0oooo0P00000;0?ooo`030000003oool0
oooo02H0oooo0P00000;0?ooo`030000003oool0oooo02H0oooo0P00000;0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0103oool000L0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`060?ooo`00203oool2000002<0oooo00<000000?ooo`3oool03P3oool2000002<0
oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?ooo`3oool03P3oool2000002<0
oooo00<000000?ooo`3oool01`3oool000P0oooo0`00000O0?ooo`<000004@3oool3000001l0oooo
0`00000A0?ooo`<000007`3oool300000140oooo0`00000O0?ooo`<000002P3oool00080oooo0P00
00070?ooo`030000003oool0oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?oo
o`0L0?ooo`8000003@3oool2000000H0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P00
00060?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02@3oool00080oooo0`000007
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03@3oool3000000H0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<000001P3oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool02`3oool000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo00`0oooo000>0?ooo`8000005`3oool00`000000oooo0?ooo`0J0?ooo`80
00005`3oool00`000000oooo0?ooo`0J0?ooo`8000005`3oool00`000000oooo0?ooo`0J0?ooo`80
00005`3oool00`000000oooo0?ooo`0=0?ooo`00403oool01@000000oooo0?ooo`3oool0000000<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0oooo0?ooo`000000oooo0P00
000O0?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0
oooo00D000000?ooo`3oool000000?ooo`02000001l0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`3oool3000001l0oooo
00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01`00
0000oooo0?ooo`3oool000000?ooo`000000403oool00140oooo5000000R0?oooa@000008P3oool0
0`000000oooo0000000A00000280oooo00<000000?ooo`0000000P0000000`3oool000000000000=
00000140oooo000@0?ooo`<000000P3oool2000000040?ooo`000000000000000080oooo0P000002
0?ooo`8000000P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo0`000002
0?ooo`80000000@0oooo00000000000000000P3oool200000080oooo0P0000020?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0503oool300000080oooo0P000000103oool000000000
000000020?ooo`8000000P3oool200000080oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0D0?ooo`<000000P3oool2000000040?ooo`000000000000000080oooo0P0000020?ooo`80
00000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo000>0?ooo`800000
1`3oool00`000000oooo0?ooo`040?ooo`8000001P3oool2000000L0oooo0`00000B0?ooo`800000
1`3oool00`000000oooo0?ooo`040?ooo`8000001P3oool2000000L0oooo0`00000B0?ooo`800000
1`3oool00`000000oooo0?ooo`040?ooo`8000001P3oool2000000L0oooo0`00000B0?ooo`800000
1`3oool00`000000oooo0?ooo`040?ooo`8000001`3oool00`000000oooo0?ooo`050?ooo`<00000
1@3oool000d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`0000004@3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool000000140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`0000001@3oool000`0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool0
00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00H0oooo0P0000090?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`060?ooo`8000002@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo00090?ooo`8000002`3oool00`000000oooo0?ooo`0B0?ooo`8000004P3oool2000000/0
oooo00<000000?ooo`3oool04P3oool300000140oooo0P00000;0?ooo`030000003oool0oooo0180
oooo0`00000A0?ooo`8000002`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0
oooo0P0000090?ooo`00203oool00`000000oooo0?ooo`0C0?ooo`800000303oool200000100oooo
00<000000?ooo`3oool04`3oool2000000`0oooo0P00000@0?ooo`030000003oool0oooo01<0oooo
0P00000<0?ooo`800000403oool00`000000oooo0?ooo`0C0?ooo`800000303oool2000000T0oooo
00070?ooo`030000003oool0oooo00`0oooo0P0000060?ooo`8000003P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00`0oooo0P0000060?ooo`8000003P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103oool2000000h0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo0P00
000>0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0000000?0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000l0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`0000003`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0000000@0?ooo`030000003oool0oooo00@0oooo00040?oo
o`8000004`3oool4000000040?ooo`0000000000000000l0oooo0P0000080?ooo`8000004`3oool4
000000040?ooo`0000000000000000l0oooo0P0000080?ooo`8000004`3oool8000000l0oooo0P00
00080?ooo`8000004`3oool800000100oooo00<000000?ooo`3oool00`3oool000<0oooo00<00000
0?ooo`3oool0;03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02`0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0;03oool00`000000oooo0?ooo`020?ooo`000P3oool00`000000oooo0?ooo`0^0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0^0?oo
o`030000003oool0oooo0040oooo000T0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0100oooo000T0?ooo`<00000
<`3oool3000003<0oooo0`00000c0?ooo`<00000403oool002@0oooo00<000000?ooo`000000<`3o
ool00`000000oooo0000000c0?ooo`030000003oool0000003<0oooo00<000000?ooo`000000403o
ool002@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo0100oooo00270?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool06@3oool001P0
oooo00<000000?ooo`3oool0<`3oool400000380oooo0P0000000`3oool000000?ooo`0a0?ooo`80
000000<0oooo0000003oool06P3oool001P0oooo0`00000c0?ooo`040000003oool0000000000380
oooo0`00000c0?ooo`8000007@3oool001P0oooo00<000000?ooo`000000<`3oool00`000000oooo
0000000d0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0703oool001P0oooo00<0
00000?ooo`3oool0=03oool2000003<0oooo0P00000d0?ooo`8000007@3oool008@0oooo0P00000d
0?ooo`8000007@3oool008L0oooo0P00000d0?ooo`8000006P3oool008L0oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`0I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool005@0oooo0`0000080?ooo`<00000
2`3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3o
ool00000EP3oool005@0oooo0`0000080?ooo`<00000203oool5000000D0oooo00@000000?ooo`3o
ool000001`3oool010000000oooo0?ooo`00001F0?ooo`00E03oool3000000P0oooo0`00000;0?oo
o`030000003oool0oooo00@0oooo100000070?ooo`@00000EP3oool007@0oooo00@000000?ooo`3o
ool000001`3oool010000000oooo0?ooo`00001F0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo0000\
\>"],
  ImageRangeCache->{{{0, 216.313}, {287, 0}} -> {-0.000440006, -0.0790874, 
  0.406824, 0.406824}, {{0, 54.0625}, {70.4375, 16.375}} -> {-1.00011,
   -89.1283, 0.406941, 0.406941}, {{54.0625, 108.125}, {70.4375, 16.375}} ->
   {-23.0004, -89.1283, 0.406941, 0.406941}, {{108.125, 162.188}, {70.4375, 
  16.375}} -> {-45.0006, -89.1283, 0.406941, 0.406941}, {{162.188, 216.313}, {
  70.4375, 16.375}} -> {-67.0136, -89.1283, 0.406941, 0.406941}, {{0, 
  54.0625}, {124.563, 70.4375}} -> {-1.00011, -67.1153, 0.406941, 0.406941},
   {{54.0625, 108.125}, {124.563, 70.4375}} -> {-23.0004, -67.1153, 0.406941, 
  0.406941}, {{108.125, 162.188}, {124.563, 70.4375}} -> {-45.0006, -67.1153, 
  0.406941, 0.406941}, {{162.188, 216.313}, {124.563, 70.4375}} -> {-66.9246,
   -67.0262, 0.406471, 0.406471}, {{0, 54.0625}, {178.625, 124.563}} ->
   {-1.00011, -45.1023, 0.406941, 0.406941}, {{54.0625, 108.125}, {178.625, 
  124.563}} -> {-23.0004, -45.1023, 0.406941, 0.406941}, {{108.125, 162.188},
   {178.625, 124.563}} -> {-45.0006, -45.1023, 0.406941, 0.406941}, {{162.188,
   216.313}, {178.625, 124.563}} -> {-67.0136, -45.1023, 0.406941, 0.406941},
   {{0, 54.0625}, {232.688, 178.625}} -> {-1.00011, -23.1021, 0.406941, 
  0.406941}, {{54.0625, 108.125}, {232.688, 178.625}} -> {-23.0004, -23.1021, 
  0.406941, 0.406941}, {{108.125, 162.188}, {232.688, 178.625}} -> {-45.0006,
   -23.1021, 0.406941, 0.406941}, {{162.188, 216.313}, {232.688, 178.625}} ->
   {-67.0136, -23.1021, 0.406941, 0.406941}, {{0, 54.0625}, {286.75, 232.688}}
   -> {-1.00011, -1.10185, 0.406941, 0.406941}, {{54.0625, 108.125}, {286.75, 
  232.688}} -> {-23.0004, -1.10185, 0.406941, 0.406941}, {{108.125, 162.188},
   {286.75, 232.688}} -> {-45.0006, -1.10185, 0.406941, 0.406941}, {{162.188, 
  216.313}, {286.75, 232.688}} -> {-67.0136, -1.10185, 0.406941, 0.406941}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.325 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.0113636 0 0.0113636 [
[ 0 0 0 0 ]
[ 1 1.325 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.325 L
0 1.325 L
closepath
clip
newpath
% Start of sub-graphic
p
0 1 0.25 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C21) show
80.562500 14.625000 moveto
(N21) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 1 0.5 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(n) show
63.125000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
65.750000 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C22) show
80.562500 14.625000 moveto
(N22) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 1 0.75 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C23) show
80.562500 14.625000 moveto
(N23) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 1 1 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C24) show
80.562500 14.625000 moveto
(N24) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.75 0.25 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
newpath
.5 .59091 .09091 270 630 arc
s
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C25) show
80.562500 14.625000 moveto
(N25) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.75 0.5 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.49562 .50376 L
.49157 .50733 L
.48776 .51036 L
.48404 .51258 L
.48021 .51384 L
.47612 .51414 L
.47162 .51362 L
.46666 .51252 L
.46125 .51119 L
.45552 .51 L
.44965 .50932 L
.4439 .50947 L
.43856 .51066 L
.43389 .51301 L
.43013 .5165 L
.42739 .52099 L
.42572 .52625 L
.42502 .53199 L
.42509 .53791 L
.42563 .54371 L
.4263 .54918 L
.42673 .55415 L
.4266 .5586 L
.42568 .56256 L
.42382 .56616 L
.42103 .56957 L
.41746 .573 L
.41336 .57663 L
.4091 .58058 L
.4051 .58494 L
.40175 .58967 L
.39942 .5947 L
.39838 .59987 L
.39877 .60499 L
.4006 .60987 L
.40372 .61434 L
.40786 .61831 L
.41266 .62173 L
.41774 .62468 L
.4227 .62729 L
.42719 .62976 L
.43096 .63233 L
.43389 .63523 L
.43598 .63866 L
.43735 .64274 L
.43821 .64749 L
.43887 .65281 L
.43964 .65851 L
.44082 .66431 L
Mistroke
.44264 .66986 L
.44526 .67482 L
.44873 .67886 L
.453 .68173 L
.45793 .68331 L
.46331 .68358 L
.46891 .68266 L
.47449 .68082 L
.47987 .67839 L
.48491 .67578 L
.48958 .67338 L
.49391 .67156 L
.498 .67058 L
.502 .67058 L
.50609 .67156 L
.51042 .67338 L
.51509 .67578 L
.52013 .67839 L
.52551 .68082 L
.53109 .68266 L
.53669 .68358 L
.54207 .68331 L
.547 .68173 L
.55127 .67886 L
.55474 .67482 L
.55736 .66986 L
.55918 .66431 L
.56036 .65851 L
.56113 .65281 L
.56179 .64749 L
.56265 .64274 L
.56402 .63866 L
.56611 .63523 L
.56904 .63233 L
.57281 .62976 L
.5773 .62729 L
.58226 .62468 L
.58734 .62173 L
.59214 .61831 L
.59628 .61434 L
.5994 .60987 L
.60122 .60499 L
.60162 .59987 L
.60058 .5947 L
.59825 .58967 L
.5949 .58494 L
.5909 .58058 L
.58664 .57663 L
.58254 .573 L
.57897 .56957 L
Mistroke
.57618 .56616 L
.57432 .56256 L
.5734 .5586 L
.57327 .55415 L
.57371 .54917 L
.57437 .54371 L
.57491 .53791 L
.57498 .53199 L
.57428 .52625 L
.5726 .52099 L
.56987 .5165 L
.56611 .51302 L
.56144 .51066 L
.5561 .50947 L
.55035 .50932 L
.54448 .51 L
.53875 .51119 L
.53334 .51252 L
.52838 .51361 L
.52388 .51414 L
.51979 .51384 L
.51596 .51258 L
.51224 .51036 L
.50843 .50733 L
.50438 .50376 L
.5 .5 L
Mfstroke
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(W) show
69.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C1) show
77.812500 14.625000 moveto
(N26) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.75 0.75 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.49562 .50376 L
.49157 .50733 L
.48776 .51036 L
.48404 .51258 L
.48021 .51384 L
.47612 .51414 L
.47162 .51362 L
.46666 .51252 L
.46125 .51119 L
.45552 .51 L
.44965 .50932 L
.4439 .50947 L
.43856 .51066 L
.43389 .51301 L
.43013 .5165 L
.42739 .52099 L
.42572 .52625 L
.42502 .53199 L
.42509 .53791 L
.42563 .54371 L
.4263 .54918 L
.42673 .55415 L
.4266 .5586 L
.42568 .56256 L
.42382 .56616 L
.42103 .56957 L
.41746 .573 L
.41336 .57663 L
.4091 .58058 L
.4051 .58494 L
.40175 .58967 L
.39942 .5947 L
.39838 .59987 L
.39877 .60499 L
.4006 .60987 L
.40372 .61434 L
.40786 .61831 L
.41266 .62173 L
.41774 .62468 L
.4227 .62729 L
.42719 .62976 L
.43096 .63233 L
.43389 .63523 L
.43598 .63866 L
.43735 .64274 L
.43821 .64749 L
.43887 .65281 L
.43964 .65851 L
.44082 .66431 L
Mistroke
.44264 .66986 L
.44526 .67482 L
.44873 .67886 L
.453 .68173 L
.45793 .68331 L
.46331 .68358 L
.46891 .68266 L
.47449 .68082 L
.47987 .67839 L
.48491 .67578 L
.48958 .67338 L
.49391 .67156 L
.498 .67058 L
.502 .67058 L
.50609 .67156 L
.51042 .67338 L
.51509 .67578 L
.52013 .67839 L
.52551 .68082 L
.53109 .68266 L
.53669 .68358 L
.54207 .68331 L
.547 .68173 L
.55127 .67886 L
.55474 .67482 L
.55736 .66986 L
.55918 .66431 L
.56036 .65851 L
.56113 .65281 L
.56179 .64749 L
.56265 .64274 L
.56402 .63866 L
.56611 .63523 L
.56904 .63233 L
.57281 .62976 L
.5773 .62729 L
.58226 .62468 L
.58734 .62173 L
.59214 .61831 L
.59628 .61434 L
.5994 .60987 L
.60122 .60499 L
.60162 .59987 L
.60058 .5947 L
.59825 .58967 L
.5949 .58494 L
.5909 .58058 L
.58664 .57663 L
.58254 .573 L
.57897 .56957 L
Mistroke
.57618 .56616 L
.57432 .56256 L
.5734 .5586 L
.57327 .55415 L
.57371 .54917 L
.57437 .54371 L
.57491 .53791 L
.57498 .53199 L
.57428 .52625 L
.5726 .52099 L
.56987 .5165 L
.56611 .51302 L
.56144 .51066 L
.5561 .50947 L
.55035 .50932 L
.54448 .51 L
.53875 .51119 L
.53334 .51252 L
.52838 .51361 L
.52388 .51414 L
.51979 .51384 L
.51596 .51258 L
.51224 .51036 L
.50843 .50733 L
.50438 .50376 L
.5 .5 L
Mfstroke
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(W) show
69.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C2) show
77.812500 14.625000 moveto
(N27) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.75 1 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.5 .5 m
.49562 .50376 L
.49157 .50733 L
.48776 .51036 L
.48404 .51258 L
.48021 .51384 L
.47612 .51414 L
.47162 .51362 L
.46666 .51252 L
.46125 .51119 L
.45552 .51 L
.44965 .50932 L
.4439 .50947 L
.43856 .51066 L
.43389 .51301 L
.43013 .5165 L
.42739 .52099 L
.42572 .52625 L
.42502 .53199 L
.42509 .53791 L
.42563 .54371 L
.4263 .54918 L
.42673 .55415 L
.4266 .5586 L
.42568 .56256 L
.42382 .56616 L
.42103 .56957 L
.41746 .573 L
.41336 .57663 L
.4091 .58058 L
.4051 .58494 L
.40175 .58967 L
.39942 .5947 L
.39838 .59987 L
.39877 .60499 L
.4006 .60987 L
.40372 .61434 L
.40786 .61831 L
.41266 .62173 L
.41774 .62468 L
.4227 .62729 L
.42719 .62976 L
.43096 .63233 L
.43389 .63523 L
.43598 .63866 L
.43735 .64274 L
.43821 .64749 L
.43887 .65281 L
.43964 .65851 L
.44082 .66431 L
Mistroke
.44264 .66986 L
.44526 .67482 L
.44873 .67886 L
.453 .68173 L
.45793 .68331 L
.46331 .68358 L
.46891 .68266 L
.47449 .68082 L
.47987 .67839 L
.48491 .67578 L
.48958 .67338 L
.49391 .67156 L
.498 .67058 L
.502 .67058 L
.50609 .67156 L
.51042 .67338 L
.51509 .67578 L
.52013 .67839 L
.52551 .68082 L
.53109 .68266 L
.53669 .68358 L
.54207 .68331 L
.547 .68173 L
.55127 .67886 L
.55474 .67482 L
.55736 .66986 L
.55918 .66431 L
.56036 .65851 L
.56113 .65281 L
.56179 .64749 L
.56265 .64274 L
.56402 .63866 L
.56611 .63523 L
.56904 .63233 L
.57281 .62976 L
.5773 .62729 L
.58226 .62468 L
.58734 .62173 L
.59214 .61831 L
.59628 .61434 L
.5994 .60987 L
.60122 .60499 L
.60162 .59987 L
.60058 .5947 L
.59825 .58967 L
.5949 .58494 L
.5909 .58058 L
.58664 .57663 L
.58254 .573 L
.57897 .56957 L
Mistroke
.57618 .56616 L
.57432 .56256 L
.5734 .5586 L
.57327 .55415 L
.57371 .54917 L
.57437 .54371 L
.57491 .53791 L
.57498 .53199 L
.57428 .52625 L
.5726 .52099 L
.56987 .5165 L
.56611 .51302 L
.56144 .51066 L
.5561 .50947 L
.55035 .50932 L
.54448 .51 L
.53875 .51119 L
.53334 .51252 L
.52838 .51361 L
.52388 .51414 L
.51979 .51384 L
.51596 .51258 L
.51224 .51036 L
.50843 .50733 L
.50438 .50376 L
.5 .5 L
Mfstroke
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(W) show
69.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C3) show
77.812500 14.625000 moveto
(N28) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.5 0.25 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.5 .5 m
.49545 .50435 L
.49091 .50803 L
.48636 .5105 L
.48182 .51136 L
.47727 .5105 L
.47273 .50803 L
.46818 .50435 L
.46364 .5 L
.45909 .49565 L
.45455 .49196 L
.45 .4895 L
.44546 .48863 L
.44091 .4895 L
.43636 .49196 L
.43182 .49565 L
.42727 .5 L
.42273 .50434 L
.41818 .50803 L
.41364 .51049 L
.40909 .51136 L
.40455 .51049 L
.4 .50803 L
.39545 .50434 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34546 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.40909 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.50455 .49565 L
.50909 .49197 L
.51364 .4895 L
.51818 .48864 L
.52273 .4895 L
.52727 .49197 L
.53182 .49565 L
.53636 .5 L
.54091 .50435 L
.54545 .50804 L
.55 .5105 L
.55454 .51137 L
.55909 .5105 L
.56364 .50804 L
.56818 .50435 L
.57273 .5 L
.57727 .49566 L
.58182 .49197 L
.58636 .48951 L
.59091 .48864 L
.59545 .48951 L
.6 .49197 L
.60455 .49566 L
.60909 .5 L
.61364 .50435 L
.61818 .50804 L
.62273 .5105 L
.62727 .51137 L
.63182 .5105 L
.63636 .50804 L
.64091 .50435 L
.64545 .5 L
.65 .49565 L
.65454 .49197 L
.65909 .4895 L
.66364 .48864 L
.66818 .4895 L
.67273 .49197 L
.67727 .49565 L
.68182 .5 L
s
gsave
.59091 .54296 -65 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.5 .5 m
.49562 .50376 L
.49157 .50733 L
.48776 .51036 L
.48404 .51258 L
.48021 .51384 L
.47612 .51414 L
.47162 .51362 L
.46666 .51252 L
.46125 .51119 L
.45552 .51 L
.44965 .50932 L
.4439 .50947 L
.43856 .51066 L
.43389 .51301 L
.43013 .5165 L
.42739 .52099 L
.42572 .52625 L
.42502 .53199 L
.42509 .53791 L
.42563 .54371 L
.4263 .54918 L
.42673 .55415 L
.4266 .5586 L
.42568 .56256 L
.42382 .56616 L
.42103 .56957 L
.41746 .573 L
.41336 .57663 L
.4091 .58058 L
.4051 .58494 L
.40175 .58967 L
.39942 .5947 L
.39838 .59987 L
.39877 .60499 L
.4006 .60987 L
.40372 .61434 L
.40786 .61831 L
.41266 .62173 L
.41774 .62468 L
.4227 .62729 L
.42719 .62976 L
.43096 .63233 L
.43389 .63523 L
.43598 .63866 L
.43735 .64274 L
.43821 .64749 L
.43887 .65281 L
.43964 .65851 L
.44082 .66431 L
Mistroke
.44264 .66986 L
.44526 .67482 L
.44873 .67886 L
.453 .68173 L
.45793 .68331 L
.46331 .68358 L
.46891 .68266 L
.47449 .68082 L
.47987 .67839 L
.48491 .67578 L
.48958 .67338 L
.49391 .67156 L
.498 .67058 L
.502 .67058 L
.50609 .67156 L
.51042 .67338 L
.51509 .67578 L
.52013 .67839 L
.52551 .68082 L
.53109 .68266 L
.53669 .68358 L
.54207 .68331 L
.547 .68173 L
.55127 .67886 L
.55474 .67482 L
.55736 .66986 L
.55918 .66431 L
.56036 .65851 L
.56113 .65281 L
.56179 .64749 L
.56265 .64274 L
.56402 .63866 L
.56611 .63523 L
.56904 .63233 L
.57281 .62976 L
.5773 .62729 L
.58226 .62468 L
.58734 .62173 L
.59214 .61831 L
.59628 .61434 L
.5994 .60987 L
.60122 .60499 L
.60162 .59987 L
.60058 .5947 L
.59825 .58967 L
.5949 .58494 L
.5909 .58058 L
.58664 .57663 L
.58254 .573 L
.57897 .56957 L
Mistroke
.57618 .56616 L
.57432 .56256 L
.5734 .5586 L
.57327 .55415 L
.57371 .54917 L
.57437 .54371 L
.57491 .53791 L
.57498 .53199 L
.57428 .52625 L
.5726 .52099 L
.56987 .5165 L
.56611 .51302 L
.56144 .51066 L
.5561 .50947 L
.55035 .50932 L
.54448 .51 L
.53875 .51119 L
.53334 .51252 L
.52838 .51361 L
.52388 .51414 L
.51979 .51384 L
.51596 .51258 L
.51224 .51036 L
.50843 .50733 L
.50438 .50376 L
.5 .5 L
Mfstroke
.52727 .68182 m
.47273 .7 L
.47273 .66364 L
F
gsave
.5 .72478 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(W) show
69.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.5 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T1) show
70.187500 14.625000 moveto
(C4) show
77.812500 14.625000 moveto
(N29) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.5 0.5 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
66.312500 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
66.312500 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C1) show
77.812500 14.625000 moveto
(N30) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.5 0.75 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.000000 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.000000 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C2) show
77.812500 14.625000 moveto
(N31) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.5 1 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
66.312500 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
66.312500 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C3) show
77.812500 14.625000 moveto
(N32) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.25 0.25 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.000000 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.000000 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C4) show
77.812500 14.625000 moveto
(N33) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.25 0.5 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
66.312500 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
66.312500 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C5) show
77.812500 14.625000 moveto
(N34) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.25 0.75 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
gsave
.5 .41022 -66.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.000000 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
67.000000 10.000000 moveto
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
gsave
.5 .58978 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.187500 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(j) show
67.000000 10.000000 moveto
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C6) show
77.812500 14.625000 moveto
(N35) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.25 1 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.000000 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.187500 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(j) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C7) show
77.812500 14.625000 moveto
(N36) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 0.25 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
66.312500 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
66.312500 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C8) show
77.812500 14.625000 moveto
(N37) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0 0.5 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
gsave
.5 .41022 -66.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.000000 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
67.000000 10.000000 moveto
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
gsave
.5 .58978 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.187500 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(j) show
67.000000 10.000000 moveto
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C9) show
77.812500 14.625000 moveto
(N38) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0 0.75 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.000000 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.687500 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(c) show
63.750000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
67.187500 16.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(j) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C10) show
80.562500 14.625000 moveto
(N39) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0 1 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C1) show
77.812500 14.625000 moveto
(N40) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.39773 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.44886 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.5 1.295 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
63.000000 14.625000 moveto
(\\256) show
68.750000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
gsave
.55114 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.60227 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{217.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003I000182000`400?l00000o`00003of@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00100oooo00@000000?ooo`00
000000000P3oool3000000080?ooo`00000000000?ooo`000000oooo0000003oool2000002<0oooo
00@000000?ooo`00000000000P3oool3000000080?ooo`00000000000?ooo`000000oooo0000003o
ool2000000030?ooo`000000000001h0oooo00@000000?ooo`00000000000P3oool300000080oooo
00@000000?ooo`00000000000P3oool010000000oooo0000003oool2000000030?ooo`0000000000
01h0oooo00@000000?ooo`00000000000P3oool300000080oooo00H000000?ooo`3oool000000?oo
o`0000040?ooo`800000403oool00100oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`3oool2000000040?ooo`000000000000000080oooo00@000000?ooo`3oool00000803oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo1@0000020?ooo`040000003o
ool00000000001h0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`06
0000003oool000000?ooo`000000oooo0`0000020?ooo`030000003oool0oooo008000007@3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`00
00001`3oool000000000003oool000000?ooo`0000003`3oool00100oooo00L000000?ooo`3oool0
oooo0000003oool0000000<0oooo0P000000103oool000000000000000020?ooo`040000003oool0
oooo00000200oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`00
00000`0000020?ooo`040000003oool00000000001h0oooo00L000000?ooo`3oool0oooo0000003o
ool0000000@0oooo00@000000?ooo`00000000000P3oool300000080oooo00D000000?ooo`000000
oooo0000000M0?ooo`070000003oool0oooo0?ooo`000000oooo000000040?ooo`030000003oool0
oooo00<0000000@0oooo000000000000oooo0P00000@0?ooo`003`3oool3000000030?ooo`000000
oooo0080oooo0P0000020?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000P00000N
0?ooo`<0000000<0oooo0000003oool00P3oool200000080oooo00<000000?ooo`000000103oool0
10000000oooo0?ooo`00000M0?ooo`<0000000<0oooo0000003oool00P3oool2000000D0oooo00@0
00000?ooo`3oool00000103oool010000000oooo0?ooo`00000M0?ooo`<0000000<0oooo0000003o
ool00P3oool2000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`00
303oool2000003@0oooo0P00000d0?ooo`8000003P3oool00`000000oooo0?ooo`0T0?ooo`800000
:03oool000`0oooo0`00000<0?ooo`030000003oool0oooo02@0oooo0`0000090?ooo`040000003o
ool00000000002H0oooo0`0000090?ooo`050000003oool000000?ooo`0000009P3oool3000002L0
oooo000=0?ooo`030000003oool0oooo00P0oooo0P0000000`3oool000000?ooo`0V0?ooo`030000
003oool0oooo00T0oooo0`00000W0?ooo`030000003oool0oooo00T0oooo0P0000000`3oool00000
0?ooo`0V0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0703oool001P0oooo0P00
00000`3oool000000?ooo`0c0?ooo`800000=03oool200000380oooo0`00000L0?ooo`000P3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0D0?ooo`800000603oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo01@0oooo0P00000H0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0000001P0oooo00<000000?ooo`3oool00@3oool0
00<0oooo00<000000?ooo`3oool0303oool2000001h0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0<0?ooo`800000103oool2000001P0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0<0?ooo`800000103oool2000001P0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`020?ooo`00103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0080
oooo0P00000H0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`020?ooo`800000603oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`0000007P3oool00`000000oooo0?ooo`020?ooo`001@3oool2000000`0oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`070?ooo`800000303oool00`000000oooo
0?ooo`050?ooo`800000503oool00`000000oooo0?ooo`070?ooo`800000303oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00L0oooo0P00000;0?ooo`<00000703oool00`000000oooo
0?ooo`030?ooo`001`3oool00`000000oooo0?ooo`080?ooo`<000006P3oool2000000`0oooo00<0
00000?ooo`3oool0203oool3000000H0oooo0P00000B0?ooo`800000303oool00`000000oooo0?oo
o`080?ooo`<000006P3oool2000000`0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`040?ooo`00203oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0403oool200000140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`06
0?ooo`00203oool2000002<0oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?oo
o`3oool03P3oool2000002<0oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?oo
o`3oool01`3oool000T0oooo0P00000O0?ooo`<000004`3oool00`000000oooo0?ooo`0M0?ooo`<0
00004`3oool00`000000oooo0?ooo`0M0?ooo`<000004`3oool00`000000oooo0?ooo`0M0?ooo`<0
00002P3oool00080oooo0P0000070?ooo`030000003oool0oooo01`0oooo0P00000=0?ooo`800000
1P3oool00`000000oooo0?ooo`0L0?ooo`8000003@3oool2000000H0oooo00<000000?ooo`3oool0
703oool2000000d0oooo0P0000060?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0
2@3oool00080oooo0`0000070?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03@3o
ool3000000H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<000001P3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00d0oooo0`0000060?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool02`3oool000<0oooo00<000000?ooo`3oool01`3oool2
000000X0oooo0`00000<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool2
000000/0oooo0P00000<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool2
000000X0oooo0`00000<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool2
000000X0oooo1000000;0?ooo`030000003oool0oooo00`0oooo000?0?ooo`030000003oool0oooo
00H0oooo0P0000020?ooo`8000002@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
00H0oooo0P0000020?ooo`8000002@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
00H0oooo0P0000020?ooo`8000002@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00d0oooo000@0?ooo`030000003oool0oooo008000000P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00D0oooo0P00000O0?ooo`030000003oool0oooo008000000P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo0P00000O0?ooo`030000003oool0oooo0080
00000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo0P00000O0?ooo`03
0000003oool0oooo008000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool03P3oool00100oooo200000060?ooo`@0000000<0oooo000000000000
2P3oool00`000000oooo0?ooo`0D0?ooo`P000001P3oool4000000030?ooo`000000000000X0oooo
00<000000?ooo`3oool0503oool4000000040?ooo`0000000000000000H0oooo100000000`3oool0
00000000000:0?ooo`030000003oool0oooo01D0oooo0`000000103oool000000000000000070?oo
o`<0000000@0oooo00000000000000002@3oool00`000000oooo0?ooo`050?ooo`00403oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`070?ooo`<00000503oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`<00000503oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`070?ooo`<00000503oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`<000001@3oool000h0
oooo0P0000080?ooo`8000000`3oool00`000000oooo0?ooo`060?ooo`8000001`3oool00`000000
oooo0000000B0?ooo`800000203oool2000000<0oooo00<000000?ooo`3oool01P3oool2000000L0
oooo00<000000?ooo`0000004P3oool2000000P0oooo0P0000030?ooo`030000003oool0oooo00H0
oooo0P0000070?ooo`030000003oool000000180oooo0P0000080?ooo`8000000`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000001@3oool000d0oooo
00<000000?ooo`3oool02@3oool4000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00X0oooo0`00000;0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`090?ooo`@000002`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool02@3oool4000000/0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`00303oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`0F0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo00/0oooo000:0?ooo`8000007P3oool00`000000oooo0?ooo`0C
0?ooo`8000007P3oool00`000000oooo0?ooo`0C0?ooo`8000007P3oool00`000000oooo0?ooo`0C
0?ooo`8000007`3oool00`000000oooo0?ooo`090?ooo`002@3oool200000200oooo0P00000B0?oo
o`800000803oool300000140oooo0P00000P0?ooo`<000004@3oool200000240oooo0P0000090?oo
o`00203oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo0P00000@0?ooo`03
0000003oool0oooo0100oooo00@000000?ooo`3oool000003@3oool200000100oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`800000403oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo00X0oooo0P0000090?ooo`001`3oool00`000000oooo0?ooo`0D0?ooo`<0
00003@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool00`00000=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04P3oool00`000000
oooo00000002000000d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0E0?ooo`80
00003@3oool00`000000oooo0?ooo`060?ooo`001P3oool00`000000oooo0?ooo`0E0?ooo`040000
003oool000000?ooo`8000002`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00l0
oooo00@000000?ooo`00000000000P3oool010000000oooo0000003oool2000000/0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`060000003oool000000?ooo`000000oooo
0P00000;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool05P3oool2000000030?oo
o`000000000000`0oooo00<000000?ooo`3oool0103oool000@0oooo0P00000E0?ooo`040000003o
ool0oooo000000<0oooo0P00000<0?ooo`800000203oool2000001<0oooo0`0000020?ooo`040000
003oool0oooo0?ooo`800000303oool2000000P0oooo0P00000B0?ooo`070000003oool000000?oo
o`000000oooo000000030?ooo`800000303oool2000000P0oooo0P00000I0?ooo`030000003oool0
oooo008000003@3oool00`000000oooo0?ooo`030?ooo`000`3oool00`000000oooo0?ooo`0B0?oo
o`80000000<0oooo0000003oool01@3oool2000000h0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0D0?ooo`8000001P3oool2000000h0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0C0?ooo`80000000<0oooo0000003oool0103oool2000000h0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00L0oooo0P00000>0?oo
o`030000003oool0oooo0080oooo00020?ooo`030000003oool0oooo01<0oooo0P0000000`3oool0
00000?ooo`0F0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0503oool2000001P0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`8000005`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo01<0oooo0`00000H0?ooo`030000003oool0oooo0040
oooo000H0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool09`3oool2000000X0oooo
00<000000?ooo`3oool0:03oool2000000T0oooo00<000000?ooo`3oool09`3oool00`000000oooo
000000090?ooo`030000003oool0oooo0100oooo000T0?ooo`<000009`3oool2000000X0oooo0`00
000W0?ooo`8000002P3oool3000002L0oooo00<000000?ooo`3oool02@3oool300000100oooo000T
0?ooo`030000003oool0000002X0oooo0P0000070?ooo`030000003oool0000002L0oooo0P00000:
0?ooo`030000003oool0000003<0oooo00<000000?ooo`000000403oool002@0oooo00<000000?oo
o`3oool0:P3oool2000000L0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?oo
o`030000003oool0oooo0100oooo001A0?ooo`800000QP3oool00=T0oooo003I0?ooo`00f@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00100oooo00@000000?ooo`00000000000P3oool3000000@0
oooo00@000000?ooo`000000oooo0P0000000`3oool000000000000P0?ooo`040000003oool00000
00000080oooo0`000000203oool000000000003oool000000?ooo`000000oooo0P00000S0?ooo`04
0000003oool0000000000080oooo0`000000203oool000000000003oool000000?ooo`000000oooo
0P0000000`3oool000000000000P0?ooo`040000003oool0000000000080oooo0`0000050?ooo`04
0000003oool000000?ooo`80000000<0oooo000000000000403oool00100oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`3oool2000000040?ooo`000000000000000080oooo00@0
00000?ooo`3oool00000803oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080
oooo1@0000020?ooo`040000003oool0000000000200oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`3oool600000080oooo00<000000?ooo`3oool00P00000O0?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0300000080oooo
00<000000?ooo`0000000P00000?0?ooo`00403oool01`000000oooo0?ooo`3oool000000?ooo`00
00000`3oool2000000040?ooo`000000000000000080oooo00@000000?ooo`3oool00000803oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0?ooo`0300000080oooo
00@000000?ooo`0000000000803oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool0
0`000000oooo0?ooo`0300000080oooo00<000000?ooo`0000008@3oool01`000000oooo0?ooo`3o
ool000000?ooo`000000103oool00`000000oooo0?ooo`0300000080oooo00<000000?ooo`000000
4@3oool000l0oooo0`0000000`3oool000000?ooo`020?ooo`800000103oool00`000000oooo0?oo
o`020?ooo`040000003oool0oooo000001l0oooo0`0000000`3oool000000?ooo`020?ooo`800000
0P3oool00`000000oooo000000040?ooo`030000003oool0oooo0200oooo0`0000000`3oool00000
0?ooo`020?ooo`8000000P3oool00`000000oooo000000040?ooo`040000003oool0oooo000001l0
oooo0`0000000`3oool000000?ooo`020?ooo`80000000H0oooo00000000000000000?ooo`000004
0?ooo`040000003oool0oooo00000100oooo000<0?ooo`8000003P3oool00`000000oooo0?ooo`0S
0?ooo`800000=03oool2000003D0oooo0P00000=0?ooo`030000003oool0oooo01P0oooo000<0?oo
o`<000002@3oool01@000000oooo0000003oool0000002D0oooo0`00000<0?ooo`030000003oool0
oooo02@0oooo0`0000090?ooo`040000003oool00000000002L0oooo0`0000080?ooo`050000003o
ool000000?ooo`0000006P3oool000d0oooo00<000000?ooo`3oool02@3oool2000000030?ooo`00
0000oooo02D0oooo00<000000?ooo`3oool0203oool2000000030?ooo`000000oooo02H0oooo00<0
00000?ooo`3oool02@3oool3000002P0oooo00<000000?ooo`3oool0203oool2000000030?ooo`00
0000oooo01T0oooo000J0?ooo`800000<P3oool2000000030?ooo`000000oooo03<0oooo0P00000d
0?ooo`8000006`3oool00180oooo00<000000?ooo`3oool0103oool2000003<0oooo00<000000?oo
o`3oool0=03oool2000003@0oooo0P00000L0?ooo`000P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo0080oooo0P00000I0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool03@3oool2000001l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`80
0000103oool2000001T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`80
00001@3oool2000001P0oooo00<000000?ooo`3oool00@3oool000<0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo000000040?ooo`800000603oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool2000001P0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00<0oooo0P00000G0?ooo`030000
003oool0oooo0080oooo00040?ooo`800000303oool3000001`0oooo00<000000?ooo`3oool01P3o
ool2000000d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`060?ooo`8000003@3o
ool00`000000oooo0?ooo`050?ooo`800000503oool00`000000oooo0?ooo`060?ooo`8000003@3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00<0oooo00060?ooo`030000003oool0
oooo02H0oooo0P00000;0?ooo`030000003oool0oooo00T0oooo0`00000J0?ooo`8000002`3oool0
0`000000oooo0?ooo`090?ooo`<000001P3oool200000180oooo0P00000;0?ooo`030000003oool0
oooo00T0oooo0`00000K0?ooo`030000003oool0oooo00@0oooo00070?ooo`030000003oool0oooo
02@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool04@3oool200000140oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo00H0oooo00080?ooo`8000008`3oool00`000000
oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000
oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?ooo`070?ooo`00203oool3000001l0oooo
0`00000A0?ooo`<000007`3oool300000140oooo0`00000O0?ooo`<000004@3oool3000001l0oooo
0`00000:0?ooo`000P3oool2000000L0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P00
00060?ooo`030000003oool0oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?oo
o`0L0?ooo`8000003@3oool2000000H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?oo
o`090?ooo`000P3oool3000000L0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=
0?ooo`<000001P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00d0oooo0`000006
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03@3oool3000000H0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0;0?ooo`000`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00T0oooo0`00000<0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`090?ooo`<00000303oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool2000000`0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo0`00000<0?oo
o`030000003oool0oooo00`0oooo000>0?ooo`800000203oool200000080oooo0P0000090?ooo`03
0000003oool0oooo01X0oooo0P0000080?ooo`8000000P3oool2000000T0oooo00<000000?ooo`3o
ool06P3oool2000000P0oooo0P0000020?ooo`8000002@3oool00`000000oooo0?ooo`0J0?ooo`80
0000203oool200000080oooo0P0000090?ooo`030000003oool0oooo00d0oooo000@0?ooo`030000
003oool0oooo008000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo
0P00000O0?ooo`030000003oool0oooo008000000P3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo0P00000O0?ooo`030000003oool0oooo008000000P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo0P00000O0?ooo`030000003oool0oooo00800000
0P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
3P3oool00100oooo200000060?ooo`@0000000<0oooo0000000000008@3oool8000000H0oooo1000
00000`3oool000000000000Q0?ooo`@0000000@0oooo00000000000000001P3oool4000000030?oo
o`00000000000240oooo10000000103oool000000000000000060?ooo`@0000000@0oooo00000000
000000004@3oool00100oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`00
3P3oool2000000P0oooo0P0000030?ooo`030000003oool0oooo00H0oooo0P0000070?ooo`<00000
4P3oool2000000P0oooo0P0000030?ooo`030000003oool0oooo00H0oooo0P0000070?ooo`<00000
4P3oool2000000P0oooo0P0000030?ooo`030000003oool0oooo00H0oooo0P0000070?ooo`<00000
4P3oool2000000P0oooo0P0000030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1@3oool3000000D0oooo000=0?ooo`030000003oool0oooo00T0oooo1000000;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`0000004@3oool00`000000oooo0?ooo`090?ooo`@000002`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool000000140oooo00<000000?ooo`3oool02P3o
ool3000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A0?ooo`030000003o
ool0oooo00T0oooo1000000;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000001@3o
ool000`0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00D0oooo000:0?ooo`8000007P3oool00`000000oooo0?ooo`0C0?ooo`8000007P3oool00`00
0000oooo0?ooo`0C0?ooo`8000007P3oool00`000000oooo0?ooo`0C0?ooo`8000007`3oool00`00
0000oooo0?ooo`090?ooo`002@3oool200000200oooo0P00000B0?ooo`800000803oool300000140
oooo0P00000P0?ooo`<000004@3oool200000240oooo0P0000090?ooo`00203oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo00/0oooo0P00000@0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool02`3oool200000100oooo00<000000?ooo`3oool0403oool01@000000oooo
0?ooo`3oool0000000`0oooo0P00000@0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool02P3oool2000000T0oooo00070?ooo`030000003oool0oooo01@0oooo0`00000=0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0503oool2000000h0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0A0?ooo`040000003oool0oooo0?ooo`8000003@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool00P00000=0?ooo`03
0000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo01<0oooo00H000000?ooo`000000
oooo0000003oool2000000/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E0?oo
o`8000000P3oool2000000/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?oo
o`040000003oool00000000000<0oooo0P0000000`3oool000000000000;0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`02000000030?ooo`000000
000000`0oooo00<000000?ooo`3oool0103oool000@0oooo0P00000B0?ooo`070000003oool00000
0?ooo`000000oooo000000030?ooo`800000303oool2000000P0oooo0P00000E0?ooo`040000003o
ool0oooo000000<0oooo0P00000<0?ooo`800000203oool2000001<0oooo0`0000030?ooo`030000
003oool0oooo00800000303oool2000000P0oooo0P00000B0?ooo`050000003oool000000?ooo`00
00000P3oool00`000000oooo0?ooo`02000000d0oooo00<000000?ooo`3oool00`3oool000<0oooo
00<000000?ooo`3oool04`3oool2000000030?ooo`000000oooo00@0oooo0P00000>0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool2000000030?ooo`000000oooo00D0oooo
0P00000>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0503oool2000000H0oooo
0P00000>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04`3oool2000000030?oo
o`000000oooo00@0oooo0P00000>0?ooo`030000003oool0oooo0080oooo00020?ooo`030000003o
ool0oooo01D0oooo0P00000G0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04`3o
ool2000000030?ooo`000000oooo01H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0D0?ooo`800000603oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01D0oooo0P00
000G0?ooo`030000003oool0oooo0040oooo000I0?ooo`8000002@3oool00`000000oooo0?ooo`0W
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool09`3oool2000000X0oooo00<00000
0?ooo`3oool0:03oool2000000T0oooo00<000000?ooo`3oool0403oool001P0oooo0P00000:0?oo
o`<00000<`3oool3000002L0oooo0P00000:0?ooo`<00000:03oool2000000T0oooo0`00000@0?oo
o`00603oool2000000X0oooo00<000000?ooo`000000<`3oool00`000000oooo0000000Z0?ooo`80
00001`3oool00`000000oooo0000000X0?ooo`8000002@3oool00`000000oooo0000000@0?ooo`00
903oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo02X0oooo0P0000070?ooo`030000
003oool0oooo03<0oooo00<000000?ooo`3oool0403oool008L0oooo0P00001@0?ooo`00f@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00403oool010000000oooo0?ooo`00
00020?ooo`<00000103oool010000000oooo0000003oool2000000030?ooo`00000000000200oooo
00@000000?ooo`00000000000P3oool300000080oooo00H000000?ooo`000000oooo0000003oool2
000000030?ooo`00000000000200oooo00@000000?ooo`00000000000P3oool3000000080?ooo`00
000000000?ooo`000000oooo0000003oool200000080oooo00<000000?ooo`3oool07P3oool01000
0000oooo0000000000020?ooo`<0000000<0oooo0000000000000P3oool010000000oooo0000003o
ool2000000030?ooo`00000000000100oooo000@0?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool0oooo0P000000103oool000000000000000020?ooo`030000003oool0oooo0080
00007`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`0000000P0000020?ooo`050000003oool000000?ooo`0000007`3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P0000020?ooo`040000003o
ool0oooo00000200oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<000000P3oool010000000oooo0?ooo`00000@0?ooo`00403oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo0?ooo`80000000@0oooo00000000000000000`3o
ool2000000030?ooo`000000oooo01h0oooo00L000000?ooo`3oool0oooo0000003oool0000000@0
oooo00<000000?ooo`0000000P0000020?ooo`040000003oool0000000000200oooo00L000000?oo
o`3oool0oooo0000003oool0000000D0oooo100000020?ooo`040000003oool0oooo00000200oooo
00L000000?ooo`3oool0oooo0000003oool0000000@0oooo00<000000?ooo`3oool00`0000020?oo
o`050000003oool0oooo0?ooo`0000003`3oool000l0oooo0`0000050?ooo`800000103oool00`00
0000oooo0?ooo`020?ooo`040000003oool0oooo000001l0oooo0`0000000`3oool000000?ooo`02
0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000001l0oooo0`00
00000`3oool000000?ooo`020?ooo`8000000P3oool00`000000oooo000000040?ooo`030000003o
ool0oooo0200oooo0`0000000`3oool000000?ooo`020?ooo`8000000P3oool010000000oooo0?oo
o`0000040?ooo`040000003oool0oooo00000100oooo000<0?ooo`800000=03oool2000003@0oooo
0P00000>0?ooo`030000003oool0oooo02@0oooo0P00000X0?ooo`00303oool3000003<0oooo0`00
000<0?ooo`030000003oool0oooo02@0oooo0`0000090?ooo`050000003oool000000?ooo`000000
9P3oool3000000`0oooo00<000000?ooo`3oool0603oool000d0oooo00<000000?ooo`3oool0<`3o
ool00`000000oooo0?ooo`080?ooo`80000000<0oooo0000003oool09P3oool00`000000oooo0?oo
o`090?ooo`80000000<0oooo0000003oool09P3oool00`000000oooo0?ooo`070?ooo`8000000P3o
ool00`000000oooo0?ooo`0H0?ooo`00CP3oool2000000030?ooo`000000oooo03<0oooo0P00000b
0?ooo`8000000P3oool00`000000oooo0?ooo`0H0?ooo`00B03oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02d0oooo00<000000?ooo`3oool0103oool2000002d0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0L0?ooo`000P3oool00`000000oooo0?ooo`0?0?ooo`80
00007@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool00P3oool2000001T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool00@3oool000<0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0000000N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo000000040?ooo`800000603oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`0000007P3oool00`000000oooo0?ooo`020?ooo`00103o
ool2000000l0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`800000303o
ool3000001`0oooo00<000000?ooo`3oool01P3oool2000000`0oooo0`00000L0?ooo`030000003o
ool0oooo00H0oooo0P00000<0?ooo`<00000703oool00`000000oooo0?ooo`030?ooo`001P3oool0
0`000000oooo0?ooo`0;0?ooo`<00000603oool2000000/0oooo00<000000?ooo`3oool09P3oool2
000000/0oooo00<000000?ooo`3oool09P3oool2000000/0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`040?ooo`001`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
02@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo
00H0oooo00080?ooo`8000008`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000
oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000
oooo0?ooo`070?ooo`00203oool3000001l0oooo0`00000A0?ooo`<000007`3oool300000140oooo
0`00000O0?ooo`<000004@3oool3000001l0oooo0`00000:0?ooo`000P3oool2000000L0oooo00<0
00000?ooo`3oool0703oool2000000d0oooo0P0000060?ooo`030000003oool0oooo01`0oooo0P00
000=0?ooo`8000001P3oool00`000000oooo0?ooo`0L0?ooo`8000003@3oool2000000H0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`090?ooo`000P3oool3000000L0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<000001P3oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool03@3oool3000000H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0;
0?ooo`000`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo0`00000<0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?oo
o`<00000303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool02@3oool3000000`0oooo00<000000?ooo`3oool0303oool000h0oooo0P00000G0?ooo`03
0000003oool0oooo01X0oooo0P0000080?ooo`8000000P3oool2000000T0oooo00<000000?ooo`3o
ool06P3oool2000000P0oooo0P0000020?ooo`8000002@3oool00`000000oooo0?ooo`0J0?ooo`80
0000203oool200000080oooo0P0000090?ooo`030000003oool0oooo00d0oooo000@0?ooo`030000
003oool0oooo008000000P3oool200000080oooo0P0000020?ooo`8000000P3oool4000001l0oooo
00<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
103oool2000001l0oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool2000001l0oooo00<000000?ooo`3oool00P0000020?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`00403o
oolE00000240oooo200000060?ooo`@0000000<0oooo0000000000008@3oool4000000040?ooo`00
00000000000000H0oooo100000000`3oool000000000000Q0?ooo`@0000000@0oooo000000000000
00001P3oool4000000040?ooo`000000000000000140oooo000@0?ooo`030000003oool0000000<0
oooo2P0000000`3oool000000?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0503oool00`000000oooo000000030?ooo`8000001P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0503oool00`000000oooo000000030?ooo`80
00001P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0503oool00`000000oooo000000030?ooo`8000001P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool000h0oooo0P0000060?ooo`800000
1`3oool00`000000oooo0?ooo`040?ooo`8000001`3oool300000180oooo0P0000080?ooo`800000
0`3oool00`000000oooo0?ooo`060?ooo`8000001`3oool300000180oooo0P0000080?ooo`800000
0`3oool00`000000oooo0?ooo`060?ooo`8000001`3oool300000180oooo0P0000080?ooo`800000
0`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo0`0000050?ooo`003@3o
ool00`000000oooo0?ooo`060?ooo`8000001P3oool2000000P0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0000000A0?ooo`030000003oool0oooo00T0oooo1000000;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`0000004@3oool00`000000oooo0?ooo`090?ooo`@000002`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool000000140oooo00<000000?ooo`3oool02@3o
ool4000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo000000050?ooo`00303oool0
0`000000oooo0?ooo`060?ooo`800000203oool2000000P0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`050?ooo`002P3oool2000000T0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo01<0oooo0P00000N0?ooo`030000003oool0oooo
01<0oooo0P00000N0?ooo`030000003oool0oooo01<0oooo0P00000O0?ooo`030000003oool0oooo
00T0oooo00090?ooo`8000002P3oool2000000P0oooo0P00000:0?ooo`8000004P3oool200000200
oooo0`00000A0?ooo`800000803oool300000140oooo0P00000Q0?ooo`8000002@3oool000P0oooo
00<000000?ooo`3oool02`3oool2000000H0oooo0P00000<0?ooo`800000403oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo00/0oooo0P00000@0?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool02P3oool200000100oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0;0?ooo`8000002@3oool000L0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`040?ooo`8000003P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01@0oooo0P00
000>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool05@3oool2000000d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0D0?ooo`<000003@3oool00`000000oooo0?oo
o`060?ooo`001P3oool00`000000oooo0?ooo`0>0?ooo`80000000@0oooo000000000000oooo0`00
000?0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool05@3oool200000080oooo0P00
000;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`02000000030?ooo`000000000000/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0E0?ooo`040000003oool000000?ooo`800000303oool00`000000oooo0?ooo`040?ooo`00103o
ool200000180oooo1P0000000`3oool000000?ooo`0?0?ooo`800000203oool2000001D0oooo00@0
00000?ooo`3oool000000`3oool2000000`0oooo0P0000080?ooo`8000004P3oool01@000000oooo
0000003oool000000080oooo00<000000?ooo`3oool00P00000<0?ooo`800000203oool2000001H0
oooo00<000000?ooo`0000000`3oool2000000d0oooo00<000000?ooo`3oool00`3oool000<0oooo
00<000000?ooo`3oool0603oool300000140oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0B0?ooo`80000000<0oooo0000003oool01@3oool2000000h0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0C0?ooo`80000000<0oooo0000003oool0103oool2000000h0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0B0?ooo`8000000P3oool00`000000oooo
0?ooo`030?ooo`8000003P3oool00`000000oooo0?ooo`020?ooo`000P3oool00`000000oooo0?oo
o`0^0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04`3oool2000000030?ooo`00
0000oooo01H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`8000005`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01<0oooo0P0000020?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool00@3oool002@0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo02P0oooo0P0000090?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`00903oool30000
03<0oooo0`00000W0?ooo`8000002P3oool3000003<0oooo0`00000@0?ooo`00903oool00`000000
oooo0000000c0?ooo`030000003oool0000002L0oooo0P00000:0?ooo`030000003oool0000003<0
oooo00<000000?ooo`000000403oool002@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0403oool001T0oooo00<0
00000?ooo`000000_@3oool001P0oooo1000002m0?ooo`00603oool400000;d0oooo000H0?ooo`05
0000003oool000000?ooo`000000_03oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo000>
0?ooo`040000003oool0oooo00000080oooo0`000000103oool000000000003oool200000080oooo
00@000000?ooo`000000oooo0P0000000`3oool000000000000N0?ooo`040000003oool0oooo0000
0080oooo0`0000020?ooo`060000003oool000000?ooo`000000oooo0P0000000`3oool000000000
000P0?ooo`040000003oool0oooo00000080oooo0`000000203oool000000000003oool000000?oo
o`000000oooo0P00000S0?ooo`040000003oool0oooo00000080oooo0`0000000`3oool000000000
00020?ooo`040000003oool000000?ooo`80000000<0oooo000000000000403oool000h0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00800000
00@0oooo00000000000000000P3oool00`000000oooo0?ooo`02000001d0oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool00000008000000P3oool00`00
0000oooo00000002000001l0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool00000008000000P3oool010000000oooo0?ooo`00000P0?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0300000080oooo
00@000000?ooo`0000000000403oool000h0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`030?ooo`8000000`3oool3000000<0oooo0P00000O0?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00P3oool00`000000oooo00000002000000<0oooo0P00000Q0?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool4000000<0oooo00<00000
0?ooo`000000803oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool00`0000030?ooo`<00000403oool000`0oooo100000050?ooo`8000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
6P3oool2000000040?ooo`0000000000000000D0oooo0P0000040?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool00000703oool2000000040?ooo`0000000000000000D0oooo0P000002
0?ooo`030000003oool0000000@0oooo00<000000?ooo`0000000P00000K0?ooo`80000000@0oooo
00000000000000001@3oool200000080oooo00@000000?ooo`3oool00000103oool010000000oooo
0?ooo`00000@0?ooo`00303oool3000003<0oooo0`00000c0?ooo`<00000<`3oool3000002P0oooo
000=0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?oo
o`0c0?ooo`030000003oool0oooo02L0oooo003I0?ooo`00BP3oool00`000000oooo0?ooo`0c0?oo
o`030000003oool0oooo05H0oooo00020?ooo`030000003oool0oooo00l0oooo0P00000M0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool03`3oool2000001d0oooo00<000000?ooo`3o
ool00@3oool000<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0J0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0000000L0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0000000L0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0J0?ooo`030000
003oool0oooo0080oooo00040?ooo`8000003`3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo00H0oooo0P00000>0?ooo`<000006P3oool00`000000oooo0?ooo`060?ooo`8000003P3o
ool3000001X0oooo00<000000?ooo`3oool01P3oool2000000l0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`030?ooo`001P3oool00`000000oooo0?ooo`0;0?ooo`<00000603oool2
000000/0oooo00<000000?ooo`3oool09P3oool2000000/0oooo00<000000?ooo`3oool09P3oool2
000000/0oooo00<000000?ooo`3oool02`3oool3000001T0oooo00<000000?ooo`3oool0103oool0
00L0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
02@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`060?ooo`00203oool2000002<0
oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?ooo`3oool03P3oool2000002<0
oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?ooo`3oool01`3oool000P0oooo
0`00000O0?ooo`<000004@3oool3000001l0oooo0`00000A0?ooo`<000007`3oool300000140oooo
0`00000O0?ooo`<000002P3oool00080oooo0P0000070?ooo`030000003oool0oooo01`0oooo0P00
000=0?ooo`8000001P3oool00`000000oooo0?ooo`0L0?ooo`8000003@3oool2000000H0oooo00<0
00000?ooo`3oool0703oool2000000d0oooo0P0000060?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool02@3oool00080oooo0`0000070?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool03@3oool3000000H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=
0?ooo`<000001P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00d0oooo0`000006
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool02`3oool000<0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00`0oooo000>0?ooo`80
00005`3oool00`000000oooo0?ooo`0J0?ooo`8000005`3oool00`000000oooo0?ooo`0J0?ooo`80
00005`3oool00`000000oooo0?ooo`0J0?ooo`8000005`3oool00`000000oooo0?ooo`0=0?ooo`00
403oool00`000000oooo0?ooo`0200000080oooo0P0000020?ooo`8000000P3oool200000080oooo
1000000O0?ooo`030000003oool0oooo008000000P3oool200000080oooo0P0000020?ooo`800000
0P3oool4000001l0oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000P3oool200000080
oooo0P0000020?ooo`@000007`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool00P0000020?ooo`8000000P3oool2000000030?ooo`000000oooo00l0oooo000A0?oooa@0
00008P3ooolD00000280oooo5000000R0?oooaD000004@3oool00100oooo0`0000020?ooo`800000
00@0oooo00000000000000000P3oool200000080oooo0P0000020?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0503oool00`000000oooo000000020?ooo`/0000000@0oooo00000000
0000oooo0P0000090?ooo`030000003oool0oooo01@0oooo00<000000?ooo`0000000P3oool;0000
00040?ooo`00000000000?ooo`8000002@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
000000<0oooo2P0000001`3oool000000000003oool000000?ooo`000000203oool00`000000oooo
0?ooo`050?ooo`003P3oool2000000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`040?ooo`8000001`3oool300000180oooo0P0000070?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0103oool2000000L0oooo0`00000B0?ooo`8000001`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00@0oooo0P0000070?ooo`<000004P3oool2000000L0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo0`00
00050?ooo`003@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0000000A0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`0000004@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool000000140oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0103oool00`000000oooo000000050?ooo`00303oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool2000000P0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo0P0000070?oo
o`800000203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool01`3oool2000000L0oooo0P0000080?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool01@3oool000X0oooo0P00000:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0C0?ooo`8000002@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool04`3oool2000000T0oooo0P0000090?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool04`3oool2000000T0oooo0P0000090?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool000T0oooo0P00000;0?ooo`030000
003oool0oooo0180oooo0P00000B0?ooo`8000002P3oool2000000T0oooo00<000000?ooo`3oool0
203oool300000140oooo0P00000:0?ooo`8000002@3oool00`000000oooo0?ooo`080?ooo`<00000
4@3oool2000000X0oooo0P0000090?ooo`030000003oool0oooo00T0oooo0P0000090?ooo`00203o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00X0oooo0P00000@0?ooo`030000003o
ool0oooo00/0oooo0P0000060?ooo`800000303oool200000100oooo00<000000?ooo`3oool02`3o
ool2000000H0oooo0P00000<0?ooo`800000403oool00`000000oooo0?ooo`0;0?ooo`8000001P3o
ool2000000`0oooo0P0000090?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`8000001P3oool2
000000h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00@0oooo0P00000>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`040?ooo`8000003P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0103oool2000000h0oooo00<000000?ooo`3oool01P3oool0
00H0oooo00<000000?ooo`3oool03`3oool010000000oooo0?ooo`3oool2000000030?ooo`000000
oooo00h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0>0?ooo`80000000@0oooo
000000000000oooo0`00000?0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03P3o
ool2000000030?ooo`00000000000080oooo0P00000?0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool03P3oool2000000040?ooo`00000000000?ooo`<00000403oool00`000000oooo
0?ooo`040?ooo`00103oool2000001<0oooo0`0000030?ooo`030000003oool0oooo00h0oooo0P00
00080?ooo`8000004P3oool9000000l0oooo0P0000080?ooo`8000004P3oool6000000030?ooo`00
0000oooo00l0oooo0P0000080?ooo`8000004P3oool900000100oooo00<000000?ooo`3oool00`3o
ool000<0oooo00<000000?ooo`3oool0603oool300000140oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603oool3
00000140oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0/0?ooo`030000003oool0
oooo0080oooo00020?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0;P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool00@3oool002@0
oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0
oooo00<000000?ooo`3oool0403oool002@0oooo0`00000c0?ooo`<00000<`3oool3000003<0oooo
0`00000@0?ooo`00903oool00`000000oooo0000000c0?ooo`030000003oool0000003<0oooo00<0
00000?ooo`000000<`3oool00`000000oooo0000000@0?ooo`006`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c
0?ooo`030000003oool0oooo0100oooo000K0?ooo`030000003oool0oooo0;/0oooo000H0?ooo`80
000000<0oooo0000003oool0<P3oool00`000000oooo0000000c0?ooo`030000003oool0000003<0
oooo00<000000?ooo`0000006`3oool001P0oooo0P00000d0?ooo`@00000<P3oool400000380oooo
1000000K0?ooo`006@3oool00`000000oooo0?ooo`0b0?ooo`@00000<P3oool400000380oooo1000
000K0?ooo`00CP3oool01@000000oooo0000003oool000000340oooo00D000000?ooo`000000oooo
0000000a0?ooo`050000003oool000000?ooo`0000006P3oool001P0oooo0P00002o0?ooo`00603o
ool200000;l0oooo000K0?ooo`800000_03oool001/0oooo00<000000?ooo`3oool0^`3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`003P3oool0
10000000oooo0?ooo`0000020?ooo`<0000000<0oooo0000000000000P3oool01`000000oooo0?oo
o`000000oooo0000003oool00P0000020?ooo`030000003oool0oooo01X0oooo00@000000?ooo`3o
ool000000P3oool3000000040?ooo`00000000000?ooo`8000000P3oool010000000oooo0000003o
ool2000000030?ooo`000000000001`0oooo00@000000?ooo`3oool000000P3oool3000000040?oo
o`00000000000?ooo`8000000P3oool010000000oooo0000003oool2000000030?ooo`0000000000
01`0oooo00@000000?ooo`3oool000000P3oool3000000030?ooo`000000000000D0oooo00@00000
0?ooo`000000oooo0P00000B0?ooo`003P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool000000P3oool300000080oooo00@000000?ooo`3oool0
0000703oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000000P3oool300000080oooo00@000000?ooo`3oool00000703oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool300000080
oooo00@000000?ooo`3oool00000703oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo0080oooo00@000000?ooo`00000000000P3oool300000080oooo00@000000?ooo`0000000000
3`3oool000h0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`030000
003oool000000080oooo0`0000030?ooo`030000003oool0000001`0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0000003oool00`0000030?oo
o`040000003oool0oooo000001/0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`030?ooo`030000003oool000000080oooo0`0000030?ooo`030000003oool0000001`0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`<000000P3oool3000000<0oooo
0`00000?0?ooo`00303oool4000000D0oooo0P0000020?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0K0?ooo`@000001@3oool200000080oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000001X0
oooo100000050?ooo`8000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000006`3oool3000000D0oooo0P0000020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`00303oool30000
03<0oooo0`00000c0?ooo`<00000=03oool3000002L0oooo000=0?ooo`030000003oool0oooo03<0
oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo02H0
oooo003I0?ooo`00f@3oool00080oooo00<000000?ooo`3oool03`3oool2000001d0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`8000007@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00l0oooo0P00000M0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool03`3oool2000001d0oooo00<000000?ooo`3oool00@3oool000<0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0080oooo00040?ooo`80
00003`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00H0oooo0P00000?0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool2000000l0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`060?ooo`8000003`3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo00<0oooo00060?ooo`030000003oool0oooo00/0oooo0`00000H0?ooo`800000
2`3oool00`000000oooo0?ooo`0;0?ooo`<00000603oool2000000/0oooo00<000000?ooo`3oool0
2`3oool3000001P0oooo0P00000;0?ooo`030000003oool0oooo00/0oooo0`00000I0?ooo`030000
003oool0oooo00@0oooo00070?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool01P3o
ool000P0oooo0P00000S0?ooo`030000003oool0oooo00h0oooo0P00000S0?ooo`030000003oool0
oooo00h0oooo0P00000S0?ooo`030000003oool0oooo00h0oooo0P00000S0?ooo`030000003oool0
oooo00L0oooo00080?ooo`<000007`3oool300000140oooo0`00000O0?ooo`<000004@3oool30000
01l0oooo0`00000A0?ooo`<000007`3oool3000000X0oooo00020?ooo`8000001`3oool00`000000
oooo0?ooo`0L0?ooo`8000003@3oool2000000H0oooo00<000000?ooo`3oool0703oool2000000d0
oooo0P0000060?ooo`030000003oool0oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00T0oooo00020?ooo`<000001`3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool03@3oool3000000H0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`0=0?ooo`<000001P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00/0oooo
00030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0<0?ooo`003P3oool2000001L0oooo00<000000?ooo`3oool06P3oool2000001L0oooo00<00000
0?ooo`3oool06P3oool2000001L0oooo00<000000?ooo`3oool06P3oool2000001L0oooo00<00000
0?ooo`3oool03@3oool00100oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0
oooo0?ooo`0000000P3oool01P000000oooo0?ooo`3oool000000?ooo`8000007`3oool01@000000
oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0
oooo0000003oool00P00000O0?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00@000000?ooo`3oool0oooo0`00000O0?ooo`050000003oool0oooo
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0oooo
0000003oool000000100oooo000A0?oooa@000008P3ooolD00000280oooo00<000000?ooo`000000
4@00000R0?ooo`030000003oool000000080000000<0oooo0000000000003@00000A0?ooo`00403o
ool300000080oooo0P000000103oool000000000000000020?ooo`8000000P3oool200000080oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`<000000P3oool2000000040?oo
o`000000000000000080oooo0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo01@0oooo0`0000020?ooo`80000000@0oooo00000000000000000P3oool20000
0080oooo0P0000020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0503oool30000
0080oooo0P000000103oool000000000000000020?ooo`8000000P3oool2000000<0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`003P3oool2000000L0oooo00<000000?oo
o`3oool0103oool2000000H0oooo0P0000070?ooo`<000004P3oool2000000L0oooo00<000000?oo
o`3oool0103oool2000000H0oooo0P0000070?ooo`<000004P3oool2000000L0oooo00<000000?oo
o`3oool0103oool2000000H0oooo0P0000070?ooo`<000004P3oool2000000L0oooo00<000000?oo
o`3oool0103oool2000000L0oooo00<000000?ooo`3oool01@3oool3000000D0oooo000=0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool000000140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`0000004@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0000000D0oooo000<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo000;0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`8000002@3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3o
ool2000000T0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`002@3oool2
000000/0oooo00<000000?ooo`3oool04P3oool200000180oooo0P00000;0?ooo`030000003oool0
oooo0180oooo0`00000A0?ooo`8000002`3oool00`000000oooo0?ooo`0B0?ooo`<000004@3oool2
000000/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`8000002@3oool0
00P0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0:0?ooo`800000403oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo00X0oooo0P00000@0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool02P3oool200000100oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0:0?ooo`8000002@3oool000L0oooo00<000000?ooo`3oool0303oool2000000H0
oooo0P00000>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool2000000H0
oooo0P00000>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`040?ooo`8000003P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0103oool2000000h0oooo00<000000?ooo`3oool01P3oool000H0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000l0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`0000003`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0000000?0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`030000003oool000000100oooo
00<000000?ooo`3oool0103oool000@0oooo0P00000C0?ooo`@000000P3oool00`000000oooo0?oo
o`0>0?ooo`800000203oool2000001<0oooo100000020?ooo`030000003oool0oooo00h0oooo0P00
00080?ooo`8000004`3oool5000000030?ooo`000000oooo00l0oooo0P0000080?ooo`8000004`3o
ool5000000030?ooo`000000oooo0100oooo00<000000?ooo`3oool00`3oool000<0oooo00<00000
0?ooo`3oool0603oool300000140oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H
0?ooo`<000004@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01P0oooo0`00000A
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603oool300000140oooo00<00000
0?ooo`3oool00P3oool00080oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0^0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`010?oo
o`00903oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`0@0?ooo`00903oool3000003<0oooo0`00000c0?ooo`<00000
<`3oool300000100oooo000T0?ooo`030000003oool0000003<0oooo00<000000?ooo`000000<`3o
ool00`000000oooo0000000c0?ooo`030000003oool000000100oooo000T0?ooo`030000003oool0
oooo03<0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo02X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0@0?ooo`00D@3oool00`00
0000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool06@3oool001P0
oooo1000000c0?ooo`030000003oool000000380oooo0P0000000`3oool000000?ooo`0a0?ooo`80
000000<0oooo0000003oool06P3oool001P0oooo00@000000?ooo`0000000000<`3oool00`000000
oooo0000000b0?ooo`<00000<`3oool2000001d0oooo000H0?ooo`030000003oool0000003<0oooo
0`00000d0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0703oool001T0oooo0P00
000c0?ooo`800000=03oool2000003@0oooo0P00000M0?ooo`00CP3oool2000003@0oooo0P00000d
0?ooo`8000007@3oool008L0oooo0P00000d0?ooo`8000006P3oool008L0oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`0I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool005@0oooo0`0000080?ooo`<00000
2`3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3o
ool00000EP3oool005@0oooo0`0000080?ooo`<00000203oool5000000D0oooo00@000000?ooo`3o
ool000001`3oool010000000oooo0?ooo`00001F0?ooo`00E03oool3000000P0oooo0`00000;0?oo
o`030000003oool0oooo00@0oooo100000070?ooo`@00000EP3oool007@0oooo00@000000?ooo`3o
ool000001`3oool010000000oooo0?ooo`00001F0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo0000\
\>"],
  ImageRangeCache->{{{0, 216.313}, {287, 0}} -> {-0.000440006, -0.0790874, 
  0.406824, 0.406824}, {{0, 54.0625}, {70.4375, 16.375}} -> {-1.00011,
   -89.1283, 0.406941, 0.406941}, {{54.0625, 108.125}, {70.4375, 16.375}} ->
   {-23.0004, -89.1283, 0.406941, 0.406941}, {{108.125, 162.188}, {70.4375, 
  16.375}} -> {-45.0006, -89.1283, 0.406941, 0.406941}, {{162.188, 216.313}, {
  70.4375, 16.375}} -> {-67.0136, -89.1283, 0.406941, 0.406941}, {{0, 
  54.0625}, {124.563, 70.4375}} -> {-1.00011, -67.1153, 0.406941, 0.406941},
   {{54.0625, 108.125}, {124.563, 70.4375}} -> {-23.0004, -67.1153, 0.406941, 
  0.406941}, {{108.125, 162.188}, {124.563, 70.4375}} -> {-45.0006, -67.1153, 
  0.406941, 0.406941}, {{162.188, 216.313}, {124.563, 70.4375}} -> {-66.9246,
   -67.0262, 0.406471, 0.406471}, {{0, 54.0625}, {178.625, 124.563}} ->
   {-1.00011, -45.1023, 0.406941, 0.406941}, {{54.0625, 108.125}, {178.625, 
  124.563}} -> {-23.0004, -45.1023, 0.406941, 0.406941}, {{108.125, 162.188},
   {178.625, 124.563}} -> {-45.0006, -45.1023, 0.406941, 0.406941}, {{162.188,
   216.313}, {178.625, 124.563}} -> {-67.0136, -45.1023, 0.406941, 0.406941},
   {{0, 54.0625}, {232.688, 178.625}} -> {-1.00011, -23.1021, 0.406941, 
  0.406941}, {{54.0625, 108.125}, {232.688, 178.625}} -> {-23.0004, -23.1021, 
  0.406941, 0.406941}, {{108.125, 162.188}, {232.688, 178.625}} -> {-45.0006,
   -23.1021, 0.406941, 0.406941}, {{162.188, 216.313}, {232.688, 178.625}} ->
   {-67.0136, -23.1021, 0.406941, 0.406941}, {{0, 54.0625}, {286.75, 232.688}}
   -> {-1.00011, -1.10185, 0.406941, 0.406941}, {{54.0625, 108.125}, {286.75, 
  232.688}} -> {-23.0004, -1.10185, 0.406941, 0.406941}, {{108.125, 162.188},
   {286.75, 232.688}} -> {-45.0006, -1.10185, 0.406941, 0.406941}, {{162.188, 
  216.313}, {286.75, 232.688}} -> {-67.0136, -1.10185, 0.406941, 0.406941}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.325 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.0113636 0 0.0113636 [
[ 0 0 0 0 ]
[ 1 1.325 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.325 L
0 1.325 L
closepath
clip
newpath
% Start of sub-graphic
p
0 1 0.25 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C2) show
77.812500 14.625000 moveto
(N41) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 1 0.5 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C3) show
77.812500 14.625000 moveto
(N42) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 1 0.75 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C4) show
77.812500 14.625000 moveto
(N43) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 1 1 1.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C5) show
77.812500 14.625000 moveto
(N44) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.75 0.25 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C6) show
77.812500 14.625000 moveto
(N45) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.75 0.5 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C7) show
77.812500 14.625000 moveto
(N46) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.75 0.75 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C8) show
77.812500 14.625000 moveto
(N47) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.75 1 1 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C9) show
77.812500 14.625000 moveto
(N48) show
86.875000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.5 0.25 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
66.250000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C10) show
80.562500 14.625000 moveto
(N49) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.5 0.5 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C11) show
80.562500 14.625000 moveto
(N50) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.5 0.75 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C12) show
80.562500 14.625000 moveto
(N51) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.5 1 0.75 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(n) show
63.125000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
65.750000 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(n) show
63.125000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
65.750000 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C13) show
80.562500 14.625000 moveto
(N52) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0.25 0.25 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(t) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C14) show
80.562500 14.625000 moveto
(N53) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0.25 0.5 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(t) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C15) show
80.562500 14.625000 moveto
(N54) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0.25 0.75 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
66.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(d) show
63.375000 9.125000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 8.437500 moveto
(t) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C16) show
80.562500 14.625000 moveto
(N55) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0.25 1 0.5 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C17) show
80.562500 14.625000 moveto
(N56) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 0.25 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
67.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C18) show
80.562500 14.625000 moveto
(N57) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 0 0.5 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(n) show
63.125000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
65.750000 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(n) show
63.125000 10.687500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
65.750000 15.500000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C19) show
80.562500 14.625000 moveto
(N58) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 0 0.75 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
63.375000 10.187500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.500000 moveto
(t) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C20) show
80.562500 14.625000 moveto
(N59) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 0 1 0.25 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
.04545 .72727 m
.31818 .5 L
s
.16087 .6311 m
.19113 .58221 L
.21441 .61014 L
F
gsave
.16421 .587 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.04545 .27273 m
.31818 .5 L
s
.20277 .40382 m
.17251 .35494 L
.14923 .38287 L
F
gsave
.19943 .35973 -61 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.95455 .72727 m
.68182 .5 L
s
.79723 .59618 m
.82749 .64506 L
.85077 .61713 L
F
gsave
.80057 .64027 -70 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
.95455 .27273 m
.68182 .5 L
s
.83913 .3689 m
.80887 .41779 L
.78559 .38986 L
F
gsave
.83579 .413 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ ] 0 setdash
.42727 .5 m
.42273 .50435 L
.41818 .50803 L
.41364 .5105 L
.40909 .51136 L
.40455 .5105 L
.4 .50803 L
.39545 .50435 L
.39091 .5 L
.38636 .49565 L
.38182 .49196 L
.37727 .4895 L
.37273 .48863 L
.36818 .4895 L
.36364 .49196 L
.35909 .49565 L
.35455 .5 L
.35 .50435 L
.34545 .50803 L
.34091 .5105 L
.33636 .51136 L
.33182 .5105 L
.32727 .50803 L
.32273 .50435 L
.31818 .5 L
s
gsave
.37273 .45704 -65 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Z) show
66.687500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
[ .03 .03 ] 0 setdash
.68182 .5 m
.57273 .5 L
s
gsave
.62727 .5316 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
67.312500 12.312500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
newpath
.5 .51636 .07455 192.68 347.32 arc
s
.47273 .44182 m
.52727 .42364 L
.52727 .46 L
F
gsave
.5 .39885 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(s) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
newpath
.5 .48364 .07455 12.6804 167.32 arc
s
.52727 .55818 m
.47273 .57636 L
.47273 .54 L
F
gsave
.5 .60115 -65.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 6.187500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
63.375000 10.312500 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(~) show
66.312500 15.937500 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.375000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(i) show
66.312500 9.625000 moveto
(t) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
.42727 .5 Mdot
.57273 .5 Mdot
gsave
.5 .02273 -76.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T2) show
70.187500 14.625000 moveto
(C21) show
80.562500 14.625000 moveto
(N60) show
89.625000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 4.937500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.39773 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.44886 1.295 -65 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(e) show
66.812500 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.5 1.295 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
63.000000 14.625000 moveto
(\\256) show
68.750000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1
%%DocumentNeededResources: + font Helvetica
%%DocumentNeededFonts: Math1
%%DocumentNeededFont: + Helvetica
%%DocumentFonts: font Math1
%%DocumentFonts: + font Helvetica
grestore
gsave
.55114 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
gsave
.60227 1.295 -65.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
68.000000 14.625000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 7.437500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Helvetica
%%DocumentNeededFonts: Helvetica
%%DocumentFonts: font Helvetica
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{217.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003I000182000`400?l00000o`00003of@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool000h0oooo00@000000?ooo`00
000000000P3oool300000080oooo00@000000?ooo`00000000000P3oool010000000oooo0000003o
ool2000001l0oooo00@000000?ooo`00000000000P3oool300000080oooo00@000000?ooo`000000
00000P3oool010000000oooo0000003oool2000000030?ooo`000000000001`0oooo00@000000?oo
o`00000000000P3oool3000000040?ooo`00000000000?ooo`8000000P3oool010000000oooo0000
003oool2000000030?ooo`000000000001`0oooo00@000000?ooo`00000000000P3oool300000003
0?ooo`00000000000080oooo00L000000?ooo`3oool000000?ooo`000000oooo0080000000<0oooo
0000000000003`3oool000h0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0000000000080oooo0`0000020?ooo`80000000<0oooo0000003oool06`3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0P000000103oool000000000000000020?ooo`@00000703oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo0080oooo00H000000?ooo`000000oooo0000003oool300000080oooo0P00
00000`3oool000000000000K0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
0P3oool010000000oooo0?ooo`0000020?ooo`<0000000<0oooo0000000000000P0000000`3oool0
00000?ooo`0=0?ooo`003P3oool01`000000oooo0?ooo`3oool000000?ooo`000000103oool01000
0000oooo0000000000020?ooo`<0000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`0J
0?ooo`070000003oool0oooo0?ooo`000000oooo000000040?ooo`060000003oool000000?ooo`00
0000oooo0`000000103oool000000?ooo`3oool2000001`0oooo00L000000?ooo`3oool0oooo0000
003oool0000000D0oooo0`0000020?ooo`<0000000L0oooo0000003oool0oooo0000003oool00000
01/0oooo00L000000?ooo`3oool0oooo0000003oool0000000D0oooo00<000000?ooo`0000000P3o
ool3000000040?ooo`000000oooo0?ooo`8000003`3oool000d0oooo0`0000000`3oool000000?oo
o`020?ooo`8000001@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0000000800000
6P3oool3000000030?ooo`000000oooo0080oooo0P0000050?ooo`040000003oool0oooo000000@0
oooo00@000000?ooo`3oool000006`3oool3000000030?ooo`000000oooo0080oooo0P0000020?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00
000K0?ooo`<0000000<0oooo0000003oool00P3oool200000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000l0oooo000<0?ooo`800000=03o
ool2000003@0oooo0P00000=0?ooo`030000003oool0oooo02D0oooo0P00000<0?ooo`030000003o
ool0oooo01T0oooo000<0?ooo`<00000<`3oool3000000`0oooo00<000000?ooo`3oool0903oool3
000000`0oooo00<000000?ooo`3oool09@3oool3000000/0oooo00<000000?ooo`3oool06@3oool0
00d0oooo00<000000?ooo`3oool0203oool4000002L0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0000000W0?ooo`030000003oool0oooo00P0oooo0P0000000`3oool000000?ooo`0W0?oo
o`030000003oool0oooo00L0oooo0P0000000`3oool000000?ooo`0J0?ooo`00603oool010000000
oooo00000000000c0?ooo`030000003oool000000380oooo0`00000c0?ooo`8000007@3oool00080
oooo00<000000?ooo`3oool04`3oool00`000000oooo0000000H0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool04`3oool3000001P0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool00@3oool000<0oooo
00<000000?ooo`3oool0303oool2000000D0oooo0P00000G0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0303oool2000000@0oooo0P00000H0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0303oool2000000@0oooo0P00000H0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0303oool2000000@0oooo0P00000H0?ooo`030000003oool0oooo0080oooo
00040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool2000001P0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0080oooo0P00
000H0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`020?ooo`800000603oool00`000000oooo0?ooo`020?ooo`001@3oool2000000`0oooo00<00000
0?ooo`3oool06`3oool00`000000oooo0?ooo`070?ooo`800000303oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo00L0oooo0P00000<0?ooo`030000003oool0oooo00D0oooo0P00000D
0?ooo`030000003oool0oooo00L0oooo0P00000<0?ooo`030000003oool0oooo00D0oooo0P00000D
0?ooo`030000003oool0oooo00<0oooo00070?ooo`030000003oool0oooo00P0oooo0`00000J0?oo
o`800000303oool00`000000oooo0?ooo`080?ooo`<000006P3oool2000000`0oooo00<000000?oo
o`3oool0203oool3000000H0oooo00<000000?ooo`3oool04@3oool2000000`0oooo00<000000?oo
o`3oool0203oool3000000H0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`040?oo
o`00203oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool08`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00H0oooo00080?ooo`800000
8`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?ooo`0>0?ooo`800000
8`3oool00`000000oooo0?ooo`0>0?ooo`8000008`3oool00`000000oooo0?ooo`070?ooo`002@3o
ool2000001l0oooo0`00000C0?ooo`030000003oool0oooo01d0oooo0`00000C0?ooo`030000003o
ool0oooo01d0oooo0`00000C0?ooo`030000003oool0oooo01d0oooo0`00000:0?ooo`000P3oool2
000000L0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P0000060?ooo`030000003oool0
oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?ooo`0L0?ooo`8000003@3oool2
000000H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`090?ooo`000P3oool30000
00L0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<000001P3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo00d0oooo0`0000060?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool03@3oool3000000H0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0;0?ooo`000`3oool00`000000oooo0?ooo`070?ooo`8000002P3oool4000000/0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`060?ooo`8000002P3oool4000000/0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`060?ooo`8000002P3oool4000000/0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`060?ooo`8000002P3oool4000000/0
oooo00<000000?ooo`3oool0303oool000l0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03@3oool00100oooo00<0
00000?ooo`3oool00P0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool2000001l0oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool2000001l0oooo00<000000?ooo`3oool00P0000020?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0103oool2000001l0oooo00<000000?ooo`3oool00P00
00020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0>0?ooo`004@3oool7000000H0oooo100000000`3oool000000000000:0?ooo`030000003oool0
oooo01D0oooo1`0000070?ooo`<0000000<0oooo0000000000002P3oool00`000000oooo0?ooo`0E
0?ooo`<0000000@0oooo00000000000000001`3oool3000000030?ooo`000000000000X0oooo00<0
00000?ooo`3oool05@3oool3000000040?ooo`0000000000000000L0oooo0`000000103oool00000
0000000000090?ooo`030000003oool0oooo00D0oooo000@0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo
0`00000D0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00L0oooo0`00000D0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo
0`00000D0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00H0oooo0`0000050?ooo`003P3oool2000000P0oooo0P00
00020?ooo`030000003oool0oooo00L0oooo0P0000070?ooo`030000003oool000000180oooo0P00
00080?ooo`8000000`3oool00`000000oooo0?ooo`060?ooo`8000001`3oool00`000000oooo0000
000B0?ooo`800000203oool2000000<0oooo00<000000?ooo`3oool01P3oool2000000L0oooo00<0
00000?ooo`0000004P3oool2000000P0oooo0P0000030?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo000000050?ooo`003@3oool00`000000oooo0?ooo`09
0?ooo`<00000303oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool02@3oool4000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo00T0oooo1000000;0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`090?ooo`@000002`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo000<0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool06P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool02`3oool000X0oooo0P00000N0?ooo`030000003oool0oooo01<0oooo0P00000N0?ooo`03
0000003oool0oooo01<0oooo0P00000N0?ooo`030000003oool0oooo01<0oooo0P00000O0?ooo`03
0000003oool0oooo00T0oooo00090?ooo`800000803oool200000180oooo0P00000P0?ooo`<00000
4@3oool200000200oooo0`00000A0?ooo`8000008@3oool2000000T0oooo00080?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool02`3oool200000100oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0;0?ooo`800000403oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo00/0oooo0P00000@0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02`3o
ool2000000T0oooo00070?ooo`030000003oool0oooo01@0oooo0`00000=0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0503oool3000000d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0D0?ooo`<000003@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo01@0oooo0`00000=0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo
01D0oooo00@000000?ooo`000000oooo0P00000;0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool05@3oool010000000oooo0000003oool2000000/0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0B0?ooo`070000003oool0oooo0000003oool000000?ooo`02000000/0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`060000003oool000000?oo
o`000000oooo0P00000<0?ooo`030000003oool0oooo00@0oooo00040?ooo`800000603oool01000
0000oooo0?ooo`3oool2000000`0oooo0P0000080?ooo`8000005@3oool010000000oooo0?ooo`00
00030?ooo`800000303oool2000000P0oooo0P00000E0?ooo`040000003oool0oooo000000<0oooo
0P00000<0?ooo`800000203oool2000001H0oooo00<000000?ooo`0000000`3oool2000000d0oooo
00<000000?ooo`3oool00`3oool000<0oooo00<000000?ooo`3oool04P3oool4000000H0oooo0P00
000>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04`3oool00`000000oooo0000
00060?ooo`8000003P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0180oooo0P00
00000`3oool000000?ooo`050?ooo`8000003P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0180oooo0P0000020?ooo`030000003oool0oooo00<0oooo0P00000>0?ooo`030000003o
ool0oooo0080oooo00020?ooo`030000003oool0oooo01<0oooo00@000000?ooo`00000000005`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01@0oooo00<000000?ooo`0000005`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01<0oooo0`00000H0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool04`3oool2000001T0oooo00<000000?ooo`3oool00@3o
ool001P0oooo00<000000?ooo`0000002@3oool00`000000oooo0?ooo`0W0?ooo`<000002@3oool0
0`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0100oooo000I0?ooo`8000002@3oool30000
02L0oooo0P00000:0?ooo`<00000:03oool2000000T0oooo0`00000X0?ooo`8000002@3oool30000
0100oooo000T0?ooo`030000003oool0000002L0oooo0P00000:0?ooo`030000003oool0000002P0
oooo0P0000090?ooo`030000003oool0000002P0oooo0P0000090?ooo`030000003oool000000100
oooo000T0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`0@0?ooo`00Q`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01P0oooo0027
0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0603oool00=T0oooo003I0?ooo`00
f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?oo
o`00f@3oool00=T0oooo003I0?ooo`003P3oool010000000oooo0000000000020?ooo`<000000P3o
ool00`000000oooo0?ooo`030?ooo`040000003oool000000?ooo`80000000<0oooo000000000000
703oool010000000oooo0000000000020?ooo`<000000P3oool010000000oooo0000000000020?oo
o`040000003oool000000?ooo`8000007`3oool010000000oooo0000000000020?ooo`<000000P3o
ool010000000oooo0000000000020?ooo`040000003oool000000?ooo`80000000<0oooo00000000
0000703oool010000000oooo0000000000020?ooo`<000000P3oool00`000000oooo0?ooo`030?oo
o`040000003oool000000?ooo`80000000<0oooo0000000000003`3oool000h0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0000000000080oooo0`00
00020?ooo`80000000<0oooo0000003oool06`3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00P000000103oool000000000000000020?ooo`@0
0000703oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`0000000P000000103oool000000000000000020?ooo`80000000<0oooo0000000000006`3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
0P3oool300000080oooo1@00000>0?ooo`003P3oool01`000000oooo0?ooo`3oool000000?ooo`00
0000103oool010000000oooo0000000000020?ooo`<0000000<0oooo0000003oool00P3oool00`00
0000oooo0?ooo`0J0?ooo`070000003oool0oooo0?ooo`000000oooo000000040?ooo`030000003o
ool0000000<0oooo0`000000103oool000000?ooo`3oool2000001`0oooo00L000000?ooo`3oool0
oooo0000003oool0000000@0oooo00<000000?ooo`0000000`3oool3000000050?ooo`000000oooo
0?ooo`0000007@3oool01`000000oooo0?ooo`3oool000000?ooo`000000103oool010000000oooo
0?ooo`0000020?ooo`<0000000D0oooo0000003oool0oooo0000000@0?ooo`003@3oool300000003
0?ooo`000000oooo0080oooo0P0000080?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000006`3oool3000000030?ooo`000000oooo0080oooo0P0000050?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool0703oool3000000030?ooo`000000oooo0080oooo0P000005
0?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000006`3oool3000000030?oo
o`000000oooo0080oooo0P0000040?ooo`<0000000<0oooo0000003oool00`3oool010000000oooo
0?ooo`00000?0?ooo`00303oool2000000d0oooo00<000000?ooo`3oool0903oool2000000d0oooo
00<000000?ooo`3oool0903oool2000000d0oooo00<000000?ooo`3oool09@3oool2000002P0oooo
000<0?ooo`<00000303oool00`000000oooo0?ooo`0T0?ooo`<00000303oool00`000000oooo0?oo
o`0T0?ooo`<00000303oool00`000000oooo0?ooo`0U0?ooo`<000009`3oool000d0oooo00<00000
0?ooo`3oool0203oool2000000030?ooo`000000oooo02H0oooo00<000000?ooo`3oool0203oool2
000000030?ooo`000000oooo02H0oooo00<000000?ooo`3oool0203oool2000000030?ooo`000000
oooo02L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0L0?ooo`00603oool30000
03<0oooo0P00000d0?ooo`800000=03oool3000001`0oooo000I0?ooo`030000003oool0oooo0380
oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0b0?ooo`030000003oool0000001`0
oooo00020?ooo`030000003oool0oooo00d0oooo0P0000040?ooo`8000006@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00d0oooo0P0000040?ooo`8000006@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00d0oooo0P00000O0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool03@3oool2000000@0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`010?ooo`000`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo0P00
000H0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`020?ooo`800000603oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool00P3oool2000001P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool00P3oool000@0oooo0P00000=
0?ooo`030000003oool0oooo00D0oooo0P00000D0?ooo`030000003oool0oooo00H0oooo0P00000=
0?ooo`030000003oool0oooo00D0oooo0P00000D0?ooo`030000003oool0oooo00H0oooo0P00000=
0?ooo`030000003oool0oooo0080oooo0P00000G0?ooo`030000003oool0oooo00H0oooo0P00000=
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool00`3oool000H0oooo00<000000?oo
o`3oool02@3oool3000000H0oooo00<000000?ooo`3oool04@3oool2000000/0oooo00<000000?oo
o`3oool02@3oool3000000H0oooo00<000000?ooo`3oool04@3oool2000000/0oooo00<000000?oo
o`3oool02@3oool3000000H0oooo0P00000B0?ooo`8000002`3oool00`000000oooo0?ooo`090?oo
o`<000006`3oool00`000000oooo0?ooo`040?ooo`001`3oool00`000000oooo0?ooo`0T0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool01P3oool000P0oooo0P00000S0?ooo`030000
003oool0oooo00h0oooo0P00000S0?ooo`030000003oool0oooo00h0oooo0P00000S0?ooo`030000
003oool0oooo00h0oooo0P00000S0?ooo`030000003oool0oooo00L0oooo00080?ooo`<000007`3o
ool300000140oooo0`00000O0?ooo`<000004@3oool3000001l0oooo0`00000A0?ooo`<000007`3o
ool3000000X0oooo00020?ooo`8000001`3oool00`000000oooo0?ooo`0L0?ooo`8000003@3oool2
000000H0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P0000060?ooo`030000003oool0
oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo00T0oooo00020?ooo`<000001`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03@3oool30000
00H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<000001P3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo00/0oooo00030?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool02@3oool4000000/0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo1000000;0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`@000002`3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool4000000/0
oooo00<000000?ooo`3oool0303oool000h0oooo0P00000=0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool06P3oool2000000d0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0J0?ooo`8000003@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01X0oooo
0P0000080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0=0?ooo`00403oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`8000007`3oool00`000000oooo0?ooo`02000000<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`8000007`3oool00`000000oooo0?oo
o`02000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`8000007`3o
ool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00h0oooo000A0?ooo`L000001P3oool4000000030?ooo`000000
00000280oooo1`0000070?ooo`<0000000<0oooo0000000000008P3oool3000000040?ooo`000000
0000000000L0oooo0`0000000`3oool000000000000R0?ooo`<0000000@0oooo0000000000000000
1P3oool4000000040?ooo`000000000000000140oooo000@0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01@3oool000h0oooo0P0000080?ooo`8000000P3oool00`000000oooo0?oo
o`070?ooo`8000001`3oool300000180oooo0P0000080?ooo`8000000`3oool00`000000oooo0?oo
o`060?ooo`8000001`3oool300000180oooo0P0000080?ooo`8000000`3oool00`000000oooo0?oo
o`060?ooo`8000001`3oool300000180oooo0P0000080?ooo`8000000`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00D0oooo0`0000050?ooo`003@3oool00`000000oooo0?ooo`09
0?ooo`<00000303oool00`000000oooo0?ooo`040?ooo`030000003oool000000140oooo00<00000
0?ooo`3oool02@3oool4000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A
0?ooo`030000003oool0oooo00T0oooo1000000;0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`0000004@3oool00`000000oooo0?ooo`090?ooo`@000002`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0000000D0oooo000<0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`050?ooo`002P3oool2000001h0oooo00<000000?ooo`3o
ool04`3oool2000001h0oooo00<000000?ooo`3oool04`3oool2000001h0oooo00<000000?ooo`3o
ool04`3oool2000001l0oooo00<000000?ooo`3oool02@3oool000T0oooo0P00000P0?ooo`800000
4P3oool200000200oooo0`00000A0?ooo`800000803oool300000140oooo0P00000Q0?ooo`800000
2@3oool000P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`800000403o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo0P00000@0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool02P3oool200000100oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0;0?ooo`8000002@3oool000L0oooo00<000000?ooo`3oool0503oool2
000000h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0D0?ooo`8000003P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01D0oooo0P00000=0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0503oool3000000d0oooo00<000000?ooo`3oool01P3oool0
00H0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0200000080oooo0P00000;0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`020000
0080oooo0P00000;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04P3oool01000
0000oooo0?ooo`3oool2000000030?ooo`000000000000/0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0E0?ooo`040000003oool000000?ooo`800000303oool00`000000oooo0?oo
o`040?ooo`00103oool2000001D0oooo00@000000?ooo`3oool000000`3oool2000000`0oooo0P00
00080?ooo`8000005@3oool010000000oooo0?ooo`0000030?ooo`800000303oool2000000P0oooo
0P00000E0?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000`0oooo0P0000080?ooo`80
0000603oool010000000oooo0?ooo`3oool2000000d0oooo00<000000?ooo`3oool00`3oool000<0
oooo00<000000?ooo`3oool04P3oool2000000030?ooo`000000oooo00D0oooo0P00000>0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool2000000030?ooo`000000oooo00D0
oooo0P00000>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool200000003
0?ooo`000000oooo00D0oooo0P00000>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`070?ooo`8000003P3oool00`000000oooo0?ooo`020?ooo`00
0P3oool00`000000oooo0?ooo`0C0?ooo`<00000603oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo01<0oooo0P00000I0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
4`3oool2000001T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0C0?ooo`<00000
603oool00`000000oooo0?ooo`010?ooo`006@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool09`3oool00`000000oooo000000090?ooo`030000003o
ool0oooo0100oooo000H0?ooo`8000002P3oool3000002L0oooo0P00000:0?ooo`<00000<`3oool3
000002L0oooo00<000000?ooo`3oool02@3oool300000100oooo000H0?ooo`8000002P3oool00`00
0000oooo0000000W0?ooo`8000002P3oool00`000000oooo0000000X0?ooo`8000002@3oool00`00
0000oooo0000000c0?ooo`030000003oool000000100oooo000K0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02P0
oooo0P0000090?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0403oool001/0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo04l0oooo
000K0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?oo
o`1?0?ooo`00Q`3oool00`000000oooo0?ooo`1?0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3o
ool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00
f@3oool000h0oooo00@000000?ooo`00000000000P3oool300000080oooo00@000000?ooo`000000
00000P3oool00`000000oooo000000040?ooo`800000703oool010000000oooo0000000000020?oo
o`<000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool000000?ooo`80000000<0
oooo000000000000703oool010000000oooo0000000000020?ooo`<000000P3oool010000000oooo
0000000000020?ooo`040000003oool000000?ooo`8000000P3oool00`000000oooo0?ooo`0J0?oo
o`040000003oool0000000000080oooo0`0000020?ooo`040000003oool0000000000080oooo00@0
00000?ooo`000000oooo0P0000000`3oool000000000000?0?ooo`003P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo0080oooo00H000000?ooo`000000oooo0000003oool30000
00030?ooo`00000000000080oooo0P00000K0?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`<000000P3oool3000000030?ooo`00
0000oooo01X0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`040000
003oool0oooo00000080oooo0`0000020?ooo`80000000<0oooo0000003oool06`3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool3
00000080oooo0P0000000`3oool000000?ooo`0>0?ooo`003P3oool01`000000oooo0?ooo`3oool0
00000?ooo`000000103oool010000000oooo0000000000020?ooo`<0000000L0oooo000000000000
oooo0000003oool0000001/0oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo00@0
00000?ooo`3oool000000P3oool3000000040?ooo`000000oooo0?ooo`800000703oool01`000000
oooo0?ooo`3oool000000?ooo`000000103oool01P000000oooo0?ooo`3oool000000?ooo`<00000
00<0oooo0000003oool00P3oool00`000000oooo0?ooo`0J0?ooo`070000003oool0oooo0?ooo`00
0000oooo000000040?ooo`040000003oool0oooo00000080oooo0`0000000`3oool000000?ooo`03
0?ooo`030000003oool0oooo00`0oooo000=0?ooo`<0000000<0oooo0000003oool00P3oool20000
00D0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`0I0?ooo`<0000000<0oooo
0000003oool00P3oool2000000P0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00
000K0?ooo`<0000000<0oooo0000003oool00P3oool2000000D0oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`0L0?ooo`<0000000<0oooo0000003oool00P3oool2000000D0oooo
00@000000?ooo`3oool00000103oool010000000oooo0?ooo`00000?0?ooo`00303oool2000000d0
oooo00<000000?ooo`3oool0903oool2000003@0oooo0P00000e0?ooo`800000:03oool000`0oooo
0`00000<0?ooo`030000003oool0oooo02@0oooo0`00000c0?ooo`<00000=03oool3000000/0oooo
00<000000?ooo`3oool06@3oool000d0oooo00<000000?ooo`3oool0203oool2000000030?ooo`00
0000oooo02H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo00P0oooo1000000X0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`0000006`3o
ool001P0oooo0P00000d0?ooo`<00000<`3oool010000000oooo00000000000c0?ooo`030000003o
ool0000001/0oooo000B0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0<P3oool0
0`000000oooo0000000c0?ooo`030000003oool0000003<0oooo0`00000L0?ooo`000P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0=0?ooo`800000103oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool03@3oool2000000D0oooo0P00000H0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool03@3oool2000000@0oooo0P00000I0?ooo`030000003oool0oooo
0040oooo00030?ooo`030000003oool0oooo00/0oooo00<000000?ooo`000000103oool2000001P0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0080
oooo0P00000H0?ooo`030000003oool0oooo0080oooo00040?ooo`800000303oool3000000<0oooo
0P00000G0?ooo`030000003oool0oooo00H0oooo0P00000=0?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool01P3oool2000000d0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`060?ooo`8000003@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00<0oooo
00060?ooo`030000003oool0oooo0180oooo0P00000B0?ooo`8000002`3oool00`000000oooo0?oo
o`090?ooo`<000006P3oool2000000/0oooo00<000000?ooo`3oool02@3oool3000001X0oooo0P00
000;0?ooo`030000003oool0oooo00T0oooo0`00000K0?ooo`030000003oool0oooo00@0oooo0007
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`06
0?ooo`00203oool2000002<0oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?oo
o`3oool03P3oool2000002<0oooo00<000000?ooo`3oool03P3oool2000002<0oooo00<000000?oo
o`3oool01`3oool000P0oooo0`00000O0?ooo`<000004@3oool3000001l0oooo0`00000A0?ooo`<0
00007`3oool300000140oooo0`00000O0?ooo`<000002P3oool00080oooo0P0000070?ooo`030000
003oool0oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?ooo`0L0?ooo`800000
3@3oool2000000H0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P0000060?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool02@3oool00080oooo0`0000070?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool03@3oool3000000H0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`0=0?ooo`<000001P3oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool02`3o
ool000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`@000002`3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool4
000000/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00T0oooo1000000;0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`090?ooo`@000002`3oool00`000000oooo0?ooo`0<0?ooo`003P3oool20000
00d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0J0?ooo`8000003@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo01X0oooo0P00000=0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool06P3oool2000000h0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0=0?ooo`00403oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`050?ooo`8000007`3oool00`000000oooo0?ooo`02000000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`8000007`3oool00`000000
oooo0?ooo`02000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`80
00007`3oool00`000000oooo0?ooo`02000000<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00h0oooo000A0?ooo`L000001P3oool4000000030?oo
o`00000000000280oooo1`0000060?ooo`@0000000<0oooo0000000000008P3oool3000000040?oo
o`0000000000000000H0oooo100000000`3oool000000000000R0?ooo`<0000000@0oooo00000000
000000001P3oool4000000040?ooo`000000000000000140oooo000@0?ooo`030000003oool00000
00<0oooo0P0000060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0000000<0oooo0P0000060?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool00000
00<0oooo0P0000060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0000000<0oooo0P0000060?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`003P3oool2000000P0
oooo00D000000?ooo`3oool0oooo000000090?ooo`8000001`3oool300000180oooo0P0000080?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool2000000L0oooo0`00000B0?oo
o`800000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo0P0000070?oo
o`<000004P3oool2000000P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00D0oooo0`0000050?ooo`003@3oool00`000000oooo0?ooo`090?ooo`<0
0000303oool00`000000oooo0?ooo`040?ooo`030000003oool000000140oooo00<000000?ooo`3o
ool02@3oool4000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A0?ooo`03
0000003oool0oooo00T0oooo1000000;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`00
00004@3oool00`000000oooo0?ooo`090?ooo`@000002`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0000000D0oooo000<0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`050?ooo`002P3oool2000001h0oooo00<000000?ooo`3oool04`3o
ool2000001h0oooo00<000000?ooo`3oool04`3oool2000001h0oooo00<000000?ooo`3oool04`3o
ool2000001l0oooo00<000000?ooo`3oool02@3oool000T0oooo0P00000P0?ooo`8000004P3oool2
00000200oooo0`00000A0?ooo`800000803oool300000140oooo0P00000Q0?ooo`8000002@3oool0
00P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`800000403oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo0P00000@0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool02P3oool200000100oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0:0?ooo`8000002@3oool000L0oooo00<000000?ooo`3oool0503oool3000000d0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0D0?ooo`8000003P3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo01D0oooo0P00000=0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool05@3oool2000000d0oooo00<000000?ooo`3oool01P3oool000H0oooo
00<000000?ooo`3oool04P3oool01`000000oooo0?ooo`000000oooo0000003oool00P00000;0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool05@3oool200000080oooo0P00000;0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool05P3oool2000000030?ooo`0000000000
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0F0?ooo`80000000<0oooo0000
00000000303oool00`000000oooo0?ooo`040?ooo`00103oool2000001D0oooo00@000000?ooo`3o
ool000000`3oool2000000`0oooo0P0000080?ooo`800000603oool010000000oooo0?ooo`3oool2
000000`0oooo0P0000080?ooo`8000006@3oool00`000000oooo0?ooo`02000000`0oooo0P000008
0?ooo`8000005@3oool01@000000oooo0?ooo`3oool000000080oooo0P00000=0?ooo`030000003o
ool0oooo00<0oooo00030?ooo`030000003oool0oooo0180oooo0P0000000`3oool000000?ooo`05
0?ooo`8000003P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool01`3oool2000000h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0B
0?ooo`@000001P3oool2000000h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0000000H0oooo0P00000>0?ooo`030000003oool0oooo0080oooo00020?oo
o`030000003oool0oooo01<0oooo0P00000I0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool04`3oool3000001P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0C0?oo
o`040000003oool00000000001L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0D
0?ooo`030000003oool0000001L0oooo00<000000?ooo`3oool00@3oool001T0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0W0?ooo`030000003oool0000000T0oooo00<000000?oo
o`3oool09`3oool00`000000oooo000000090?ooo`030000003oool0oooo02L0oooo0`0000090?oo
o`030000003oool0oooo0100oooo000T0?ooo`<000009`3oool00`000000oooo0?ooo`090?ooo`<0
0000:03oool2000000T0oooo0`00000W0?ooo`8000002P3oool300000100oooo000H0?ooo`800000
2P3oool00`000000oooo0000000c0?ooo`030000003oool0000003<0oooo00<000000?ooo`000000
9`3oool2000000X0oooo00<000000?ooo`000000403oool001P0oooo0P00000:0?ooo`030000003o
ool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?ooo`030000003o
ool0oooo0100oooo000K0?ooo`800000_03oool001/0oooo00<000000?ooo`3oool0^`3oool00=T0
oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool0
0=T0oooo003I0?ooo`00f@3oool00=T0oooo003I0?ooo`00f@3oool00100oooo00@000000?ooo`00
000000000P3oool3000000070?ooo`00000000000?ooo`000000oooo000000040?ooo`800000803o
ool010000000oooo0000000000020?ooo`<00000103oool00`000000oooo000000040?ooo`800000
803oool010000000oooo0000000000020?ooo`<0000000L0oooo000000000000oooo0000003oool0
000002H0oooo00@000000?ooo`00000000000P3oool3000000030?ooo`00000000000080oooo00<0
00000?ooo`000000103oool200000100oooo000@0?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool0oooo1P0000000`3oool00000000000020?ooo`8000007`3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000P000000103oool0
00000000003oool3000001l0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`3o
ool2000000050?ooo`00000000000000003oool00P0000020?ooo`030000003oool0oooo01h0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`80000000D0oooo00000000
000000000?ooo`02000000030?ooo`00000000000100oooo000@0?ooo`070000003oool0oooo0?oo
o`000000oooo000000030?ooo`030000003oool0oooo00<0000000D0oooo000000000000oooo0000
000Q0?ooo`070000003oool0oooo0?ooo`000000oooo000000040?ooo`030000003oool000000080
000000D0oooo000000000000oooo0000000Q0?ooo`070000003oool0oooo0?ooo`000000oooo0000
00030?ooo`80000000D0oooo00000000000000000?ooo`0200000080oooo00<000000?ooo`3oool0
7P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool010000000oooo0000003oool3
000000040?ooo`00000000000?ooo`800000403oool000`0oooo0P0000001P3oool0000000000000
0000oooo000000<0oooo0P0000020?ooo`030000003oool0000000L0oooo00<000000?ooo`3oool0
6P3oool2000000060?ooo`00000000000000003oool000000`3oool2000000030?ooo`0000000000
008000001`3oool00`000000oooo0?ooo`0J0?ooo`80000000H0oooo00000000000000000?ooo`00
00030?ooo`8000000P3oool00`000000oooo000000060?ooo`<000006`3oool2000000060?ooo`00
000000000000003oool000000`3oool200000080oooo00@000000?ooo`3oool000001`3oool00`00
0000oooo0?ooo`0>0?ooo`00303oool3000003<0oooo0`00000c0?ooo`<00000303oool00`000000
oooo0?ooo`0T0?ooo`<00000303oool00`000000oooo0?ooo`0I0?ooo`003@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0203oool4000002L0oooo
00<000000?ooo`3oool0203oool2000000030?ooo`000000oooo02H0oooo00<000000?ooo`3oool0
203oool2000000030?ooo`000000oooo01X0oooo000H0?ooo`<00000<`3oool010000000oooo0000
0000000b0?ooo`@00000<P3oool2000000030?ooo`000000oooo01X0oooo000B0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`000000;@3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000002d0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0703oool00080oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo0P00000H0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`8000006@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool2
000001T0oooo00<000000?ooo`3oool00@3oool000<0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0000000N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0000000N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo000000040?ooo`800000603oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`000000103oool2000001P0oooo00<000000?ooo`3oool00P3oool000@0
oooo0P00000<0?ooo`<00000703oool00`000000oooo0?ooo`060?ooo`800000303oool3000001`0
oooo00<000000?ooo`3oool01P3oool2000000`0oooo0`0000060?ooo`800000503oool00`000000
oooo0?ooo`060?ooo`800000303oool3000000H0oooo0P00000D0?ooo`030000003oool0oooo00<0
oooo00060?ooo`030000003oool0oooo02H0oooo0P00000;0?ooo`030000003oool0oooo02H0oooo
0P00000;0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool2000000/0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00@0oooo
00070?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool01P3oool000P0oooo0P00000S
0?ooo`030000003oool0oooo00h0oooo0P00000S0?ooo`030000003oool0oooo00h0oooo0P00000S
0?ooo`030000003oool0oooo00h0oooo0P00000S0?ooo`030000003oool0oooo00L0oooo00080?oo
o`<000007`3oool300000140oooo0`00000O0?ooo`<000004@3oool3000001l0oooo0`00000A0?oo
o`<000007`3oool3000000X0oooo00020?ooo`8000001`3oool00`000000oooo0?ooo`0L0?ooo`80
00003@3oool2000000H0oooo00<000000?ooo`3oool0703oool2000000d0oooo0P0000060?ooo`03
0000003oool0oooo01`0oooo0P00000=0?ooo`8000001P3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo00T0oooo00020?ooo`<000001`3oool00`000000oooo0?ooo`0J0?ooo`030000
003oool0oooo00d0oooo0`0000060?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
3@3oool3000000H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`<00000
1P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00/0oooo00030?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool02@3oool4000000/0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo1000000;0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`@000002`3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3o
ool4000000/0oooo00<000000?ooo`3oool0303oool000h0oooo0P0000090?ooo`050000003oool0
oooo0?ooo`0000002@3oool00`000000oooo0?ooo`0J0?ooo`8000002@3oool01@000000oooo0?oo
o`3oool0000000T0oooo00<000000?ooo`3oool06P3oool2000000T0oooo00D000000?ooo`3oool0
oooo000000090?ooo`030000003oool0oooo01X0oooo0P0000090?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`00403oool00`000000oooo
0?ooo`0200000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`800000
7`3oool00`000000oooo0?ooo`02000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`050?ooo`8000007`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`050?ooo`8000007`3oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00h0oooo000A0?ooo`L000001P3oool4000000030?ooo`00000000000280oooo1`0000060?ooo`@0
000000<0oooo0000000000008P3oool7000000H0oooo100000000`3oool000000000000R0?ooo`L0
00001P3oool4000000040?ooo`000000000000000140oooo000@0?ooo`<000000P3oool3000000H0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`0000000P3oool3000000H0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo00<000000?ooo`0000000P3oool3000000H0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`0000000`3oool2000000H0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo000>0?ooo`800000203oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00H0oooo0P0000070?ooo`<000004P3oool2000000P0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`8000001`3oool300000180oooo
0P0000080?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool2000000L0oooo
0`00000B0?ooo`800000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01@3oool3000000D0oooo000=0?ooo`030000003oool0oooo00T0oooo1000
000;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000004@3oool00`000000oooo0?oo
o`090?ooo`@000002`3oool00`000000oooo0?ooo`040?ooo`030000003oool000000140oooo00<0
00000?ooo`3oool02@3oool4000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo0000
000A0?ooo`030000003oool0oooo00T0oooo1000000;0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`0000001@3oool000`0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00D0oooo000:0?ooo`8000007P3oool00`000000oooo0?ooo`0C0?oo
o`8000007P3oool00`000000oooo0?ooo`0C0?ooo`8000007P3oool00`000000oooo0?ooo`0C0?oo
o`8000007`3oool00`000000oooo0?ooo`090?ooo`002@3oool200000200oooo0P00000B0?ooo`80
0000803oool300000140oooo0P00000P0?ooo`<000004@3oool200000240oooo0P0000090?ooo`00
203oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo0P00000@0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool02`3oool200000100oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0;0?ooo`800000403oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo00/0oooo0P0000090?ooo`001`3oool00`000000oooo0?ooo`0D0?ooo`<000003@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01@0oooo0`00000=0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0503oool3000000d0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0D0?ooo`<000003@3oool00`000000oooo0?ooo`060?ooo`001P3oool0
0`000000oooo0?ooo`0E0?ooo`040000003oool000000?ooo`8000002`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo01D0oooo00@000000?ooo`000000oooo0P00000;0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool05@3oool010000000oooo0000003oool2000000/0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E0?ooo`040000003oool000000?oo
o`800000303oool00`000000oooo0?ooo`040?ooo`00103oool2000001P0oooo00@000000?ooo`3o
ool0oooo0P00000<0?ooo`800000203oool2000001P0oooo00@000000?ooo`3oool0oooo0P00000<
0?ooo`800000203oool2000001D0oooo00@000000?ooo`3oool000000`3oool2000000`0oooo0P00
00080?ooo`8000005@3oool010000000oooo0?ooo`0000030?ooo`8000003@3oool00`000000oooo
0?ooo`030?ooo`000`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00L0oooo0P00
000>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool4000000H0oooo0P00
000>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool2000000030?ooo`00
0000oooo00D0oooo0P00000>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04P3o
ool2000000030?ooo`000000oooo00D0oooo0P00000>0?ooo`030000003oool0oooo0080oooo0002
0?ooo`030000003oool0oooo01<0oooo0`00000H0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool04`3oool010000000oooo00000000000G0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool04`3oool4000001L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0C0?ooo`80000000<